/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.get;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.table.api.Table;
import java.util.Map;

public class Get {
    private Table client;
    private String tableName;
    protected Row rowKey;
    protected String[] selectColumns;

    public Get() {
        this.tableName = null;
        this.client = null;
        this.rowKey = null;
        this.selectColumns = null;
    }

    public Get(Table client, String tableName) {
        this.client = client;
        this.tableName = tableName;
    }

    public Get setRowKey(Row rowKey) {
        this.rowKey = rowKey;
        if (null != this.tableName && ((ObTableClient)this.client).getRowKeyElement(this.tableName) == null) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, this.rowKey.getColumns());
        }
        return this;
    }

    public Get setRowKey(ColumnValue ... rowKey) {
        this.rowKey = new Row(rowKey);
        if (null != this.tableName && ((ObTableClient)this.client).getRowKeyElement(this.tableName) == null) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, this.rowKey.getColumns());
        }
        return this;
    }

    public Row getRowKey() {
        return this.rowKey;
    }

    public Get select(String ... columns) {
        this.selectColumns = columns;
        return this;
    }

    public String[] getSelectColumns() {
        return this.selectColumns;
    }

    public Map<String, Object> execute() throws Exception {
        if (this.client == null) {
            throw new IllegalArgumentException("client is null");
        }
        return ((ObTableClient)this.client).get(this.tableName, this.rowKey, this.selectColumns);
    }
}

