/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import java.util.HashMap;
import java.util.Map;

public enum ObReadConsistency {
    STRONG(0),
    WEAK(1);

    private int value;
    private static Map<Integer, ObReadConsistency> map;

    private ObReadConsistency(int value) {
        this.value = value;
    }

    public static ObReadConsistency valueOf(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public byte getByteValue() {
        return (byte)this.value;
    }

    public static ObReadConsistency getByName(String consistency) {
        if (consistency.equalsIgnoreCase("weak")) {
            return WEAK;
        }
        return STRONG;
    }

    public boolean isStrong() {
        return this.value == ObReadConsistency.STRONG.value;
    }

    public boolean isWeak() {
        return this.value == ObReadConsistency.WEAK.value;
    }

    public ObTableConsistencyLevel toObTableConsistencyLevel() {
        if (this.isWeak()) {
            return ObTableConsistencyLevel.EVENTUAL;
        }
        return ObTableConsistencyLevel.STRONG;
    }

    static {
        map = new HashMap<Integer, ObReadConsistency>();
        for (ObReadConsistency type : ObReadConsistency.values()) {
            map.put(type.value, type);
        }
    }
}

