/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.ObRoutePolicy;
import java.util.HashSet;
import java.util.Set;

public class ObServerRoute {
    public static ObServerRoute STRONG_READ = new ObServerRoute(ObReadConsistency.STRONG);
    private ObReadConsistency readConsistency;
    private ObRoutePolicy readRoutePolicy;
    private boolean isLdcUsed;
    private Set<String> blackIpList = new HashSet<String>();

    private ObServerRoute(ObReadConsistency readConsistency) {
        this(readConsistency, ObRoutePolicy.IDC_ORDER, false);
    }

    public ObServerRoute(ObReadConsistency readConsistency, ObRoutePolicy readRoutePolicy, boolean isLdcUsed) {
        this.readConsistency = readConsistency;
        this.readRoutePolicy = readRoutePolicy;
        this.isLdcUsed = isLdcUsed;
    }

    public ObReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public ObRoutePolicy getReadRoutePolicy() {
        return this.readRoutePolicy;
    }

    public boolean isLdcEnabled() {
        return this.isLdcUsed;
    }

    public void reset() {
        this.blackIpList.clear();
    }

    public boolean isInBlackList(String ip) {
        return this.blackIpList.contains(ip);
    }

    public void addToBlackList(String ip) {
        this.blackIpList.add(ip);
    }

    public void setBlackList(Set<String> blackIpList) {
        if (blackIpList != null) {
            this.blackIpList = blackIpList;
        }
    }
}

