/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.location.model.TableEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class RouteTableRefresher
extends Thread {
    private static final Logger logger = TableClientLoggerFactory.getLogger(RouteTableRefresher.class);
    private volatile AtomicBoolean isFinished = new AtomicBoolean(false);
    private final Semaphore semaphore = new Semaphore(0);
    private volatile ConcurrentLinkedQueue<ObPair<String, Boolean>> refreshTableTasks;
    ObTableClient client;
    private final Lock lock = new ReentrantLock();

    public RouteTableRefresher(ObTableClient client) {
        this.client = client;
    }

    public void finish() {
        this.isFinished.set(true);
    }

    @Override
    public void run() {
        this.refreshTableTasks = new ConcurrentLinkedQueue();
        while (!this.isFinished.get()) {
            try {
                this.semaphore.acquire();
                logger.info("Thread name {}, id{} acquire semaphore, begin execute route refresher", (Object)RouteTableRefresher.currentThread().getName(), (Object)RouteTableRefresher.currentThread().getId());
            }
            catch (InterruptedException e) {
                logger.info("Thread name {}, id {} is interrupted", (Object)RouteTableRefresher.currentThread().getName(), (Object)RouteTableRefresher.currentThread().getId());
            }
            ObPair<String, Boolean> refreshTableTask = this.refreshTableTasks.peek();
            if (refreshTableTask != null && refreshTableTask.getRight().booleanValue()) {
                String tableName = refreshTableTask.getLeft();
                try {
                    logger.info("backgroundRefreshTableTask run refresh, table name {}", (Object)tableName);
                    TableEntry tableEntry = this.client.getOrRefreshTableEntry(tableName, true, false, false);
                    this.client.getTableLocations().put(refreshTableTask.getLeft(), tableEntry);
                }
                catch (Exception e) {
                    String message = "RefreshTableBackground run meet exception" + e.getMessage();
                    logger.warn(message);
                }
            }
            this.refreshTableTasks.poll();
        }
    }

    public void addTableIfAbsent(String tableName, Boolean isRefreshing) {
        this.lock.lock();
        if (!this.refreshTableTasks.contains(new ObPair<String, Boolean>(tableName, isRefreshing))) {
            logger.info("add table {}, is refreshing {} to refresh task.", (Object)tableName, (Object)isRefreshing);
            this.refreshTableTasks.add(new ObPair<String, Boolean>(tableName, isRefreshing));
        }
        this.lock.unlock();
    }

    public void triggerRefreshTable() {
        this.semaphore.release();
    }
}

