/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionLocation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ObPartitionLocationInfo {
    private ObPartitionLocation partitionLocation = null;
    private Long tabletLsId = -1L;
    private Long lastUpdateTime = 0L;
    public ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    public AtomicBoolean initialized = new AtomicBoolean(false);
    public final CountDownLatch initializationLatch = new CountDownLatch(1);
    public ReentrantLock refreshLock = new ReentrantLock();

    public ObPartitionLocation getPartitionLocation() {
        this.rwLock.readLock().lock();
        try {
            ObPartitionLocation obPartitionLocation = this.partitionLocation;
            return obPartitionLocation;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void updateLocation(ObPartitionLocation newLocation, Long tabletLsId) {
        this.rwLock.writeLock().lock();
        try {
            this.partitionLocation = newLocation;
            this.tabletLsId = tabletLsId;
            this.lastUpdateTime = System.currentTimeMillis();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public Long getTabletLsId() {
        this.rwLock.readLock().lock();
        try {
            Long l = this.tabletLsId;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Long getLastUpdateTime() {
        this.rwLock.readLock().lock();
        try {
            Long l = this.lastUpdateTime;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

