/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.location.model.partition.ObHashPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObKeyPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartDesc;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionInfo;
import com.alipay.oceanbase.rpc.location.model.partition.ObRangePartDesc;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.OdpSinglePartKey;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class OdpPartitionData
extends AbstractPayload {
    private long level;
    private long partNum;
    private String partExr = "";
    private long partType;
    private long partSpace;
    private String partRangeType = "";
    private long subPartNum;
    private String subPartExr = "";
    private long subPartType;
    private long subPartSpace;
    private String subPartRangeType = "";
    private List<OdpSinglePartKey> singlePartKeys = new ArrayList<OdpSinglePartKey>();

    public OdpPartitionData() {
    }

    public OdpPartitionData(ObPartitionInfo info) {
        this.level = info.getLevel().getIndex();
        ObPartDesc firstPartDesc = info.getFirstPartDesc();
        if (firstPartDesc != null) {
            this.partNum = firstPartDesc.getPartNum();
            this.partExr = firstPartDesc.getPartExpr();
            this.partType = firstPartDesc.getPartFuncType().getIndex();
            if (this.partType == ObPartFuncType.HASH.getIndex()) {
                this.partSpace = ((ObHashPartDesc)firstPartDesc).getPartSpace();
            } else if (this.partType == ObPartFuncType.KEY.getIndex()) {
                this.partSpace = ((ObKeyPartDesc)firstPartDesc).getPartSpace();
            } else if (this.partType == ObPartFuncType.RANGE.getIndex()) {
                ObRangePartDesc firstRangePartDesc = (ObRangePartDesc)firstPartDesc;
                this.partSpace = firstRangePartDesc.getPartSpace();
                StringBuilder str = new StringBuilder();
                for (ObObjType obObjType : firstRangePartDesc.getOrderedCompareColumnTypes()) {
                    str.append(obObjType.getValue()).append(",");
                }
                str.deleteCharAt(str.length() - 1);
                this.partRangeType = str.toString();
            }
            ObPartDesc subPartDesc = info.getSubPartDesc();
            if (subPartDesc != null) {
                this.subPartNum = subPartDesc.getPartNum();
                this.subPartExr = subPartDesc.getPartExpr();
                this.subPartType = subPartDesc.getPartFuncType().getIndex();
                if (this.subPartType == ObPartFuncType.HASH.getIndex()) {
                    this.subPartSpace = ((ObHashPartDesc)subPartDesc).getPartSpace();
                } else if (this.subPartType == ObPartFuncType.KEY.getIndex()) {
                    this.subPartSpace = ((ObKeyPartDesc)subPartDesc).getPartSpace();
                } else if (this.subPartType == ObPartFuncType.RANGE.getIndex()) {
                    ObRangePartDesc subRangePartDesc = (ObRangePartDesc)subPartDesc;
                    this.subPartSpace = subRangePartDesc.getPartSpace();
                    StringBuilder str = new StringBuilder();
                    for (ObObjType type : subRangePartDesc.getOrderedCompareColumnTypes()) {
                        str.append(type.getValue()).append(",");
                    }
                    str.deleteCharAt(str.length() - 1);
                    this.subPartRangeType = str.toString();
                }
            }
            for (ObColumn column : info.getPartColumns()) {
                OdpSinglePartKey odpSinglePartKey = new OdpSinglePartKey(column);
                this.singlePartKeys.add(odpSinglePartKey);
            }
        }
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.level);
        System.arraycopy(Serialization.encodeVi64(this.level), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.partNum);
        System.arraycopy(Serialization.encodeVi64(this.partNum), 0, bytes, idx, len);
        byte[] strbytes = Serialization.encodeVString(this.partExr);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        len = Serialization.getNeedBytes(this.partType);
        System.arraycopy(Serialization.encodeVi64(this.partType), 0, bytes, idx += strbytes.length, len);
        idx += len;
        len = Serialization.getNeedBytes(this.partSpace);
        System.arraycopy(Serialization.encodeVi64(this.partSpace), 0, bytes, idx, len);
        strbytes = Serialization.encodeVString(this.partRangeType);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        len = Serialization.getNeedBytes(this.subPartNum);
        System.arraycopy(Serialization.encodeVi64(this.subPartNum), 0, bytes, idx += strbytes.length, len);
        strbytes = Serialization.encodeVString(this.subPartExr);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        len = Serialization.getNeedBytes(this.subPartType);
        System.arraycopy(Serialization.encodeVi64(this.subPartType), 0, bytes, idx += strbytes.length, len);
        idx += len;
        len = Serialization.getNeedBytes(this.subPartSpace);
        System.arraycopy(Serialization.encodeVi64(this.subPartSpace), 0, bytes, idx, len);
        strbytes = Serialization.encodeVString(this.subPartRangeType);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        len = Serialization.getNeedBytes(this.singlePartKeys.size());
        System.arraycopy(Serialization.encodeVi64(this.singlePartKeys.size()), 0, bytes, idx += strbytes.length, len);
        idx += len;
        for (OdpSinglePartKey singlePartKey : this.singlePartKeys) {
            len = (int)singlePartKey.getPayloadSize();
            System.arraycopy(singlePartKey.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public OdpPartitionData decode(ByteBuf buf) {
        super.decode(buf);
        this.level = Serialization.decodeVi64(buf);
        if (this.level != 1L && this.level != 2L) {
            return this;
        }
        this.partNum = Serialization.decodeVi64(buf);
        this.partExr = Serialization.decodeVString(buf);
        this.partType = Serialization.decodeVi64(buf);
        this.partSpace = Serialization.decodeVi64(buf);
        this.partRangeType = Serialization.decodeVString(buf);
        this.subPartNum = Serialization.decodeVi64(buf);
        this.subPartExr = Serialization.decodeVString(buf);
        this.subPartType = Serialization.decodeVi64(buf);
        this.subPartSpace = Serialization.decodeVi64(buf);
        this.subPartRangeType = Serialization.decodeVString(buf);
        long len = Serialization.decodeVi64(buf);
        for (long i = 0L; i < len; ++i) {
            OdpSinglePartKey singlePartKey = new OdpSinglePartKey();
            singlePartKey.decode(buf);
            this.singlePartKeys.add(singlePartKey);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long size = Serialization.getNeedBytes(this.level) + Serialization.getNeedBytes(this.partNum) + Serialization.getNeedBytes(this.partExr) + Serialization.getNeedBytes(this.partType) + Serialization.getNeedBytes(this.partSpace) + Serialization.getNeedBytes(this.partRangeType) + Serialization.getNeedBytes(this.subPartNum) + Serialization.getNeedBytes(this.subPartExr) + Serialization.getNeedBytes(this.subPartType) + Serialization.getNeedBytes(this.subPartSpace) + Serialization.getNeedBytes(this.subPartRangeType);
        size += (long)Serialization.getNeedBytes(this.singlePartKeys.size());
        for (OdpSinglePartKey singlePartKey : this.singlePartKeys) {
            size += singlePartKey.getPayloadSize();
        }
        return size;
    }

    public long getLevel() {
        return this.level;
    }

    public long getPartNum() {
        return this.partNum;
    }

    public String getPartExr() {
        return this.partExr;
    }

    public long getPartType() {
        return this.partType;
    }

    public long getPartSpace() {
        return this.partSpace;
    }

    public String getPartRangeType() {
        return this.partRangeType;
    }

    public long getSubPartNum() {
        return this.subPartNum;
    }

    public String getSubPartExr() {
        return this.subPartExr;
    }

    public long getSubPartType() {
        return this.subPartType;
    }

    public long getSubPartSpace() {
        return this.subPartSpace;
    }

    public String getSubPartRangeType() {
        return this.subPartRangeType;
    }

    public List<OdpSinglePartKey> getSinglePartKeys() {
        return this.singlePartKeys;
    }
}

