/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.property;

import java.util.Properties;

public abstract class AbstractPropertyAware {
    protected Properties properties = new Properties();

    public int parseToInt(String key) throws NumberFormatException {
        return Integer.parseInt(System.getProperty("ob.table.client." + key, this.getProperty(key)));
    }

    public int parseToInt(String key, int defaultV) {
        try {
            return this.parseToInt(key);
        }
        catch (NumberFormatException e) {
            return defaultV;
        }
    }

    public long parseToLong(String key) throws NumberFormatException {
        return Long.parseLong(System.getProperty("ob.table.client." + key, this.getProperty(key)));
    }

    public long parseToLong(String key, long defaultV) {
        try {
            return this.parseToLong(key);
        }
        catch (NumberFormatException e) {
            return defaultV;
        }
    }

    public boolean parseToBoolean(String key) throws Exception {
        if (System.getProperty("ob.table.client." + key) == null && this.getProperty(key) == null) {
            throw new Exception();
        }
        return Boolean.parseBoolean(System.getProperty("ob.table.client." + key, this.getProperty(key)));
    }

    public boolean parseToBoolean(String key, boolean defaultV) {
        try {
            return this.parseToBoolean(key);
        }
        catch (Exception e) {
            return defaultV;
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

