/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObAddrVersion;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ObAddr
extends AbstractPayload {
    private ObAddrVersion obAddrVersion = ObAddrVersion.ObAddrIPV4;
    private byte[] ip = new byte[16];
    private int port = 0;

    public String ipToString() {
        if (this.isIPv4()) {
            return this.getIPv4().getHostAddress();
        }
        return this.getIPv6().getHostAddress();
    }

    public InetAddress getIPv4() {
        if (this.isIPv6()) {
            return null;
        }
        try {
            return InetAddress.getByAddress(Arrays.copyOf(this.ip, 4));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddress getIPv6() {
        if (this.isIPv6()) {
            return null;
        }
        try {
            return InetAddress.getByAddress(this.ip);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean isIPv4() {
        return this.obAddrVersion == ObAddrVersion.ObAddrIPV4;
    }

    public boolean isIPv6() {
        return this.obAddrVersion == ObAddrVersion.ObAddrIPV6;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public long getPayloadContentSize() {
        return 0L;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        System.arraycopy(Serialization.encodeI8(this.obAddrVersion.getValue()), 0, bytes, idx, Serialization.getNeedBytes(this.obAddrVersion.getValue()));
        ByteBuffer buffer = ByteBuffer.wrap(this.ip).order(ByteOrder.BIG_ENDIAN);
        int ip1 = buffer.getInt(0);
        int ip2 = buffer.getInt(4);
        int ip3 = buffer.getInt(8);
        int ip4 = buffer.getInt(12);
        System.arraycopy(Serialization.encodeVi32(ip1), 0, bytes, idx, Serialization.getNeedBytes(ip1));
        System.arraycopy(Serialization.encodeVi32(ip2), 0, bytes, idx, Serialization.getNeedBytes(ip2));
        System.arraycopy(Serialization.encodeVi32(ip3), 0, bytes, idx, Serialization.getNeedBytes(ip3));
        System.arraycopy(Serialization.encodeVi32(ip4), 0, bytes, idx, Serialization.getNeedBytes(ip4));
        System.arraycopy(Serialization.encodeVi32(this.port), 0, bytes, idx, Serialization.getNeedBytes(this.port));
        return bytes;
    }

    @Override
    public ObAddr decode(ByteBuf buf) {
        super.decode(buf);
        this.obAddrVersion = ObAddrVersion.fromValue(Serialization.decodeI8(buf));
        int ip1 = Serialization.decodeVi32(buf);
        int ip2 = Serialization.decodeVi32(buf);
        int ip3 = Serialization.decodeVi32(buf);
        int ip4 = Serialization.decodeVi32(buf);
        ByteBuffer ipBuffer = ByteBuffer.wrap(this.ip).order(ByteOrder.BIG_ENDIAN);
        ipBuffer.putInt(0, ip1);
        ipBuffer.putInt(4, ip2);
        ipBuffer.putInt(8, ip3);
        ipBuffer.putInt(12, ip4);
        this.port = Serialization.decodeVi32(buf);
        return this;
    }
}

