/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.Credentialable;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObFetchPartitionMetaType;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObFetchPartitionMetaRequest
extends AbstractPayload
implements Credentialable {
    private ObFetchPartitionMetaType obFetchPartitionMetaType;
    private ObBytesString credential;
    private String tableName;
    private String clusterName;
    private String tenantName;
    private String databaseName;
    private boolean forceRenew = false;

    @Override
    public int getPcode() {
        return 4368;
    }

    public void setObFetchPartitionMetaType(ObFetchPartitionMetaType type) {
        this.obFetchPartitionMetaType = type;
    }

    public void setObFetchPartitionMetaType(int index) {
        this.obFetchPartitionMetaType = ObFetchPartitionMetaType.valueOf(index);
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setForceRenew(boolean forceRenew) {
        this.forceRenew = forceRenew;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.obFetchPartitionMetaType.getIndex());
        System.arraycopy(Serialization.encodeVi32(this.obFetchPartitionMetaType.getIndex()), 0, bytes, idx, len);
        idx += len;
        idx = this.encodeCredential(bytes, idx);
        byte[] strbytes = Serialization.encodeVString(this.tableName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.clusterName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.tenantName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.databaseName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        System.arraycopy(Serialization.encodeI8(this.forceRenew ? (byte)1 : 0), 0, bytes, idx += strbytes.length, 1);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.tableName = Serialization.decodeVString(buf);
        this.clusterName = Serialization.decodeVString(buf);
        this.tenantName = Serialization.decodeVString(buf);
        this.databaseName = Serialization.decodeVString(buf);
        this.forceRenew = Serialization.decodeI8(buf) == 1;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return Serialization.getNeedBytes(this.obFetchPartitionMetaType.getIndex()) + Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tableName) + Serialization.getNeedBytes(this.clusterName) + Serialization.getNeedBytes(this.tenantName) + Serialization.getNeedBytes(this.databaseName) + 1;
    }

    private int encodeCredential(byte[] bytes, int idx) {
        byte[] strbytes = Serialization.encodeBytesString(this.credential);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        return idx += strbytes.length;
    }

    public static ObFetchPartitionMetaRequest getInstance(int typeIdx, String tableName, String clusterName, String tenantName, String databaseName, boolean forceRenew, long timeout) {
        ObFetchPartitionMetaRequest request = new ObFetchPartitionMetaRequest();
        request.setObFetchPartitionMetaType(typeIdx);
        request.setTableName(tableName);
        if (clusterName == null) {
            clusterName = "";
        }
        request.setClusterName(clusterName);
        if (tenantName == null) {
            tenantName = "";
        }
        request.setTenantName(tenantName);
        request.setDatabaseName(databaseName);
        request.setForceRenew(forceRenew);
        request.setTimeout(timeout);
        return request;
    }
}

