/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ObTableOperationType {
    GET(0),
    INSERT(1),
    DEL(2),
    UPDATE(3),
    INSERT_OR_UPDATE(4),
    REPLACE(5),
    INCREMENT(6),
    APPEND(7),
    SCAN(8),
    TTL(9),
    CHECK_AND_INSERT_UP(10),
    PUT(11),
    TRIGGER(12),
    INVALID(15);

    private int value;
    private static Map<Integer, ObTableOperationType> map;
    private static final List<Boolean> needEncodeQuery;

    private ObTableOperationType(int value) {
        this.value = value;
    }

    public static ObTableOperationType valueOf(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public byte getByteValue() {
        return (byte)this.value;
    }

    public boolean isReadonly() {
        return this.value == ObTableOperationType.GET.value;
    }

    public static boolean needEncodeQuery(ObTableOperationType type) {
        return needEncodeQuery.get(type.value);
    }

    static {
        map = new HashMap<Integer, ObTableOperationType>();
        needEncodeQuery = Arrays.asList(false, false, false, false, false, false, false, false, true, false, true, false, false);
        for (ObTableOperationType type : ObTableOperationType.values()) {
            map.put(type.value, type);
        }
    }
}

