/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableQueryAndMutateFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableQueryAndMutate
extends AbstractPayload {
    private ObTableQuery tableQuery;
    private ObTableBatchOperation mutations;
    private boolean returnAffectedEntity = false;
    private ObTableQueryAndMutateFlag queryAndMutateFlag = new ObTableQueryAndMutateFlag();

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = (int)this.tableQuery.getPayloadSize();
        System.arraycopy(this.tableQuery.encode(), 0, bytes, idx += headerLen, len);
        idx += len;
        len = (int)this.mutations.getPayloadSize();
        System.arraycopy(this.mutations.encode(), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.returnAffectedEntity ? (byte)1 : 0), 0, bytes, idx += len, 1);
        long flags = this.queryAndMutateFlag.getValue();
        len = Serialization.getNeedBytes(flags);
        System.arraycopy(Serialization.encodeVi64(flags), 0, bytes, ++idx, len);
        idx += len;
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.tableQuery = new ObTableQuery();
        this.tableQuery.decode(buf);
        this.mutations = new ObTableBatchOperation();
        this.mutations.decode(buf);
        this.returnAffectedEntity = Serialization.decodeI8(buf) == 1;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return this.tableQuery.getPayloadSize() + this.mutations.getPayloadSize() + (long)Serialization.getNeedBytes(this.queryAndMutateFlag.getValue()) + 1L;
    }

    public ObTableQuery getTableQuery() {
        return this.tableQuery;
    }

    public void setTableQuery(ObTableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    public ObTableBatchOperation getMutations() {
        return this.mutations;
    }

    public void setMutations(ObTableBatchOperation mutations) {
        this.mutations = mutations;
    }

    public boolean isReturnAffectedEntity() {
        return this.returnAffectedEntity;
    }

    public void setReturnAffectedEntity(boolean returnAffectedEntity) {
        this.returnAffectedEntity = returnAffectedEntity;
    }

    public boolean isReadonly() {
        return false;
    }

    public void setIsCheckAndExecute(boolean isCheckAndExecute) {
        this.queryAndMutateFlag.setIsCheckAndExecute(isCheckAndExecute);
    }

    public void setIsCheckNoExists(boolean isCheckNoExists) {
        this.queryAndMutateFlag.setIsCheckNotExists(isCheckNoExists);
    }

    public void setIsRollbackWhenCheckFailed(boolean isRollbackWhenCheckFailed) {
        this.queryAndMutateFlag.setIsRollbackWhenCheckFailed(isRollbackWhenCheckFailed);
    }
}

