/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableGlobalIndexRouteException;
import com.alipay.oceanbase.rpc.exception.ObTableNeedFetchAllException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableRetryExhaustedException;
import com.alipay.oceanbase.rpc.exception.ObTableRoutingWrongException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.TableEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableApiMove;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableStreamRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.QueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public abstract class AbstractQueryStreamResult
extends AbstractPayload
implements QueryStreamResult {
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean initialized = false;
    protected volatile boolean closed = false;
    protected volatile List<ObObj> row = null;
    protected volatile int rowIndex = -1;
    protected ObTableQuery tableQuery;
    protected long operationTimeout = -1L;
    protected String tableName;
    protected String indexTableName;
    protected ObTableEntityType entityType;
    protected Map<Long, ObPair<Long, ObTableParam>> expectant;
    protected List<String> cacheProperties = new LinkedList<String>();
    protected LinkedList<List<ObObj>> cacheRows = new LinkedList();
    private LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> partitionLastResult = new LinkedList();
    private ObReadConsistency readConsistency = ObReadConsistency.STRONG;
    public List<ObObj> currentStartKey;
    protected ObTableClient client;

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public Object decode(ByteBuf buf) {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public long getPayloadContentSize() {
        throw new FeatureNotSupportedException("stream result has no pay load size");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ObPayload commonExecute(ObTableClient client, Logger logger, ObPair<Long, ObTableParam> partIdWithIndex, ObPayload request, AtomicReference<ObTableConnection> connectionRef) throws Exception {
        ObTable subObTable = partIdWithIndex.getRight().getObTable();
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        while (true) {
            client.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > client.getRuntimeMaxWait()) {
                long uniqueId = request.getUniqueId();
                long sequence = request.getSequence();
                String trace = String.format("Y%X-%016X", uniqueId, sequence);
                throw new ObTableTimeoutExcetion("[" + trace + "] has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + client.getRuntimeMaxWait() + "/ms");
            }
            ++tryTimes;
            try {
                ObPayload result;
                if (tryTimes > 1) {
                    if (client.isOdpMode()) {
                        subObTable = client.getOdpTable();
                    } else {
                        if (route == null) {
                            route = client.getReadRoute();
                        }
                        if (failedServerList != null) {
                            route.setBlackList(failedServerList);
                        }
                        if (ObGlobal.obVsnMajor() >= 4) {
                            TableEntry tableEntry = client.getOrRefreshTableEntry(this.indexTableName, false, false, false);
                            client.refreshTableLocationByTabletId(tableEntry, this.indexTableName, client.getTabletIdByPartId(tableEntry, partIdWithIndex.getLeft()));
                        }
                        subObTable = client.getTableWithPartId(this.indexTableName, partIdWithIndex.getLeft(), needRefreshTableEntry, client.isTableEntryRefreshIntervalWait(), false, route).getRight().getObTable();
                    }
                }
                if (client.isOdpMode()) {
                    result = subObTable.executeWithConnection(request, connectionRef);
                } else {
                    result = subObTable.execute(request);
                    if (result != null && result.getPcode() == 4388) {
                        ObTableApiMove moveResponse = (ObTableApiMove)result;
                        client.getRouteTableRefresher().addTableIfAbsent(this.indexTableName, true);
                        client.getRouteTableRefresher().triggerRefreshTable();
                        subObTable = client.getTable(moveResponse);
                        result = subObTable.execute(request);
                        if (result instanceof ObTableApiMove) {
                            ObTableApiMove move = (ObTableApiMove)result;
                            logger.warn("The server has not yet completed the master switch, and returned an incorrect leader with an IP address of {}. Rerouting return IP is {}", (Object)moveResponse.getReplica().getServer().ipToString(), (Object)move.getReplica().getServer().ipToString());
                            throw new ObTableRoutingWrongException();
                        }
                    }
                }
                client.resetExecuteContinuousFailureCount(this.indexTableName);
                return result;
            }
            catch (Exception e) {
                block31: {
                    block32: {
                        if (!client.isOdpMode()) break block32;
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) throw e;
                        if (e instanceof ObTableException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, errorCode: {}, errorMsg: {}, try times {}", new Object[]{this.indexTableName, ((ObTableException)e).getErrorCode(), e.getMessage(), tryTimes});
                            break block31;
                        } else if (e instanceof IllegalArgumentException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}, errorMsg: {}", new Object[]{this.indexTableName, tryTimes, e.getMessage()});
                            break block31;
                        } else {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}", new Object[]{this.indexTableName, tryTimes, e});
                        }
                        break block31;
                    }
                    if (e instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) {
                            logger.warn("tablename:{} partition id:{} exhaust retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                            throw e;
                        }
                        logger.warn("tablename:{} partition id:{} retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else if (e instanceof ObTableGlobalIndexRouteException) {
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) {
                            logger.warn("meet global index route expcetion: indexTableName:{} partition id:{}, errorCode: {}, reach max retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                            throw e;
                        }
                        logger.warn("meet global index route expcetion: indexTableName:{} partition id:{}, errorCode: {}, retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                        this.indexTableName = client.getIndexTableName(this.tableName, this.tableQuery.getIndexName(), this.tableQuery.getScanRangeColumns(), true);
                    } else {
                        if (!(e instanceof ObTableException)) {
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw e;
                        }
                        if ((((ObTableException)e).getErrorCode() == ResultCodes.OB_TABLE_NOT_EXIST.errorCode || ((ObTableException)e).getErrorCode() == ResultCodes.OB_NOT_SUPPORTED.errorCode) && (request instanceof ObTableQueryAsyncRequest && ((ObTableQueryAsyncRequest)request).getObTableQueryRequest().getTableQuery().isHbaseQuery() || request instanceof ObTableQueryRequest && ((ObTableQueryRequest)request).getTableQuery().isHbaseQuery()) && client.getTableGroupInverted().get(this.indexTableName) != null) {
                            client.eraseTableGroupFromCache(this.tableName);
                        }
                        if (!((ObTableException)e).isNeedRefreshTableEntry()) {
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw e;
                        }
                        needRefreshTableEntry = true;
                        if (client.isRetryOnChangeMasterTimes() && tryTimes - 1 < client.getRuntimeRetryTimes()) {
                            if (e instanceof ObTableNeedFetchAllException) {
                                client.getOrRefreshTableEntry(this.indexTableName, true, true, true);
                                throw e;
                            }
                        } else {
                            String logMessage = String.format("exhaust retry while meet NeedRefresh Exception, table name: %s, batch ops refresh table, errorCode: %d", this.indexTableName, ((ObTableException)e).getErrorCode());
                            logger.warn(logMessage, (Throwable)e);
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw new ObTableRetryExhaustedException(logMessage, e);
                        }
                    }
                }
                Thread.sleep(client.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
    }

    public void renewLease() throws Exception {
        throw new IllegalStateException("renew only support stream query");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws Exception {
        this.checkStatus();
        this.lock.lock();
        try {
            ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
            if (!this.cacheRows.isEmpty()) {
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            while ((referLastResult = this.partitionLastResult.poll()) != null) {
                ObTableQueryResult lastResult = referLastResult.getRight();
                if (!lastResult.isStream() || !lastResult.isStreamNext()) continue;
                ObTableQueryResult tableQueryResult = this.referToLastStreamResult(referLastResult.getLeft(), lastResult);
                if (tableQueryResult.getRowCount() == 0L) continue;
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            boolean hasNext = false;
            ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>> referPartition = new ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>>();
            Iterator<Map.Entry<Long, ObPair<Long, ObTableParam>>> it = this.expectant.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, ObPair<Long, ObTableParam>> entry = it.next();
                referPartition.add(entry);
                try {
                    referPartition.add(entry);
                    ObTableQueryResult tableQueryResult = (ObTableQueryResult)this.referToNewPartition(entry.getValue());
                    if (tableQueryResult.getRowCount() == 0L) continue;
                    hasNext = true;
                    this.nextRow();
                    break;
                }
                catch (Exception e) {
                    if (e instanceof ObTableNeedFetchAllException) {
                        this.setExpectant(this.refreshPartition(this.tableQuery, this.tableName));
                        it = this.expectant.entrySet().iterator();
                        referPartition.clear();
                        continue;
                    }
                    throw e;
                }
            }
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
                referPartition.add(entry);
                ObTableQueryResult tableQueryResult = (ObTableQueryResult)this.referToNewPartition(entry.getValue());
                if (tableQueryResult.getRowCount() == 0L) continue;
                hasNext = true;
                this.nextRow();
                break;
            }
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : referPartition) {
                this.expectant.remove(entry.getKey());
            }
            boolean bl = hasNext;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<Long, ObPair<Long, ObTableParam>> buildPartitions(ObTableClient client, ObTableQuery tableQuery, String tableName) throws Exception {
        LinkedHashMap<Long, ObPair<Long, ObTableParam>> partitionObTables = new LinkedHashMap<Long, ObPair<Long, ObTableParam>>();
        String indexName = tableQuery.getIndexName();
        if (!client.isOdpMode()) {
            this.indexTableName = client.getIndexTableName(tableName, indexName, tableQuery.getScanRangeColumns(), false);
        }
        for (ObNewRange range : tableQuery.getKeyRanges()) {
            int i;
            ObRowKey startKey = range.getStartKey();
            int startKeySize = startKey.getObjs().size();
            ObRowKey endKey = range.getEndKey();
            int endKeySize = endKey.getObjs().size();
            Object[] start = new Object[startKeySize];
            Object[] end = new Object[endKeySize];
            for (i = 0; i < startKeySize; ++i) {
                start[i] = startKey.getObj(i).isMinObj() || startKey.getObj(i).isMaxObj() ? startKey.getObj(i) : startKey.getObj(i).getValue();
            }
            for (i = 0; i < endKeySize; ++i) {
                end[i] = endKey.getObj(i).isMinObj() || endKey.getObj(i).isMaxObj() ? endKey.getObj(i) : endKey.getObj(i).getValue();
            }
            ObBorderFlag borderFlag = range.getBorderFlag();
            List<ObPair<Long, ObTableParam>> pairs = client.getTables(this.indexTableName, tableQuery, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), false, false);
            if (tableQuery.getScanOrder() == ObScanOrder.Reverse) {
                for (int i2 = pairs.size() - 1; i2 >= 0; --i2) {
                    partitionObTables.put(pairs.get(i2).getLeft(), pairs.get(i2));
                }
                continue;
            }
            for (ObPair<Long, ObTableParam> pair : pairs) {
                partitionObTables.put(pair.getLeft(), pair);
            }
        }
        return partitionObTables;
    }

    protected void nextRow() {
        ++this.rowIndex;
        this.row = this.cacheRows.poll();
        if (this.row != null) {
            this.currentStartKey = this.row;
        }
    }

    protected void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("table " + this.indexTableName + "query stream result is not initialized");
        }
        if (this.closed) {
            throw new IllegalStateException("table " + this.indexTableName + " query stream result is closed");
        }
    }

    protected ObTableQueryResult checkObTableQueryResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryResult.class.getName());
        }
        return (ObTableQueryResult)result;
    }

    protected ObTableQueryAsyncResult checkObTableQueryAsyncResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryAsyncResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryAsyncResult.class.getName());
        }
        return (ObTableQueryAsyncResult)result;
    }

    private ObTableQueryResult referToLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamNext();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        return this.execute(partIdWithObTable, streamRequest);
    }

    private void closeLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamLast();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        partIdWithObTable.getRight().getObTable().execute(streamRequest);
    }

    protected abstract ObPayload referToNewPartition(ObPair<Long, ObTableParam> var1) throws Exception;

    protected abstract ObTableQueryResult execute(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    protected abstract ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    protected abstract Map<Long, ObPair<Long, ObTableParam>> refreshPartition(ObTableQuery var1, String var2) throws Exception;

    protected void cacheResultRows(ObTableQueryResult tableQueryResult) {
        this.cacheRows.addAll(tableQueryResult.getPropertiesRows());
        this.cacheProperties = tableQueryResult.getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult tableQueryResult) {
        this.cacheResultRows(tableQueryResult);
        if (tableQueryResult.isStream() && tableQueryResult.isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQueryResult));
        }
    }

    private void cacheResultRows(ObTableQueryAsyncResult tableQueryAsyncResult) {
        this.cacheRows.addAll(tableQueryAsyncResult.getAffectedEntity().getPropertiesRows());
        this.cacheProperties = tableQueryAsyncResult.getAffectedEntity().getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryAsyncResult tableQueryAsyncResult) {
        this.cacheResultRows(tableQueryAsyncResult);
        if (tableQueryAsyncResult.getAffectedEntity().isStream() && tableQueryAsyncResult.getAffectedEntity().isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQueryAsyncResult.getAffectedEntity()));
        }
    }

    @Override
    public List<ObObj> getRow() {
        if (this.rowIndex == -1) {
            throw new IllegalStateException("before result set start");
        }
        return this.row;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.tableQuery.getBatchSize() == -1) {
            if (!this.expectant.isEmpty()) {
                Iterator<Map.Entry<Long, ObPair<Long, ObTableParam>>> it = this.expectant.entrySet().iterator();
                int retryTimes = 0;
                while (it.hasNext()) {
                    Map.Entry<Long, ObPair<Long, ObTableParam>> entry = it.next();
                    try {
                        this.referToNewPartition(entry.getValue());
                    }
                    catch (Exception e) {
                        if (e instanceof ObTableNeedFetchAllException) {
                            this.setExpectant(this.refreshPartition(this.tableQuery, this.tableName));
                            it = this.expectant.entrySet().iterator();
                            if (++retryTimes <= this.client.getRuntimeRetryTimes()) continue;
                            TableClientLoggerFactory.RUNTIME.error("Fail to get refresh table entry response after {}", (Object)retryTimes);
                            throw new ObTableRetryExhaustedException("Fail to get refresh table entry response after " + retryTimes + "errorCode:" + ((ObTableNeedFetchAllException)e).getErrorCode());
                        }
                        throw e;
                    }
                }
            }
        } else {
            throw new ObTableException("simple query not support BatchSize, use executeAsync() instead, BatchSize:" + this.tableQuery.getBatchSize());
        }
        this.expectant.clear();
        this.initialized = true;
    }

    @Override
    public void close() throws Exception {
        ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
        if (this.closed) {
            return;
        }
        this.closed = true;
        while ((referLastResult = this.partitionLastResult.poll()) != null) {
            ObTableQueryResult lastResult = referLastResult.getRight();
            this.closeLastStreamResult(referLastResult.getLeft(), lastResult);
        }
    }

    @Override
    public List<String> getCacheProperties() {
        return this.cacheProperties;
    }

    @Override
    public LinkedList<List<ObObj>> getCacheRows() {
        return this.cacheRows;
    }

    public LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> getPartitionLastResult() {
        return this.partitionLastResult;
    }

    public ObTableQuery getTableQuery() {
        return this.tableQuery;
    }

    public void setTableQuery(ObTableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public void setIndexTableName(String indexTableName) {
        this.indexTableName = indexTableName;
    }

    public ObTableEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    public Map<Long, ObPair<Long, ObTableParam>> getExpectant() {
        return this.expectant;
    }

    public void setExpectant(Map<Long, ObPair<Long, ObTableParam>> expectant) {
        this.expectant = expectant;
    }

    public ObReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ObReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
    }

    public ObTableClient getClient() {
        return this.client;
    }

    public void setClient(ObTableClient client) {
        this.client = client;
    }
}

