/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableQueryRequest
extends ObTableAbstractOperationRequest {
    private ObTableQuery tableQuery;

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        idx = this.encodeCredential(bytes, idx);
        idx = this.encodeTableMetaWithPartitionId(bytes, idx);
        idx = this.encodeConsistencyLevel(bytes, idx);
        int len = (int)this.tableQuery.getPayloadSize();
        System.arraycopy(this.tableQuery.encode(), 0, bytes, idx, len);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.tableName = Serialization.decodeVString(buf);
        this.tableId = Serialization.decodeVi64(buf);
        this.partitionId = ObGlobal.obVsnMajor() >= 4 ? Serialization.decodeI64(buf) : Serialization.decodeVi64(buf);
        this.entityType = ObTableEntityType.valueOf(buf.readByte());
        this.consistencyLevel = ObTableConsistencyLevel.valueOf(buf.readByte());
        this.tableQuery = new ObTableQuery();
        this.tableQuery.decode(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        if (ObGlobal.obVsnMajor() >= 4) {
            return (long)(Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tableName) + Serialization.getNeedBytes(this.tableId) + 8 + 2) + this.tableQuery.getPayloadSize();
        }
        return (long)(Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.tableName) + Serialization.getNeedBytes(this.tableId) + Serialization.getNeedBytes(this.partitionId) + 2) + this.tableQuery.getPayloadSize();
    }

    public ObTableQuery getTableQuery() {
        return this.tableQuery;
    }

    public void setTableQuery(ObTableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    public void setTableQueryPartId(Long partId) {
        this.tableQuery.setPartId(partId);
    }
}

