/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.List;

public abstract class AbstractTableQuery
implements TableQuery {
    private static final String PRIMARY_INDEX_NAME = "PRIMARY";
    protected ObTableEntityType entityType = ObTableEntityType.KV;
    protected long operationTimeout = -1L;

    @Override
    public TableQuery limit(int limit) {
        return this.limit(0, limit);
    }

    @Override
    public TableQuery primaryIndex() {
        return this.indexName(PRIMARY_INDEX_NAME);
    }

    @Override
    public TableQuery addScanRange(Object start, Object end) {
        return this.addScanRange(new Object[]{start}, true, new Object[]{end}, true);
    }

    @Override
    public TableQuery addScanRange(Object[] start, Object[] end) {
        return this.addScanRange(start, true, end, true);
    }

    @Override
    public TableQuery addScanRange(Object start, boolean startEquals, Object end, boolean endEquals) {
        return this.addScanRange(new Object[]{start}, startEquals, new Object[]{end}, endEquals);
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object start) {
        return this.addScanRangeStartsWith(new Object[]{start}, true);
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object[] start) {
        return this.addScanRangeStartsWith(start, true);
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object end) {
        return this.addScanRangeEndsWith(new Object[]{end}, true);
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object[] end) {
        return this.addScanRangeEndsWith(end, true);
    }

    @Override
    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    @Override
    public ObTableEntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public TableQuery setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    @Override
    public TableQuery setFilter(ObTableFilter filter) {
        if (null == filter) {
            throw new IllegalArgumentException("input filter is null");
        }
        this.getObTableQuery().setFilterString(filter.toString());
        return this;
    }

    @Override
    public TableQuery setScanRangeColumns(String ... columns) {
        this.getObTableQuery().setScanRangeColumns(columns);
        return this;
    }

    @Override
    public List<String> getSelectColumns() {
        throw new ObTableException("only query from BatchOperation support getSelectColumns");
    }

    @Override
    public Row getRowKey() throws Exception {
        throw new ObTableException("only query from BatchOperation support row key");
    }

    @Override
    public TableQuery setRowKey(Row row) throws Exception {
        throw new ObTableException("only query from BatchOperation support row key");
    }
}

