/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

public class ByteUtil {
    public static int compareByteArrays(byte[] array1, byte[] array2) {
        for (int i = 0; i < Math.min(array1.length, array2.length); ++i) {
            int a = array1[i] & 0xFF;
            int b = array2[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return array1.length - array2.length;
    }

    public static byte[] incrementByteArray(byte[] input) {
        if (input == null || input.length == 0) {
            return new byte[]{1};
        }
        byte[] result = (byte[])input.clone();
        for (int i = result.length - 1; i >= 0; --i) {
            int n = i;
            result[n] = (byte)(result[n] + 1);
            if ((result[i] & 0xFF) != 0) {
                return result;
            }
            result[i] = 0;
        }
        byte[] extendedResult = new byte[result.length + 1];
        extendedResult[0] = 1;
        return extendedResult;
    }

    public static byte[] decrementByteArray(byte[] input) {
        if (input == null || input.length == 0 || ByteUtil.isZero(input)) {
            throw new IllegalArgumentException("Input array must represent a positive integer.");
        }
        byte[] result = (byte[])input.clone();
        for (int i = result.length - 1; i >= 0; --i) {
            if ((result[i] & 0xFF) > 0) {
                int n = i;
                result[n] = (byte)(result[n] - 1);
                return result;
            }
            result[i] = -1;
        }
        if (result[0] == 0) {
            byte[] shortenedResult = new byte[result.length - 1];
            System.arraycopy(result, 1, shortenedResult, 0, shortenedResult.length);
            return shortenedResult;
        }
        return result;
    }

    private static boolean isZero(byte[] array) {
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

