/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage.typehelper;

import com.oceanbase.oms.common.enums.DbTypeEnum;
import com.oceanbase.oms.logmessage.DataMessage;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelper;
import org.apache.commons.lang3.StringUtils;

public class MySQLLogTypeHelper
extends LogTypeHelper {
    public static final MySQLLogTypeHelper MYSQL_LOG_TYPE_HELPER = new MySQLLogTypeHelper();

    public MySQLLogTypeHelper() {
        super(DbTypeEnum.MYSQL);
    }

    @Override
    public String correctEncoding(int type, String realEncoding) {
        switch (type) {
            case 253: 
            case 254: {
                return realEncoding.isEmpty() ? "binary" : realEncoding;
            }
            case 245: {
                return "utf8mb4";
            }
        }
        return realEncoding;
    }

    @Override
    public int correctCode(int typeCode, String encoding) {
        switch (typeCode) {
            case 253: {
                return StringUtils.equals((CharSequence)encoding, (CharSequence)"binary") ? 198 : 15;
            }
            case 254: {
                return StringUtils.equals((CharSequence)encoding, (CharSequence)"binary") ? 199 : 254;
            }
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                return StringUtils.isEmpty((CharSequence)encoding) || StringUtils.equals((CharSequence)encoding, (CharSequence)"binary") ? 252 : 197;
            }
        }
        return typeCode;
    }

    @Override
    public void correctField(DataMessage.Record.Field field, String enc) {
        if (enc.isEmpty()) {
            if (field.type == 254) {
                field.encoding = "binary";
                field.type = 199;
            } else if (field.type == 253) {
                field.encoding = "binary";
                field.type = 15;
            } else if (field.type == 245) {
                field.encoding = "utf8mb4";
            }
        } else {
            if (field.type >= 249 && field.type <= 252) {
                field.type = 197;
            }
            field.encoding = enc;
        }
    }
}

