/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage.utils;

import com.oceanbase.oms.logmessage.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class BinaryMessageUtils {
    private static final int PREFIX_LENGTH = 12;

    public static String getString(byte[] data, int offset, String encoding) throws UnsupportedEncodingException {
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex(12 + offset);
        byte t = wrapByteBuf.readByte();
        if ((t & 0x10) != 0 || (t & 0x20) != 0) {
            return null;
        }
        int length = (int)wrapByteBuf.readUnsignedInt();
        return new String(wrapByteBuf.array(), 17 + offset, length - 1, encoding);
    }

    public static List getArray(byte[] data, int offset) throws IOException {
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex(12 + offset);
        byte t = wrapByteBuf.readByte();
        if ((t & 0x10) == 0) {
            return null;
        }
        int count = (int)wrapByteBuf.readUnsignedInt();
        if (count == 0) {
            return null;
        }
        ArrayList<Number> lists = new ArrayList<Number>(count);
        int type = t & 0xF;
        block10: for (int i = 0; i < count; ++i) {
            switch (type) {
                case 1: {
                    lists.add(wrapByteBuf.readByte());
                    continue block10;
                }
                case 2: {
                    lists.add(Integer.valueOf(wrapByteBuf.readUnsignedByte()));
                    continue block10;
                }
                case 3: {
                    lists.add(wrapByteBuf.readShort());
                    continue block10;
                }
                case 4: {
                    lists.add(wrapByteBuf.readUnsignedShort());
                    continue block10;
                }
                case 5: {
                    lists.add(wrapByteBuf.readInt());
                    continue block10;
                }
                case 6: {
                    lists.add(wrapByteBuf.readUnsignedInt());
                    continue block10;
                }
                case 7: {
                    lists.add(wrapByteBuf.readLong());
                    continue block10;
                }
                case 8: {
                    throw new IOException("Unsupported unsigned long");
                }
            }
        }
        return lists;
    }

    public static List<ByteString> getByteStringList(byte[] data, long offset) {
        if (offset == -1L) {
            return null;
        }
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer((byte[])data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex((int)(12L + offset));
        byte t = wrapByteBuf.readByte();
        if ((t & 0x10) == 0 || (t & 0xF) != 11) {
            throw new RuntimeException("Data type not array or not string");
        }
        int count = wrapByteBuf.readInt();
        if (count == 0) {
            return null;
        }
        int readBytes = 5;
        readBytes += (count + 1) * 4;
        ArrayList<ByteString> lists = new ArrayList<ByteString>(count);
        int currentOffset = (int)wrapByteBuf.readUnsignedInt();
        for (int i = 0; i < count; ++i) {
            int nextOffset = (int)wrapByteBuf.readUnsignedInt();
            if (nextOffset == currentOffset) {
                lists.add(null);
            } else {
                lists.add(new ByteString(wrapByteBuf.array(), 12 + currentOffset + readBytes + (int)offset, nextOffset - currentOffset - 1));
            }
            currentOffset = nextOffset;
        }
        return lists;
    }
}

