/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client;

import com.oceanbase.clogproxy.client.config.AbstractConnectionConfig;
import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.connection.ClientStream;
import com.oceanbase.clogproxy.client.connection.ConnectionParams;
import com.oceanbase.clogproxy.client.listener.RecordListener;
import com.oceanbase.clogproxy.client.listener.StatusListener;
import com.oceanbase.clogproxy.client.util.Validator;
import com.oceanbase.clogproxy.common.packet.ProtocolVersion;

public class LogProxyClient {
    private final ClientStream stream;

    public LogProxyClient(String host, int port, AbstractConnectionConfig config, ClientConf clientConf) {
        try {
            Validator.notNull(config.getLogType(), "log type cannot be null");
            Validator.notEmpty(host, "server cannot be null");
            Validator.validatePort(port, "port is not valid");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal argument for LogProxyClient: " + e.getMessage());
        }
        if (!config.valid()) {
            throw new IllegalArgumentException("Illegal argument for LogProxyClient");
        }
        if (clientConf == null) {
            clientConf = ClientConf.builder().build();
        }
        String clientId = clientConf.getClientId();
        ConnectionParams connectionParams = new ConnectionParams(config.getLogType(), clientId, host, port, config);
        connectionParams.setProtocolVersion(ProtocolVersion.codeOf((int)clientConf.getProtocolVersion()));
        this.stream = new ClientStream(clientConf, connectionParams);
    }

    public LogProxyClient(String host, int port, AbstractConnectionConfig config) {
        this(host, port, config, null);
    }

    public void start() {
        this.stream.start();
    }

    public void stop() {
        this.stream.stop();
    }

    public void join() {
        this.stream.join();
    }

    public synchronized void addListener(RecordListener recordListener) {
        this.stream.addListener(recordListener);
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        this.stream.addStatusListener(statusListener);
    }
}

