/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.config;

import com.oceanbase.clogproxy.client.config.AbstractConnectionConfig;
import com.oceanbase.clogproxy.client.util.Validator;
import com.oceanbase.clogproxy.common.config.SharedConf;
import com.oceanbase.clogproxy.common.packet.LogType;
import com.oceanbase.clogproxy.common.util.CryptoUtil;
import com.oceanbase.clogproxy.common.util.Hex;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObReaderConfig
extends AbstractConnectionConfig {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ObReaderConfig.class);
    private final AbstractConnectionConfig.ConfigItem<String> clusterId = new AbstractConnectionConfig.ConfigItem<String>("cluster_id", "");
    private final AbstractConnectionConfig.ConfigItem<String> clusterUrl = new AbstractConnectionConfig.ConfigItem<String>("cluster_url", "");
    private final AbstractConnectionConfig.ConfigItem<String> rsList = new AbstractConnectionConfig.ConfigItem<String>("rootserver_list", "");
    private final AbstractConnectionConfig.ConfigItem<String> clusterUser = new AbstractConnectionConfig.ConfigItem<String>("cluster_user", "");
    private final AbstractConnectionConfig.ConfigItem<String> clusterPassword = new AbstractConnectionConfig.ConfigItem<String>("cluster_password", "");
    private final AbstractConnectionConfig.ConfigItem<String> sysUser = new AbstractConnectionConfig.ConfigItem<String>("sys_user", "");
    private final AbstractConnectionConfig.ConfigItem<String> sysPassword = new AbstractConnectionConfig.ConfigItem<String>("sys_password", "");
    private final AbstractConnectionConfig.ConfigItem<String> tableWhitelist = new AbstractConnectionConfig.ConfigItem<String>("tb_white_list", "*.*.*");
    private final AbstractConnectionConfig.ConfigItem<String> tableBlacklist = new AbstractConnectionConfig.ConfigItem<String>("tb_black_list", "|");
    private final AbstractConnectionConfig.ConfigItem<Long> startTimestamp = new AbstractConnectionConfig.ConfigItem<Long>("first_start_timestamp", 0L);
    private final AbstractConnectionConfig.ConfigItem<Long> startTimestampUs = new AbstractConnectionConfig.ConfigItem<Long>("first_start_timestamp_us", 0L);
    private final AbstractConnectionConfig.ConfigItem<String> timezone = new AbstractConnectionConfig.ConfigItem<String>("timezone", "+08:00");
    private final AbstractConnectionConfig.ConfigItem<String> workingMode = new AbstractConnectionConfig.ConfigItem<String>("working_mode", "storage");

    public ObReaderConfig() {
    }

    public ObReaderConfig(Map<String, String> allConfigs) {
        this.setConfigs(allConfigs);
    }

    @Override
    public LogType getLogType() {
        return LogType.OCEANBASE;
    }

    @Override
    public boolean valid() {
        try {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)this.clusterUrl.val)) && StringUtils.isEmpty((CharSequence)((CharSequence)this.rsList.val))) {
                throw new IllegalArgumentException("empty clusterUrl or rsList");
            }
            Validator.notEmpty((String)this.clusterUser.val, "invalid clusterUser");
            Validator.notEmpty((String)this.clusterPassword.val, "invalid clusterPassword");
            if ((Long)this.startTimestamp.val < 0L) {
                throw new IllegalArgumentException("invalid startTimestamp");
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    @Override
    public String generateConfigurationString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.configs.entrySet()) {
            String value = ((AbstractConnectionConfig.ConfigItem)entry.getValue()).val.toString();
            if (this.clusterUrl.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value) || this.sysUser.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value) || this.sysPassword.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value)) continue;
            if (this.clusterPassword.key.equals(entry.getKey()) && SharedConf.AUTH_PASSWORD_HASH) {
                value = Hex.str((byte[])CryptoUtil.sha1((String)value));
            }
            sb.append((String)entry.getKey()).append("=").append(value).append(" ");
        }
        for (Map.Entry entry : this.extraConfigs.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> generateConfigurationMap(boolean encryptPassword) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : this.configs.entrySet()) {
            String value = ((AbstractConnectionConfig.ConfigItem)entry.getValue()).val.toString();
            if (this.clusterUrl.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value) || this.sysUser.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value) || this.sysPassword.key.equals(entry.getKey()) && StringUtils.isEmpty((CharSequence)value)) continue;
            if (encryptPassword && this.clusterPassword.key.equals(entry.getKey()) && SharedConf.AUTH_PASSWORD_HASH) {
                value = Hex.str((byte[])CryptoUtil.sha1((String)value));
            }
            result.put((String)entry.getKey(), value);
        }
        result.putAll(this.extraConfigs);
        return result;
    }

    @Override
    public void updateCheckpoint(String checkpoint) {
        try {
            long timestamp = Long.parseLong(checkpoint);
            if (timestamp < 0L) {
                throw new IllegalArgumentException("update checkpoint with invalid value: " + checkpoint);
            }
            this.startTimestamp.set(timestamp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return StringUtils.isNotEmpty((CharSequence)((CharSequence)this.clusterUrl.val)) ? "cluster_url=" + this.clusterUrl : "rootserver_list=" + this.rsList + ", cluster_id=" + this.clusterId + ", cluster_user=" + this.clusterUser + ", cluster_password=******, , sys_user=" + this.sysUser + ", sys_password=******, tb_white_list=" + this.tableWhitelist + ", tb_black_list=" + this.tableBlacklist + ", start_timestamp=" + this.startTimestamp + ", start_timestamp_us=" + this.startTimestampUs + ", timezone=" + this.timezone + ", working_mode=" + this.workingMode;
    }

    public void setClusterId(String clusterId) {
        this.clusterId.set(clusterId);
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl.set(clusterUrl);
    }

    public void setRsList(String rsList) {
        this.rsList.set(rsList);
    }

    public void setUsername(String clusterUser) {
        this.clusterUser.set(clusterUser);
    }

    public void setPassword(String clusterPassword) {
        this.clusterPassword.set(clusterPassword);
    }

    public void setSysUsername(String sysUsername) {
        this.sysUser.set(sysUsername);
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword.set(sysPassword);
    }

    public void setTableWhiteList(String tableWhiteList) {
        this.tableWhitelist.set(tableWhiteList);
    }

    public void setTableBlackList(String tableBlackList) {
        this.tableBlacklist.set(tableBlackList);
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp.set(startTimestamp);
    }

    public void setStartTimestampUs(Long startTimestampUs) {
        this.startTimestampUs.set(startTimestampUs);
    }

    public void setTimezone(String timezone) {
        this.timezone.set(timezone);
    }

    public void setWorkingMode(String workingMode) {
        this.workingMode.set(workingMode);
    }
}

