/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;

public class ShortParameter
implements Cloneable,
ParameterHolder {
    private final short value;

    public ShortParameter(short value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(String.valueOf(this.value).getBytes());
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return String.valueOf(this.value).getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeShort(this.value);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.SMALLINT;
    }

    @Override
    public String toString() {
        return Short.toString(this.value);
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

