/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.dao;

import com.oceanbase.jdbc.internal.com.read.dao.CmdInformation;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.Utils;
import java.sql.ResultSet;

public class CmdInformationSingle
implements CmdInformation {
    private final long insertId;
    private final int autoIncrement;
    private long updateCount;
    private String serverInfo;

    public CmdInformationSingle(long insertId, long updateCount, int autoIncrement) {
        this.insertId = insertId;
        this.updateCount = updateCount;
        this.autoIncrement = autoIncrement;
    }

    public CmdInformationSingle(long insertId, long updateCount, int autoIncrement, String serverInfo) {
        this.insertId = insertId;
        this.updateCount = updateCount;
        this.autoIncrement = autoIncrement;
        this.serverInfo = serverInfo;
    }

    public long getInsertId() {
        return this.insertId;
    }

    @Override
    public int[] getUpdateCounts() {
        return new int[]{(int)this.updateCount};
    }

    @Override
    public int[] getServerUpdateCounts() {
        return new int[]{(int)this.updateCount};
    }

    @Override
    public long[] getLargeUpdateCounts() {
        return new long[]{this.updateCount};
    }

    @Override
    public int getUpdateCount() {
        return (int)this.updateCount;
    }

    @Override
    public long getLargeUpdateCount() {
        return this.updateCount;
    }

    @Override
    public String getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public void addErrorStat() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void addResultSetStat() {
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol, String sql) {
        if (this.insertId == 0L) {
            long[] insertIds = new long[]{};
            return SelectResultSet.createGeneratedData(insertIds, protocol, true);
        }
        if (this.updateCount > 1L && sql != null && !this.isDuplicateKeyUpdate(sql)) {
            long[] insertIds = new long[(int)this.updateCount];
            int i = 0;
            while ((long)i < this.updateCount) {
                insertIds[i] = this.insertId + (long)(i * this.autoIncrement);
                ++i;
            }
            return SelectResultSet.createGeneratedData(insertIds, protocol, true);
        }
        return SelectResultSet.createGeneratedData(new long[]{this.insertId}, protocol, true);
    }

    private boolean isDuplicateKeyUpdate(String sql) {
        Utils.TrimSQLInfo trimSQLStringInternal = Utils.trimSQLStringInternal(sql, false, false, false);
        return trimSQLStringInternal.getTrimedString().matches("(?i).*ON\\s+DUPLICATE\\s+KEY\\s+UPDATE.*");
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        return this.getGeneratedKeys(protocol, null);
    }

    @Override
    public int getCurrentStatNumber() {
        return 1;
    }

    @Override
    public boolean moreResults() {
        this.updateCount = -1L;
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return this.updateCount != -1L;
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId, boolean containOnDuplicateKey, String serverInfo) {
    }

    @Override
    public void setRewrite(boolean rewritten) {
    }

    @Override
    public boolean getRewrite() {
        return false;
    }

    @Override
    public void setArrayBinding(boolean arrayBinding) {
    }
}

