/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication.gssapi;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.send.authentication.gssapi.GssapiAuth;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class StandardGssapiAuthentication
implements GssapiAuth {
    @Override
    public void authenticate(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence, String servicePrincipalName, String mechanisms) throws SQLException, IOException {
        block22: {
            if ("".equals(servicePrincipalName)) {
                throw new SQLException("No principal name defined on server. Please set server variable \"gssapi-principal-name\" or set option \"servicePrincipalName\"", "28000");
            }
            if (System.getProperty("java.security.auth.login.config") == null) {
                File jaasConfFile;
                try {
                    jaasConfFile = File.createTempFile("jaas.conf", null);
                    try (PrintStream bos = new PrintStream(new FileOutputStream(jaasConfFile));){
                        bos.print("Krb5ConnectorContext {\ncom.sun.security.auth.module.Krb5LoginModule required useTicketCache=true debug=true renewTGT=true doNotPrompt=true; };");
                    }
                    jaasConfFile.deleteOnExit();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                System.setProperty("java.security.auth.login.config", jaasConfFile.getCanonicalPath());
            }
            try {
                LoginContext loginContext = new LoginContext("Krb5ConnectorContext");
                loginContext.login();
                Subject mySubject = loginContext.getSubject();
                if (!mySubject.getPrincipals().isEmpty()) {
                    try {
                        PrivilegedExceptionAction<Void> action = () -> {
                            try {
                                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                GSSManager manager = GSSManager.getInstance();
                                GSSName peerName = manager.createName(servicePrincipalName, GSSName.NT_USER_NAME);
                                GSSContext context = manager.createContext(peerName, krb5Mechanism, null, 0);
                                context.requestMutualAuth(true);
                                byte[] inToken = new byte[]{};
                                while (!context.isEstablished()) {
                                    byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                                    if (outToken != null) {
                                        out.startPacket(sequence.incrementAndGet());
                                        out.write(outToken);
                                        out.flush();
                                    }
                                    if (context.isEstablished()) continue;
                                    Buffer buffer = in.getPacket(true);
                                    sequence.set(in.getLastPacketSeq());
                                    inToken = buffer.readBytes(buffer.remaining());
                                }
                            }
                            catch (GSSException le) {
                                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
                            }
                            return null;
                        };
                        Subject.doAs(mySubject, action);
                        break block22;
                    }
                    catch (PrivilegedActionException exception) {
                        throw new SQLException("GSS-API authentication exception", "28000", 1045, exception);
                    }
                }
                throw new SQLException("GSS-API authentication exception : no credential cache not found.", "28000", 1045);
            }
            catch (LoginException le) {
                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
            }
        }
    }
}

