/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.BasePrepareStatement;
import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.BlobFromLocator;
import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.CallableProcedureStatement;
import com.oceanbase.jdbc.ClientSidePreparedStatement;
import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.JDBC4NClob;
import com.oceanbase.jdbc.OceanBaseCallableParameterMetaData;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseResultSetMetaData;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.ResultSetImpl;
import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.NUMBER;
import com.oceanbase.jdbc.extend.datatype.RowIdImpl;
import com.oceanbase.jdbc.extend.datatype.RowObCursorData;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.ErrorPacket;
import com.oceanbase.jdbc.internal.com.read.dao.CmdInformationSingle;
import com.oceanbase.jdbc.internal.com.read.dao.ColumnLabelIndexer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.RefCursor;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.read.resultset.UpdatableColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.BinaryRowProtocol;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.TextRowProtocol;
import com.oceanbase.jdbc.internal.com.send.parameters.BigDecimalParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ByteArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ByteParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DateParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DefaultParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DoubleParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.FloatParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.IntParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.LongParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.NullParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBByteArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStreamParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OffsetTimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.com.send.parameters.ReaderParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ShortParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.StreamParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.StringParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.TimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.TimestampParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ZonedDateTimeParameter;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.input.StandardPacketInputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.ResourceStatus;
import com.oceanbase.jdbc.internal.util.StringUtils;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.util.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;

public class JDBC4ResultSet
implements ResultSetImpl {
    protected static final Logger lockLogger = LoggerFactory.getLogger("JDBC-COST-LOGGER");
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    private static final String NOT_UPDATABLE_ERROR = "Updates are not supported when using ResultSet.CONCUR_READ_ONLY";
    private static final ColumnDefinition[] INSERT_ID_COLUMNS;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    public static String UpdatableResultSet_12;
    protected TimeZone timeZone;
    protected Options options;
    protected ColumnDefinition[] columnsInformation;
    protected int columnInformationLength;
    protected int columnIndexOffset;
    protected int columnIndexEndPos;
    protected boolean noBackslashEscapes;
    protected Protocol protocol;
    protected PacketInputStream reader;
    private boolean callableResult;
    protected OceanBaseStatement statement;
    protected int fetchSize;
    protected int resultSetScrollType;
    protected int resultSetConcurType;
    protected ColumnLabelIndexer columnLabelIndexer;
    public RowProtocol row;
    protected byte[][] data;
    protected int dataSize = -1;
    protected long processedRows;
    protected int discardedRows;
    protected int rowPointer = -1;
    protected int lastRowPointer = -1;
    protected int startIndexInEntireResult;
    protected int endIndexInEntireResult;
    protected boolean isEof;
    protected boolean isLastRowSent;
    protected ResourceStatus status = ResourceStatus.OPEN;
    protected boolean isModified;
    private boolean eofDeprecated;
    protected ReentrantLock lock;
    protected boolean forceAlias;
    public ComplexData[] complexData;
    public int[] complexEndPos;
    private boolean isPsOutParameter;
    private ResultSetMetaData metaData;
    private ResultSetClass rsClass;
    private long createTime;
    private long closeTime;
    protected static final int STATE_STANDARD = 0;
    protected static final int STATE_UPDATE = 1;
    protected static final int STATE_UPDATED = 2;
    protected static final int STATE_INSERT = 3;
    protected OceanBaseConnection connection;
    private String database;
    private String table;
    private boolean canBeUpdate;
    private boolean canBeInserted;
    private boolean canBeRefresh;
    protected int notInsertRowPointer;
    private String exceptionUpdateMsg;
    private String exceptionInsertMsg;
    protected int state = 0;
    private int updatableColumnLength;
    private UpdatableColumnDefinition[] updatableColumns;
    private ParameterHolder[] updatableParameterHolders;
    private List<Integer> primaryKeyIndicies = new ArrayList<Integer>();
    private PreparedStatement refreshPreparedStatement;
    private ClientSidePreparedStatement insertPreparedStatement;
    private ClientSidePreparedStatement deletePreparedStatement;

    public JDBC4ResultSet(ColumnDefinition[] columnDefinition, Results results, Protocol protocol, PacketInputStream reader, boolean callableResult, boolean eofDeprecated, boolean isPsOutParameter) throws IOException, SQLException {
        if (protocol != null && protocol.getTimeTrace() != null) {
            this.createTime = System.nanoTime();
        }
        this.commonConstruct(columnDefinition, results, protocol, callableResult, eofDeprecated, isPsOutParameter);
        this.reader = reader;
        if (this.resultSetScrollType == 1003 && this.resultSetConcurType == 1007 && this.fetchSize == Integer.MIN_VALUE) {
            this.rsClass = ResultSetClass.STREAMING;
            this.fetchSize = 1;
            results.setFetchSize(1);
            this.lock = protocol.getLock();
            protocol.setActiveStreamingResult(results);
            protocol.removeHasMoreResults();
            this.data = new byte[Math.max(10, this.fetchSize)][];
            this.nextStreamingValue();
        } else {
            this.rsClass = ResultSetClass.COMPLETE;
            this.data = new byte[10][];
            this.fetchAllResults();
        }
        this.handelUpdatable(results);
    }

    private void commonConstruct(ColumnDefinition[] columnDefinition, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParameter) {
        this.statement = results.getStatement();
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.noBackslashEscapes = protocol.noBackslashEscapes();
        this.columnsInformation = columnDefinition;
        this.columnLabelIndexer = new ColumnLabelIndexer(this.columnsInformation);
        if (this.statement != null && this.statement.addRowid) {
            this.columnIndexOffset = 1;
        }
        this.columnInformationLength = columnDefinition.length;
        this.complexData = new ComplexData[this.columnInformationLength];
        this.complexEndPos = new int[this.columnInformationLength];
        this.timeZone = protocol.getTimeZoneWithUseLegacyDatetimeCode();
        this.row = results.isBinaryFormat() ? new BinaryRowProtocol(this.columnsInformation, this.columnInformationLength, results.getMaxFieldSize(), this.options) : new TextRowProtocol(results.getMaxFieldSize(), this.options);
        this.row.setProtocol(protocol);
        this.fetchSize = results.getStatement() != null ? results.getStatement().getFetchSize() : results.getFetchSize();
        this.resultSetScrollType = results.getResultSetScrollType();
        this.resultSetConcurType = results.getResultSetConcurrency();
        this.callableResult = callableResult;
        this.eofDeprecated = eofDeprecated;
        this.isPsOutParameter = isPsOutParameter;
    }

    public JDBC4ResultSet(ColumnDefinition[] columnDefinition, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParameter) throws IOException, SQLException {
        if (protocol != null && protocol.getTimeTrace() != null) {
            this.createTime = System.nanoTime();
        }
        this.commonConstruct(columnDefinition, results, protocol, callableResult, eofDeprecated, isPsOutParameter);
        this.reader = protocol.getReader();
        this.lock = protocol.getLock();
        this.rsClass = ResultSetClass.CURSOR;
        this.data = new byte[Math.max(10, this.fetchSize)][];
        this.handelUpdatable(results);
    }

    public boolean assign(JDBC4ResultSet opt) {
        if (opt.data == null || opt.dataSize == 0) {
            return false;
        }
        this.statement = opt.statement;
        this.protocol = opt.protocol;
        this.options = opt.options;
        this.noBackslashEscapes = opt.noBackslashEscapes;
        this.columnsInformation = opt.columnsInformation;
        this.columnLabelIndexer = opt.columnLabelIndexer;
        if (this.statement != null && this.statement.addRowid) {
            this.columnIndexOffset = 1;
        }
        this.columnInformationLength = opt.columnInformationLength;
        this.complexData = opt.complexData;
        this.complexEndPos = opt.complexEndPos;
        this.reader = opt.reader;
        this.isEof = opt.isEof;
        this.timeZone = this.protocol.getTimeZoneWithUseLegacyDatetimeCode();
        this.row = opt.row;
        this.fetchSize = opt.fetchSize;
        this.resultSetScrollType = opt.resultSetScrollType;
        this.resultSetConcurType = opt.resultSetConcurType;
        this.dataSize = opt.dataSize;
        this.rowPointer = opt.rowPointer;
        this.callableResult = opt.callableResult;
        this.eofDeprecated = opt.eofDeprecated;
        this.isPsOutParameter = opt.isPsOutParameter;
        this.data = opt.data;
        this.rsClass = opt.rsClass;
        return true;
    }

    public void changeRowProtocol(RowProtocol row) {
        this.row = row;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public JDBC4ResultSet(ColumnDefinition[] columnDefinition, List<byte[]> resultSet, Protocol protocol, int resultSetScrollType) {
        if (protocol != null && protocol.getTimeTrace() != null) {
            this.createTime = System.nanoTime();
        }
        this.statement = null;
        if (protocol != null) {
            this.options = protocol.getOptions();
            this.timeZone = protocol.getTimeZoneWithUseLegacyDatetimeCode();
        } else {
            this.options = new Options();
            this.timeZone = TimeZone.getDefault();
        }
        this.row = new TextRowProtocol(0, this.options);
        this.row.setProtocol(protocol);
        this.protocol = protocol;
        this.columnsInformation = columnDefinition;
        this.columnLabelIndexer = new ColumnLabelIndexer(this.columnsInformation);
        if (this.statement != null && this.statement.addRowid) {
            this.columnIndexOffset = 1;
        }
        this.columnInformationLength = columnDefinition.length;
        this.isEof = true;
        this.fetchSize = 0;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurType = 1007;
        this.data = (byte[][])resultSet.toArray((T[])new byte[10][]);
        this.dataSize = resultSet.size();
        this.callableResult = false;
        this.rsClass = ResultSetClass.COMPLETE;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public static ResultSet createGeneratedData(long[] data, Protocol protocol, boolean findColumnReturnsOne) {
        ColumnDefinition[] columns = new ColumnDefinition[]{ColumnDefinition.create("GENERATED_KEY", ColumnType.BIGINT, protocol.isOracleMode(), protocol.getOptions().getCharacterEncoding(), protocol.getOptions())};
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (long rowData : data) {
            if (rowData == 0L) continue;
            if (rowData < 0L) {
                columns[0].setUnSigned();
                byte[] bytes = new byte[]{(byte)(rowData >>> 56), (byte)(rowData >>> 48), (byte)(rowData >>> 40), (byte)(rowData >>> 32), (byte)(rowData >>> 24), (byte)(rowData >>> 16), (byte)(rowData >>> 8), (byte)(rowData & 0xFFL)};
                BigInteger val = new BigInteger(1, bytes);
                rows.add(StandardPacketInputStream.create(val.toString().getBytes()));
                continue;
            }
            rows.add(StandardPacketInputStream.create(String.valueOf(rowData).getBytes()));
        }
        if (findColumnReturnsOne) {
            return new JDBC4ResultSet(columns, rows, protocol, 1005){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new JDBC4ResultSet(columns, rows, protocol, 1005);
    }

    public static JDBC4ResultSet createResultSet(String[] columnNames, ColumnType[] columnTypes, String[][] data, Protocol protocol) {
        int columnNameLength = columnNames.length;
        ColumnDefinition[] columns = new ColumnDefinition[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnDefinition.create(columnNames[i], columnTypes[i], protocol.isOracleMode(), protocol.getOptions().getCharacterEncoding(), protocol.getOptions());
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (String[] rowData : data) {
            byte[][] rowBytes = new byte[rowData.length][];
            for (int i = 0; i < rowData.length; ++i) {
                if (rowData[i] == null) continue;
                rowBytes[i] = rowData[i].getBytes();
            }
            rows.add(StandardPacketInputStream.create(rowBytes, columnTypes));
        }
        return new JDBC4ResultSet(columns, rows, protocol, 1005);
    }

    public static JDBC4ResultSet createEmptyResultSet() {
        return new JDBC4ResultSet(INSERT_ID_COLUMNS, new ArrayList<byte[]>(), null, 1005);
    }

    public boolean isFullyLoaded() {
        return this.isEof;
    }

    protected SQLException handleIoException(IOException ioe) {
        return ExceptionFactory.INSTANCE.create("Server has closed the connection. \nPlease check net_read_timeout/net_write_timeout/wait_timeout server variables. If result set contain huge amount of data, Server expects client to read off the result set relatively fast. In this case, please consider increasing net_read_timeout session variable / processing your result set faster (check Streaming result sets documentation for more information)", "08000", ioe);
    }

    public ColumnDefinition[] getColumnsInformation() {
        return this.columnsInformation;
    }

    private void fetchAllResults() throws IOException, SQLException {
        this.dataSize = 0;
        while (!this.isEof) {
            this.addStreamingValue();
        }
        this.updateStartIndexInEntireResult();
    }

    public void fetchRemaining() throws SQLException {
        if (!this.isEof) {
            this.lock.lock();
            try {
                lockLogger.debug("JDBC4ResultSet.fetchRemaining locked");
                this.lastRowPointer = -1;
                while (!this.isEof) {
                    this.addStreamingValue();
                }
                this.updateStartIndexInEntireResult();
            }
            catch (SQLException queryException) {
                throw ExceptionFactory.INSTANCE.create(queryException);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("JDBC4ResultSet.fetchRemaining unlocked");
            }
        }
    }

    private void nextStreamingValue() throws IOException, SQLException {
        this.lastRowPointer = -1;
        if (this.dataSize > 0) {
            this.discardedRows += this.dataSize;
            this.dataSize = 0;
        }
        this.addStreamingValue();
        this.updateStartIndexInEntireResult();
    }

    protected void addStreamingValue() throws IOException, SQLException {
        if (this.dataSize == -1) {
            this.dataSize = 0;
        }
        byte[] buf = this.getNextRow();
        if (this.statement == null || this.statement.getMaxRows() <= 0 || this.endIndexInEntireResult < this.statement.getMaxRows()) {
            if (buf != null) {
                if (this.dataSize + 1 >= this.data.length) {
                    this.growDataArray();
                }
                this.data[this.dataSize++] = buf;
                ++this.processedRows;
                ++this.endIndexInEntireResult;
            }
        } else {
            this.isLastRowSent = true;
        }
    }

    protected void updateStartIndexInEntireResult() {
        if (this.dataSize > 0) {
            this.startIndexInEntireResult = this.endIndexInEntireResult - this.dataSize + 1;
        } else {
            this.startIndexInEntireResult = 0;
            this.endIndexInEntireResult = 0;
        }
    }

    protected byte[] getNextRow() throws IOException, SQLException {
        byte[] buf = this.reader.getPacketArray(false);
        if (buf[0] == -1) {
            this.protocol.removeActiveStreamingResult();
            this.protocol.removeHasMoreResults();
            this.protocol.setHasWarnings(false);
            ErrorPacket errorPacket = new ErrorPacket(new Buffer(buf));
            this.isEof = true;
            throw ExceptionFactory.INSTANCE.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
        }
        if (buf[0] == -2 && (this.eofDeprecated && buf.length < 0xFFFFFF || !this.eofDeprecated && buf.length < 8)) {
            int serverStatus;
            int warnings;
            if (!this.eofDeprecated) {
                warnings = (buf[1] & 0xFF) + ((buf[2] & 0xFF) << 8);
                serverStatus = (buf[3] & 0xFF) + ((buf[4] & 0xFF) << 8);
                if (this.callableResult) {
                    // empty if block
                }
            } else {
                int pos = this.skipLengthEncodedValue(buf, 1);
                pos = this.skipLengthEncodedValue(buf, pos);
                serverStatus = (buf[pos++] & 0xFF) + ((buf[pos++] & 0xFF) << 8);
                warnings = (buf[pos++] & 0xFF) + ((buf[pos] & 0xFF) << 8);
                this.callableResult = (serverStatus & 0x1000) != 0;
            }
            this.reader.getLogger().trace("Got result set.");
            this.protocol.setServerStatus((short)serverStatus);
            this.protocol.setHasWarnings(warnings > 0);
            if ((serverStatus & 8) == 0) {
                this.protocol.removeActiveStreamingResult();
            }
            this.isLastRowSent = (serverStatus & 0x80) != 0;
            this.isEof = true;
            return null;
        }
        this.isEof = false;
        return buf;
    }

    public byte[] getCurrentRowData() {
        return this.data[this.rowPointer];
    }

    protected void updateRowData(byte[] rawData) {
        this.data[this.rowPointer] = rawData;
        this.row.resetRow(this.data[this.rowPointer]);
    }

    private void updateRowDataOneColumn(byte[] newColumn) {
        byte[] newDataRow = new byte[this.data[this.rowPointer].length - this.row.length + newColumn.length];
        System.arraycopy(this.data[this.rowPointer], 0, newDataRow, 0, this.row.pos);
        System.arraycopy(newColumn, 0, newDataRow, this.row.pos, newColumn.length);
        System.arraycopy(this.data[this.rowPointer], this.row.pos + this.row.length, newDataRow, this.row.pos + newColumn.length, this.data[this.rowPointer].length - this.row.pos - this.row.length);
        newDataRow[this.row.pos - 1] = (byte)newColumn.length;
        this.updateRowData(newDataRow);
    }

    protected void deleteCurrentRowData() throws SQLException {
        System.arraycopy(this.data, this.rowPointer + 1, this.data, this.rowPointer, this.dataSize - 1 - this.rowPointer);
        this.data[this.dataSize - 1] = null;
        --this.dataSize;
        this.lastRowPointer = -1;
        this.previous();
    }

    public void addRowData(byte[] rawData) {
        if (this.dataSize + 1 >= this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize] = rawData;
        this.rowPointer = this.dataSize++;
    }

    public void mergeArrayBindingResult(byte[][] rowData) {
        if (rowData == null) {
            return;
        }
        if (this.dataSize == -1) {
            this.dataSize = 0;
        }
        for (byte[] buf : rowData) {
            if (null == buf) continue;
            if (this.dataSize + 1 >= this.data.length) {
                this.growDataArray();
            }
            this.data[this.dataSize++] = buf;
            ++this.processedRows;
            ++this.endIndexInEntireResult;
        }
    }

    private int skipLengthEncodedValue(byte[] buf, int pos) {
        int type = buf[pos++] & 0xFF;
        switch (type) {
            case 251: {
                return pos;
            }
            case 252: {
                return pos + 2 + (0xFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8));
            }
            case 253: {
                return pos + 3 + (0xFFFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos + 2] & 0xFF) << 16));
            }
            case 254: {
                return (int)((long)(pos + 8) + ((long)(buf[pos] & 0xFF) + ((long)(buf[pos + 1] & 0xFF) << 8) + ((long)(buf[pos + 2] & 0xFF) << 16) + ((long)(buf[pos + 3] & 0xFF) << 24) + ((long)(buf[pos + 4] & 0xFF) << 32) + ((long)(buf[pos + 5] & 0xFF) << 40) + ((long)(buf[pos + 6] & 0xFF) << 48) + ((long)(buf[pos + 7] & 0xFF) << 56)));
            }
        }
        return pos + type;
    }

    private void growDataArray() {
        int newCapacity = this.data.length + (this.data.length >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        this.data = (byte[][])Arrays.copyOf(this.data, newCapacity);
    }

    public void abort() throws SQLException {
        this.status = ResourceStatus.CLOSED;
        this.isEof = true;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        if (this.statement != null) {
            this.statement.checkCloseOnCompletion(this);
            this.statement = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.realClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realClose(boolean calledExplicitly) throws SQLException {
        if (this.status == ResourceStatus.CLOSING || this.status == ResourceStatus.CLOSED) {
            return;
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        try {
            this.status = ResourceStatus.CLOSING;
            SQLException exceptionDuringClose = null;
            try {
                this.closeUpdatable();
            }
            catch (SQLException sqlEx) {
                exceptionDuringClose = sqlEx;
            }
            if (this.rsClass == ResultSetClass.STREAMING && !this.isEof) {
                this.lock.lock();
                try {
                    lockLogger.debug("JDBC4ResultSet.realClose locked");
                    while (!this.isEof) {
                        this.dataSize = 0;
                        this.getNextRow();
                    }
                    this.processedRows = 0L;
                }
                catch (SQLException queryException) {
                    throw ExceptionFactory.INSTANCE.create(queryException);
                }
                catch (IOException ioe) {
                    throw this.handleIoException(ioe);
                }
                finally {
                    this.isEof = true;
                    this.lock.unlock();
                    lockLogger.debug("JDBC4ResultSet.realClose unlocked");
                }
            }
            Arrays.fill((Object[])this.data, null);
            if (this.statement != null) {
                try {
                    this.statement.checkCloseOnCompletion(this);
                }
                catch (SQLException sqlEx) {
                    exceptionDuringClose = sqlEx;
                }
                this.statement = null;
            }
            this.row = null;
            this.columnsInformation = null;
            this.complexData = null;
            this.complexEndPos = null;
            this.status = ResourceStatus.CLOSED;
            if (exceptionDuringClose != null) {
                throw exceptionDuringClose;
            }
        }
        finally {
            if (this.protocol != null) {
                if (this.protocol.getTimeTrace() != null) {
                    this.closeTime = System.nanoTime();
                }
                this.protocol.endCallInterface("JDBC4ResultSet.realClose(live for " + (this.closeTime - this.createTime) / 100L + "us)");
            }
        }
    }

    private void resetVariables() {
        this.isEof = false;
        this.isLastRowSent = false;
    }

    private void checkObjectRange(int position) throws SQLException {
        this.checkClose();
        if (this.rowPointer < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.rowPointer >= this.dataSize) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (position <= 0 || position > this.columnInformationLength) {
            throw new SQLDataException("No such column: " + position, "22023");
        }
        if (this.lastRowPointer != this.rowPointer || this.isModified) {
            this.row.resetRow(this.data[this.rowPointer]);
            this.lastRowPointer = this.rowPointer;
        }
        this.row.setPosition(position - 1, this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.dataSize != 0 && this.rowPointer == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        if (this.rsClass == ResultSetClass.STREAMING) {
            if (!this.isEof) {
                this.lock.lock();
                try {
                    lockLogger.debug("JDBC4ResultSet.isAfterLast locked");
                    this.addStreamingValue();
                }
                catch (IOException ioe) {
                    throw this.handleIoException(ioe);
                }
                finally {
                    this.lock.unlock();
                    lockLogger.debug("JDBC4ResultSet.isAfterLast unlocked");
                }
            }
            return this.dataSize == this.rowPointer && this.isEof;
        }
        return this.dataSize > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        return this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        if (this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        return this.isEof && this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize > 0) {
            this.rowPointer = -1;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize > 0) {
            this.rowPointer = this.dataSize;
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        this.rowPointer = 0;
        return this.dataSize > 0;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        this.rowPointer = this.dataSize - 1;
        return this.dataSize > 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        if (row == 0 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid parameter: absolute(0)");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (row == 0 && !this.protocol.isOracleMode()) {
            this.beforeFirst();
            return false;
        }
        if (row > 0) {
            if (row <= this.dataSize) {
                this.rowPointer = row - 1;
                return true;
            }
            this.rowPointer = this.dataSize;
            return false;
        }
        if (this.dataSize + row >= 0) {
            this.rowPointer = this.dataSize + row;
            return true;
        }
        this.rowPointer = -1;
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        int newPos = this.rowPointer + rows;
        if (newPos <= -1) {
            this.rowPointer = -1;
            return false;
        }
        if (newPos >= this.dataSize) {
            this.rowPointer = this.dataSize;
            return false;
        }
        this.rowPointer = newPos;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.resultSetScrollType == 1003 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        this.checkClose();
        if (this.rsClass == ResultSetClass.STREAMING) {
            throw new SQLException("Invalid operation on STREAMING ResultSet");
        }
        this.cancelRowInserts();
        if (this.rowPointer > -1) {
            --this.rowPointer;
            return this.rowPointer > -1;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (this.rowPointer < this.dataSize - 1) {
            ++this.rowPointer;
            return true;
        }
        if (this.rsClass == ResultSetClass.STREAMING && !this.isEof) {
            this.lock.lock();
            try {
                lockLogger.debug("JDBC4ResultSet.next locked");
                this.nextStreamingValue();
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("JDBC4ResultSet.next unlocked");
            }
            this.rowPointer = 0;
            return this.dataSize > 0;
        }
        this.rowPointer = this.dataSize;
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            return this.discardedRows + this.rowPointer + 1;
        }
        return this.rowPointer + 1;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (direction == 1001) {
            throw new SQLException("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (rows < 0) {
            throw new SQLException("invalid fetch size ");
        }
        this.fetchSize = this.protocol.isOracleMode() && rows == 0 ? this.statement.fetchSize : rows;
    }

    @Override
    public int getType() {
        return this.resultSetScrollType;
    }

    public ResultSetClass getRsClass() {
        return this.rsClass;
    }

    @Override
    public int getConcurrency() {
        return this.resultSetConcurType;
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Operation not permit on a closed resultSet", "HY000");
        }
        if (this.statement != null && this.statement.isClosed()) {
            throw new SQLException("Operation not permit on a closed statement", "HY000");
        }
    }

    public boolean isCallableResult() {
        return this.callableResult;
    }

    public boolean isPsOutParameter() {
        return this.isPsOutParameter;
    }

    @Override
    public boolean isClosed() {
        return this.status == ResourceStatus.CLOSED;
    }

    @Override
    public OceanBaseStatement getStatement() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return this.statement;
    }

    public void setStatement(OceanBaseStatement statement) {
        this.statement = statement;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return this.row.wasNull();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_CLOB.getType()) {
            java.sql.Clob clob = this.getClob(columnIndex);
            if (clob == null) {
                return null;
            }
            return clob.getAsciiStream();
        }
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_BLOB.getType()) {
            java.sql.Blob blob = this.getBlob(columnIndex);
            if (blob == null) {
                return null;
            }
            return blob.getBinaryStream();
        }
        try {
            return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), this.protocol.getEncoding()).getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.protocol.getEncoding());
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        switch (this.columnsInformation[actualColumnIndex - 1].getColumnType()) {
            case ORA_CLOB: {
                java.sql.Clob clob = this.getClob(columnIndex);
                if (clob == null) {
                    return null;
                }
                return ((Clob)clob).getString();
            }
            case ORA_BLOB: {
                throw new SQLFeatureNotSupportedException();
            }
            case TIMESTAMP_TZ: {
                TIMESTAMPTZ timestamptz = this.row.getInternalTIMESTAMPTZ(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
                if (timestamptz == null) {
                    return null;
                }
                return timestamptz.toResultSetString(this.statement.getConnection());
            }
            case TIMESTAMP_LTZ: {
                TIMESTAMPLTZ timestampltz = this.row.getInternalTIMESTAMPLTZ(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
                if (timestampltz == null) {
                    return null;
                }
                return timestampltz.toResultSetString(this.statement.getConnection());
            }
        }
        return this.row.getInternalString(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    private String zeroFillingIfNeeded(String value, ColumnDefinition columnDefinition) {
        if (columnDefinition.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnDefinition.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_CLOB.getType()) {
            return this.getClob(columnIndex).getAsciiStream();
        }
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_BLOB.getType()) {
            return this.getBlob(columnIndex).getBinaryStream();
        }
        return new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalInt(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalLong(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        ColumnType type = this.columnsInformation[actualColumnIndex - 1].getColumnType();
        switch (type) {
            case BINARY_DOUBLE: {
                return (float)this.getDouble(columnIndex);
            }
        }
        return this.row.getInternalFloat(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalDouble(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalBigDecimal(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalBigDecimal(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        ColumnType type = this.columnsInformation[actualColumnIndex - 1].getColumnType();
        switch (type) {
            case TINYINT: 
            case INTEGER: 
            case DOUBLE: {
                if (this.protocol.isOracleMode() || !this.isBinaryEncoded()) break;
                return StringUtils.getBytesFromString(this.getString(columnIndex), this.row.getEncoding());
            }
            case ORA_CLOB: {
                throw new SQLFeatureNotSupportedException();
            }
            case ORA_BLOB: {
                java.sql.Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    return null;
                }
                long len = ((Blob)blob).length();
                return blob.getBytes(1L, (int)len);
            }
            case TIMESTAMP_LTZ: {
                TIMESTAMPLTZ timestampltz = this.getTIMESTAMPLTZ(columnIndex);
                if (timestampltz == null) {
                    return null;
                }
                return timestampltz.getBytes();
            }
            case TIMESTAMP_TZ: {
                TIMESTAMPTZ timestamptz = this.getTIMESTAMPTZ(columnIndex);
                if (timestamptz == null) {
                    return null;
                }
                return timestamptz.getBytes();
            }
            case INTERVALYM: {
                INTERVALYM intervalym = this.getINTERVALYM(columnIndex);
                if (intervalym == null) {
                    return null;
                }
                return intervalym.getBytes();
            }
            case INTERVALDS: {
                INTERVALDS intervalds = this.getINTERVALDS(columnIndex);
                if (intervalds == null) {
                    return null;
                }
                return intervalds.getBytes();
            }
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return data;
    }

    @Override
    public java.sql.Date getDate(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalDate(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public java.sql.Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalDate(this.columnsInformation[actualColumnIndex - 1], cal, this.timeZone);
    }

    @Override
    public java.sql.Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTime(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTime(this.columnsInformation[actualColumnIndex - 1], cal, this.timeZone);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    public TIMESTAMP getTIMESTAMP(String columnLabel) throws SQLException {
        return this.getTIMESTAMP(this.findColumn(columnLabel));
    }

    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTIMESTAMP(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public INTERVALDS getINTERVALDS(String columnLabel) throws SQLException {
        return this.getINTERVALDS(this.findColumn(columnLabel));
    }

    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        if (this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return null;
    }

    @Override
    public NUMBER getNUMBER(String columnName) throws SQLException {
        if (this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return null;
    }

    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalINTERVALDS(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public INTERVALYM getINTERVALYM(String columnLabel) throws SQLException {
        return this.getINTERVALYM(this.findColumn(columnLabel));
    }

    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalINTERVALYM(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(String columnLabel) throws SQLException {
        return this.getTIMESTAMPTZ(this.findColumn(columnLabel));
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTIMESTAMPTZ(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(String columnLabel) throws SQLException {
        return this.getTIMESTAMPLTZ(this.findColumn(columnLabel));
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTIMESTAMPLTZ(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTimestamp(this.columnsInformation[actualColumnIndex - 1], cal, this.timeZone);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalTimestamp(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public String getCursorName() throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        return new OceanBaseResultSetMetaData(this.columnsInformation, this.options, this.forceAlias, this.getProtocol().isOracleMode(), this.columnIndexOffset, this.columnIndexEndPos);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        ColumnType type = this.columnsInformation[actualColumnIndex - 1].getColumnType();
        switch (type) {
            case COMPLEX: {
                return this.getComplex(columnIndex);
            }
            case STRUCT: {
                return this.getStruct(columnIndex);
            }
            case ARRAY: {
                return this.getArray(columnIndex);
            }
            case CURSOR: {
                return this.getComplexCursor(columnIndex);
            }
            case ORA_BLOB: {
                return this.getBlob(columnIndex);
            }
            case ORA_CLOB: {
                return this.getClob(columnIndex);
            }
            case ROWID: {
                return new RowIdImpl(this.getString(columnIndex));
            }
        }
        return this.row.getInternalObject(this.columnsInformation[actualColumnIndex - 1], this.timeZone);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Class type cannot be null");
        }
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        ColumnDefinition col = this.columnsInformation[actualColumnIndex - 1];
        if (type.equals(String.class)) {
            if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_CLOB.getType()) {
                String encoding = this.options.getCharacterEncoding();
                byte[] data = new byte[this.row.length];
                System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.length);
                Clob clob = new Clob(true, data, encoding, this.statement.getConnection());
                return (T)clob.getString();
            }
            return (T)this.row.getInternalString(col, null, this.timeZone);
        }
        if (type.equals(Integer.class) || !this.protocol.isOracleMode() && type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.row.getInternalInt(col));
        }
        if (type.equals(Long.class) || !this.protocol.isOracleMode() && type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.row.getInternalLong(col));
        }
        if (type.equals(Short.class) || !this.protocol.isOracleMode() && type.equals(Short.TYPE)) {
            return (T)Short.valueOf(this.row.getInternalShort(col));
        }
        if (type.equals(Double.class) || !this.protocol.isOracleMode() && type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.row.getInternalDouble(col));
        }
        if (type.equals(Float.class) || !this.protocol.isOracleMode() && type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.row.getInternalFloat(col));
        }
        if (type.equals(Byte.class) || !this.protocol.isOracleMode() && type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(this.row.getInternalByte(col));
        }
        if (type.equals(byte[].class)) {
            if (col.getColumnType() == ColumnType.ORA_BLOB) {
                String encoding = this.options.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF8";
                }
                byte[] data = new byte[this.row.length];
                System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.length);
                Blob blob = new Blob(true, data, encoding, this.statement.getConnection());
                return (T)blob.getBytes(1L, (int)blob.length());
            }
            byte[] data = new byte[this.row.getLengthMaxFieldSize()];
            System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
            return (T)data;
        }
        if (type.equals(java.sql.Date.class)) {
            return (T)this.row.getInternalDate(col, null, this.timeZone);
        }
        if (type.equals(Time.class)) {
            return (T)this.row.getInternalTime(col, null, this.timeZone);
        }
        if (type.equals(Timestamp.class) || type.equals(Date.class)) {
            return (T)this.row.getInternalTimestamp(col, null, this.timeZone);
        }
        if (type.equals(Boolean.class) || !this.protocol.isOracleMode() && type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.row.getInternalBoolean(col));
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance(this.timeZone);
            Timestamp timestamp = this.row.getInternalTimestamp(col, null, this.timeZone);
            if (timestamp == null) {
                return null;
            }
            calendar.setTimeInMillis(timestamp.getTime());
            return type.cast(calendar);
        }
        if (type.equals(java.sql.Clob.class) || type.equals(NClob.class)) {
            if (col.getColumnType() == ColumnType.ORA_CLOB) {
                return (T)this.getClob(columnIndex);
            }
            return (T)new Clob(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(InputStream.class)) {
            return (T)new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(Reader.class)) {
            String value = this.row.getInternalString(col, null, this.timeZone);
            if (value == null) {
                return null;
            }
            return (T)new StringReader(value);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.row.getInternalBigDecimal(col);
        }
        if (type.equals(BigInteger.class)) {
            return (T)this.row.getInternalBigInteger(col);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.row.getInternalBigDecimal(col);
        }
        if (type.equals(LocalDateTime.class)) {
            ZonedDateTime zonedDateTime = null;
            zonedDateTime = !this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 ? this.row.getInternalZonedDateTime(col, ZonedDateTime.class, TimeZone.getDefault()) : this.row.getInternalZonedDateTime(col, LocalDateTime.class, this.timeZone);
            return zonedDateTime == null ? null : (T)type.cast(zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (type.equals(ZonedDateTime.class)) {
            ZonedDateTime zonedDateTime = null;
            if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 5) {
                throw new SQLException("Cannot read " + type.getName() + " using a " + col.getColumnType().getSqlTypeName() + " field");
            }
            zonedDateTime = this.row.getInternalZonedDateTime(col, ZonedDateTime.class, this.timeZone);
            if (zonedDateTime == null) {
                return null;
            }
            return type.cast(zonedDateTime);
        }
        if (type.equals(OffsetDateTime.class)) {
            if (!this.protocol.isOracleMode()) {
                if (this.options.compatibleMysqlVersion == 5) {
                    try {
                        return type.cast(OffsetDateTime.parse(this.getString(columnIndex)));
                    }
                    catch (DateTimeParseException zonedDateTime) {
                        throw new SQLException("Cannot read " + type.getName() + " using a " + col.getColumnType().getSqlTypeName() + " field");
                    }
                }
                OffsetDateTime offsetDateTime = null;
                offsetDateTime = this.row.getInternalOffsetDateTime(col, this.timeZone);
                if (offsetDateTime == null) {
                    return null;
                }
                return type.cast(offsetDateTime);
            }
            ZonedDateTime tmpZonedDateTime = this.row.getInternalZonedDateTime(col, OffsetDateTime.class, this.timeZone);
            return tmpZonedDateTime == null ? null : (T)type.cast(tmpZonedDateTime.toOffsetDateTime());
        }
        if (type.equals(LocalDate.class)) {
            LocalDate localDate = this.row.getInternalLocalDate(col, this.timeZone);
            if (localDate == null) {
                return null;
            }
            return type.cast(localDate);
        }
        if (type.equals(LocalTime.class)) {
            LocalTime localTime = this.row.getInternalLocalTime(col, this.timeZone);
            if (localTime == null) {
                return null;
            }
            return type.cast(localTime);
        }
        if (type.equals(OffsetTime.class)) {
            OffsetTime offsetTime = this.row.getInternalOffsetTime(col, this.timeZone);
            if (offsetTime == null) {
                return null;
            }
            return type.cast(offsetTime);
        }
        if (type.equals(Blob.class)) {
            if (col.getColumnType() == ColumnType.ORA_BLOB) {
                return (T)this.getBlob(columnIndex);
            }
            return (T)new Blob(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(Clob.class)) {
            if (col.getColumnType() == ColumnType.ORA_CLOB) {
                return (T)this.getClob(columnIndex);
            }
            return (T)new Clob(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(TIMESTAMPLTZ.class)) {
            if (col.getColumnType() == ColumnType.TIMESTAMP_LTZ) {
                return (T)this.getTIMESTAMPLTZ(columnIndex);
            }
        } else if (type.equals(TIMESTAMPTZ.class)) {
            if (col.getColumnType() == ColumnType.TIMESTAMP_TZ) {
                return (T)this.getTIMESTAMPTZ(columnIndex);
            }
        } else if (type.equals(INTERVALYM.class)) {
            if (col.getColumnType() == ColumnType.INTERVALYM) {
                return (T)this.getINTERVALYM(columnIndex);
            }
        } else if (type.equals(INTERVALDS.class)) {
            if (col.getColumnType() == ColumnType.INTERVALDS) {
                return (T)this.getINTERVALDS(columnIndex);
            }
        } else if (this.options.autoDeserialize) {
            try {
                return type.cast(this.getObject(columnIndex));
            }
            catch (ClassCastException classCastException) {
                SQLException exception = new SQLException("Type class '" + type.getName() + "' is not supported");
                exception.initCause(classCastException);
                throw exception;
            }
        }
        SQLException exception = new SQLException("Type class '" + type.getName() + "' is not supported");
        throw exception;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return type.cast(this.getObject(this.findColumn(columnLabel), type));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return this.columnLabelIndexer.getIndex(columnLabel) - this.columnIndexOffset + 1;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_CLOB.getType()) {
            java.sql.Clob clob = this.getClob(columnIndex);
            if (clob == null) {
                return null;
            }
            return clob.getCharacterStream();
        }
        if (this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_BLOB.getType()) {
            java.sql.Blob blob = this.getBlob(columnIndex);
            if (blob == null) {
                return null;
            }
            return ((Blob)blob).getCharacterStream();
        }
        String value = this.row.getInternalString(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Getting REFs not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Getting REFs not supported");
    }

    @Override
    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        String encoding = this.options.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF8";
        }
        byte[] data = new byte[this.row.length];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.length);
        Blob blob = null;
        blob = this.columnsInformation[actualColumnIndex - 1].getColumnType().getType() == ColumnType.ORA_BLOB.getType() ? new Blob(true, data, encoding, this.statement.getConnection()) : (this.options.emulateLocators && !this.protocol.isOracleMode() ? new BlobFromLocator(this, columnIndex, this.statement.getConnection(), this.options) : new Blob(this.row.buf, this.row.pos, this.row.length));
        blob.isOracleMode = this.protocol.isOracleMode();
        return blob;
    }

    @Override
    public java.sql.Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public java.sql.Clob getClob(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        String encoding = this.options.getCharacterEncoding();
        byte[] data = new byte[this.row.length];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.length);
        Clob clob = null;
        clob = this.columnsInformation[actualColumnIndex - 1].getColumnType() == ColumnType.ORA_CLOB ? new Clob(true, data, encoding, this.statement.getConnection()) : new Clob(false, data, encoding, this.statement.getConnection());
        clob.isOracleMode = this.protocol.isOracleMode();
        return clob;
    }

    @Override
    public java.sql.Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    public void setComplexData(ComplexData[] complexData) {
        this.complexData = complexData;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        if (!this.getProtocol().isOracleMode()) {
            throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
        }
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        int internalColumnIndex = actualColumnIndex - 1;
        OceanBaseConnection conn = this.statement.getConnection();
        if (this.columnsInformation[internalColumnIndex].getColumnType() == ColumnType.COMPLEX) {
            ComplexDataType type;
            String typeName = this.columnsInformation[internalColumnIndex].getComplexTypeName();
            String attrTypename = "";
            if (typeName.isEmpty()) {
                attrTypename = this.getAttrTypeNameOfSetArray(actualColumnIndex);
            }
            if ((type = conn.getComplexDataType(typeName, this.columnsInformation[internalColumnIndex], attrTypename)).getType() != 4 && (type = conn.getComplexDataTypeFromRemote(typeName)).getType() != 4) {
                throw new SQLException("the field complex type is not TYPE_COLLECTION");
            }
            Array ret = this.row.getInternalArray(this.columnsInformation[actualColumnIndex - 1], type, conn);
            this.complexEndPos[actualColumnIndex - 1] = this.row.pos;
            return ret;
        }
        throw new SQLException("the field type is not FIELD_TYPE_COMPLEX");
    }

    public Object getComplex(int columnIndex) throws SQLException {
        if (!this.getProtocol().isOracleMode()) {
            throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
        }
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        int internalColumnIndex = actualColumnIndex - 1;
        OceanBaseConnection conn = this.statement.getConnection();
        if (this.columnsInformation[internalColumnIndex].getColumnType() == ColumnType.COMPLEX) {
            String typeName = this.columnsInformation[internalColumnIndex].getComplexTypeName();
            String attrTypeName = "";
            if (typeName.isEmpty()) {
                attrTypeName = this.getAttrTypeNameOfSetArray(actualColumnIndex);
            }
            ComplexDataType type = null;
            try {
                type = conn.getComplexDataType(typeName, this.columnsInformation[internalColumnIndex], attrTypeName);
            }
            catch (SQLException e) {
                if (e.getMessage().contains("unknown complex data type.") && this.getStatement() instanceof CallableProcedureStatement) {
                    String registerTypeName = this.getRegisterTypeName(e, internalColumnIndex);
                    type = conn.getComplexDataType(registerTypeName, this.columnsInformation[internalColumnIndex], "");
                }
                throw e;
            }
            Object ret = null;
            if (type.getType() == 4) {
                ret = this.row.getInternalArray(this.columnsInformation[actualColumnIndex - 1], type, conn);
                this.complexEndPos[actualColumnIndex - 1] = this.row.pos;
            } else if (type.getType() == 3) {
                ret = this.row.getInternalStruct(this.columnsInformation[actualColumnIndex - 1], type, conn);
                this.complexEndPos[actualColumnIndex - 1] = this.row.pos;
            }
            return ret;
        }
        throw new SQLException("the field type is not FIELD_TYPE_COMPLEX");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    public Struct getStruct(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        int internalColumnIndex = actualColumnIndex - 1;
        OceanBaseConnection conn = this.statement.getConnection();
        if (this.columnsInformation[internalColumnIndex].getColumnType() == ColumnType.COMPLEX) {
            String typeName = this.columnsInformation[internalColumnIndex].getComplexTypeName();
            ComplexDataType type = conn.getComplexDataType(typeName, this.columnsInformation[internalColumnIndex], "");
            if (type.getType() != 3 && (type = conn.getComplexDataTypeFromRemote(typeName)).getType() != 3) {
                throw new SQLException("the field complex type is not TYPE_COLLECTION");
            }
            Struct ret = this.row.getInternalStruct(this.columnsInformation[actualColumnIndex - 1], type, conn);
            this.complexEndPos[actualColumnIndex - 1] = this.row.pos;
            return ret;
        }
        throw new SQLException("the field type is not FIELD_TYPE_COMPLEX");
    }

    public Struct getStruct(String columnLabel) throws SQLException {
        return this.getStruct(this.findColumn(columnLabel));
    }

    public RefCursor getComplexCursor(int columnIndex) throws SQLException {
        Object[] objects;
        RowObCursorData obCursorData;
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        OceanBaseConnection conn = this.statement.getConnection();
        int internalColumnIndex = actualColumnIndex - 1;
        String typeName = this.columnsInformation[internalColumnIndex].getComplexTypeName();
        ComplexDataType type = new ComplexDataType(typeName, typeName, ColumnType.CURSOR.getType());
        if (this.complexData[internalColumnIndex] == null) {
            ComplexData data;
            this.complexData[internalColumnIndex] = data = this.row.getInternalComplexCursor(this.columnsInformation[internalColumnIndex], type, conn);
            this.complexEndPos[actualColumnIndex - 1] = this.row.pos;
        }
        if ((obCursorData = (RowObCursorData)(objects = this.complexData[internalColumnIndex].getAttrData())[0]) != null && !obCursorData.isOpen()) {
            throw new SQLException("cursor is not open");
        }
        Results results = this.statement.getResults();
        RefCursor obCursor = obCursorData.getObCursor();
        if (obCursor == null) {
            try {
                obCursor = new RefCursor(this.columnsInformation, results, this.protocol, false, false, false, obCursorData);
                obCursorData.setObCursor(obCursor);
            }
            catch (IOException e) {
                throw new SQLException("io exception:" + e.getMessage());
            }
        }
        return obCursor;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        try {
            return new URL(this.row.getInternalString(this.columnsInformation[actualColumnIndex - 1], null, this.timeZone));
        }
        catch (MalformedURLException e) {
            throw ExceptionFactory.INSTANCE.create("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return new RowIdImpl(this.getString(columnIndex));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new JDBC4NClob(this.getString(columnIndex), null);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalBoolean(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalByte(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        int actualColumnIndex = columnIndex + this.columnIndexOffset;
        this.checkObjectRange(actualColumnIndex);
        return this.row.getInternalShort(this.columnsInformation[actualColumnIndex - 1]);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    private void handelUpdatable(Results results) throws SQLException {
        if (this.resultSetConcurType == 1008) {
            this.updatableColumnLength = this.columnInformationLength - this.columnIndexOffset;
            this.updatableColumns = new UpdatableColumnDefinition[this.updatableColumnLength];
            if (this.protocol.isOracleMode()) {
                this.mustBeUpdatableForOracle();
            } else {
                this.checkIfUpdatableForMysql(results);
            }
            this.updatableParameterHolders = new ParameterHolder[this.updatableColumnLength];
        }
    }

    private void mustBeUpdatableForOracle() {
        this.database = this.columnsInformation[0].getDatabase();
        this.table = this.columnsInformation[0].getOriginalTable();
        this.connection = this.statement.getConnection();
        for (int index = this.columnIndexOffset; index < this.columnInformationLength; ++index) {
            ColumnDefinition columnDefinition = this.columnsInformation[index];
            this.updatableColumns[index - this.columnIndexOffset] = new UpdatableColumnDefinition(columnDefinition, false, false, false, false, false);
        }
        this.canBeUpdate = true;
        this.canBeInserted = true;
        this.canBeRefresh = true;
    }

    private void checkIfUpdatableForMysql(Results results) throws SQLException {
        this.database = null;
        this.table = null;
        this.canBeUpdate = true;
        this.canBeInserted = true;
        this.canBeRefresh = false;
        for (ColumnDefinition columnDefinition : this.columnsInformation) {
            if (columnDefinition.getDatabase() == null || columnDefinition.getDatabase().isEmpty()) {
                this.cannotUpdateInsertRow("The result-set contains fields without any database information");
                return;
            }
            if (this.database == null) {
                this.database = columnDefinition.getDatabase();
            } else if (!this.database.equals(columnDefinition.getDatabase())) {
                this.cannotUpdateInsertRow("The result-set contains more than one database");
                return;
            }
            if (columnDefinition.getOriginalTable() == null || columnDefinition.getOriginalTable().isEmpty()) {
                this.cannotUpdateInsertRow("The result-set contains fields without any table information");
                return;
            }
            if (this.table == null) {
                this.table = columnDefinition.getOriginalTable();
                continue;
            }
            if (this.table.equals(columnDefinition.getOriginalTable())) continue;
            this.cannotUpdateInsertRow("The result-set contains fields on different tables");
            return;
        }
        if (this.database == null) {
            this.cannotUpdateInsertRow("The result-set does not contain any database information");
            return;
        }
        if (this.table == null) {
            this.cannotUpdateInsertRow("The result-set does not contain any table information");
            return;
        }
        if (this.canBeUpdate) {
            if (results.getStatement() != null && results.getStatement().getConnection() != null) {
                this.connection = results.getStatement().getConnection();
                Statement stmt = this.connection.getMetadataSafeStatement();
                ResultSet rs = stmt.executeQuery("SHOW COLUMNS FROM `" + this.database + "`.`" + this.table + "`");
                boolean primaryFound = false;
                while (rs.next()) {
                    String fieldName = rs.getString("Field");
                    boolean canBeNull = "YES".equals(rs.getString("Null"));
                    boolean hasDefault = rs.getString("Default") == null;
                    String extra = rs.getString("Extra");
                    boolean generated = extra != null && !extra.isEmpty();
                    boolean autoIncrement = "auto_increment".equals(extra);
                    boolean primary = "PRI".equals(rs.getString("Key"));
                    boolean found = false;
                    for (int index = this.columnIndexOffset; !found && index < this.columnInformationLength; ++index) {
                        ColumnDefinition columnDefinition = this.columnsInformation[index];
                        if (!fieldName.equals(columnDefinition.getName())) continue;
                        this.updatableColumns[index - this.columnIndexOffset] = new UpdatableColumnDefinition(columnDefinition, canBeNull, hasDefault, generated, primary, autoIncrement);
                        found = true;
                        if (!primary) continue;
                        this.primaryKeyIndicies.add(index - this.columnIndexOffset);
                    }
                    if (primary) {
                        primaryFound = true;
                    }
                    if (found) continue;
                    if (primary) {
                        this.cannotUpdateInsertRow("Primary key field `" + fieldName + "` is not in result-set");
                        return;
                    }
                    if (canBeNull || hasDefault || generated) continue;
                    this.cannotInsertRow("Field `" + fieldName + "` is not present in query returning fields and cannot be null");
                }
                rs.close();
                stmt.close();
                if (!primaryFound) {
                    this.cannotUpdateInsertRow("Table `" + this.database + "`.`" + this.table + "` has no primary key");
                    return;
                }
                this.canBeRefresh = true;
                boolean ensureAllColumnHaveMeta = true;
                for (int index = this.columnIndexOffset; index < this.columnInformationLength; ++index) {
                    if (this.updatableColumns[index - this.columnIndexOffset] != null) continue;
                    this.cannotUpdateInsertRow("Metadata information not available for table `" + this.database + "`.`" + this.table + "`, field `" + this.columnsInformation[index].getName() + "`");
                    ensureAllColumnHaveMeta = false;
                }
                if (ensureAllColumnHaveMeta) {
                    this.columnsInformation = this.updatableColumns;
                }
            }
        } else {
            throw new SQLException("abnormal error : connection is null");
        }
    }

    private void cannotUpdateInsertRow(String reason) {
        if (this.exceptionUpdateMsg == null) {
            this.exceptionUpdateMsg = "ResultSet cannot be updated. " + reason;
        }
        if (this.exceptionInsertMsg == null) {
            this.exceptionInsertMsg = "No row can be inserted. " + reason;
        }
        this.canBeUpdate = false;
        this.canBeInserted = false;
        this.resultSetConcurType = 1007;
    }

    private void cannotInsertRow(String reason) {
        if (this.exceptionInsertMsg == null) {
            this.exceptionInsertMsg = "No row can be inserted. " + reason;
        }
        this.canBeInserted = false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.protocol.isOracleMode()) {
            return false;
        }
        throw ExceptionFactory.INSTANCE.notSupported("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.protocol.isOracleMode()) {
            return false;
        }
        throw ExceptionFactory.INSTANCE.notSupported("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.protocol.isOracleMode()) {
            return false;
        }
        throw ExceptionFactory.INSTANCE.notSupported("Row deletes are not supported");
    }

    private void closeUpdatable() throws SQLException {
        if (this.canBeUpdate) {
            SQLException sqlEx = null;
            try {
                if (this.refreshPreparedStatement != null) {
                    this.refreshPreparedStatement.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            try {
                if (this.insertPreparedStatement != null) {
                    this.insertPreparedStatement.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            try {
                if (this.deletePreparedStatement != null) {
                    this.deletePreparedStatement.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            this.updatableColumns = null;
            this.updatableParameterHolders = null;
            if (sqlEx != null) {
                throw sqlEx;
            }
        }
    }

    private void checkUpdatable() throws SQLException {
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
        }
    }

    private void checkUpdatable(int position) throws SQLException {
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
        }
        if (position <= 0 || position > this.updatableColumnLength) {
            throw new SQLDataException("No such column: " + position, "22023");
        }
        if (this.state == 0) {
            this.state = 1;
        }
        if (this.state == 1) {
            if (this.rowPointer < 0) {
                throw new SQLDataException("Current position is before the first row", "22023");
            }
            if (this.rowPointer >= this.dataSize) {
                throw new SQLDataException("Current position is after the last row", "22023");
            }
            if (!this.canBeUpdate) {
                throw new SQLException(this.exceptionUpdateMsg);
            }
        }
        if (this.state == 3 && !this.canBeInserted) {
            throw new SQLException(this.exceptionInsertMsg);
        }
    }

    protected boolean checkRefreshable() throws SQLException {
        if (this.resultSetConcurType == 1008 && this.state == 3) {
            throw new SQLException("Cannot call refreshRow() when inserting a new row");
        }
        if (this.protocol.isOracleMode()) {
            if (!this.isValidRow(this.rowPointer)) {
                throw new SQLException("Invalid position in ResultSet.");
            }
        } else {
            if (this.rowPointer < 0) {
                throw new SQLDataException("Current position is before the first row", "22023");
            }
            if (this.rowPointer >= this.dataSize) {
                throw new SQLDataException("Current position is after the last row", "22023");
            }
        }
        return this.resultSetConcurType != 1008 || this.canBeRefresh;
    }

    private StringBuilder generateWhereClauseForMysql() {
        StringBuilder whereClause = new StringBuilder(" WHERE ");
        boolean firstPrimary = true;
        for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
            UpdatableColumnDefinition colInfo = this.updatableColumns[pos];
            if (!colInfo.isPrimary()) continue;
            if (!firstPrimary) {
                whereClause.append("AND ");
            }
            firstPrimary = false;
            if (this.protocol.isOracleMode()) {
                whereClause.append("\"").append(colInfo.getName()).append("\" = ? ");
                continue;
            }
            whereClause.append("`").append(colInfo.getName()).append("` = ? ");
        }
        return whereClause;
    }

    private StringBuilder generateColumnClause() {
        StringBuilder columnClause = new StringBuilder();
        for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
            UpdatableColumnDefinition colInfo = this.updatableColumns[pos];
            if (pos != 0) {
                columnClause.append(",");
            }
            if (this.protocol.isOracleMode()) {
                columnClause.append("\"").append(colInfo.getName()).append("\"");
                continue;
            }
            columnClause.append("`").append(colInfo.getName()).append("`");
        }
        return columnClause;
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported("insertRow are not supported when using ResultSet.CONCUR_READ_ONLY");
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        if (this.state == 3) {
            if (this.insertPreparedStatement == null) {
                StringBuilder insertSql = this.protocol.isOracleMode() ? new StringBuilder("INSERT INTO \"" + this.database + "\".\"" + this.table + "\" ( ") : new StringBuilder("INSERT INTO `" + this.database + "`.`" + this.table + "` ( ");
                StringBuilder columnClause = this.generateColumnClause();
                insertSql.append((CharSequence)columnClause).append(") ");
                StringBuilder valueClause = new StringBuilder();
                for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
                    if (pos != 0) {
                        valueClause.append(", ");
                    }
                    valueClause.append("?");
                }
                insertSql.append("VALUES (").append((CharSequence)valueClause).append(")");
                this.insertPreparedStatement = this.connection.clientPrepareStatement(insertSql.toString());
            }
            int fieldsIndex = 0;
            for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
                ParameterHolder value = this.updatableParameterHolders[pos];
                if (value != null) {
                    this.insertPreparedStatement.setParameter(fieldsIndex++ + 1, value);
                    continue;
                }
                this.insertPreparedStatement.setParameter(fieldsIndex++ + 1, new DefaultParameter());
            }
            this.insertPreparedStatement.execute();
            if (!this.protocol.isOracleMode()) {
                this.prepareRefreshStmt();
                this.refreshPreparedStatement.clearParameters();
                for (int i = 0; i < this.primaryKeyIndicies.size(); ++i) {
                    int index = this.primaryKeyIndicies.get(i);
                    if (this.updatableColumns[index].isAutoIncrement()) {
                        long autoIncrementId = ((CmdInformationSingle)this.insertPreparedStatement.results.getCmdInformation()).getInsertId();
                        if (autoIncrementId <= 0L) continue;
                        this.refreshPreparedStatement.setObject(i + 1, (Object)autoIncrementId, this.updatableColumns[index].getColumnType().getSqlType());
                        continue;
                    }
                    ((BasePrepareStatement)this.refreshPreparedStatement).setParameter(i + 1, this.updatableParameterHolders[index]);
                }
                SelectResultSet rs = (SelectResultSet)this.refreshPreparedStatement.executeQuery();
                if (rs.next()) {
                    this.addRowData(rs.getCurrentRowData());
                    rs.close();
                } else {
                    throw new SQLException(UpdatableResultSet_12);
                }
            }
            Arrays.fill(this.updatableParameterHolders, null);
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4ResultSet.insertRow");
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported("updateRow are not supported when using ResultSet.CONCUR_READ_ONLY");
        }
        if (this.state == 3) {
            throw new SQLException("Cannot call updateRow() when inserting a new row");
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        if (this.state == 1) {
            StringBuilder whereClause;
            StringBuilder updateSql;
            if (this.protocol.isOracleMode()) {
                updateSql = new StringBuilder("UPDATE \"" + this.database + "\".\"" + this.table + "\" SET ");
                whereClause = new StringBuilder(" WHERE ROWID = ?");
            } else {
                updateSql = new StringBuilder("UPDATE `" + this.database + "`.`" + this.table + "` SET ");
                whereClause = this.generateWhereClauseForMysql();
            }
            boolean firstUpdate = true;
            int fieldsToUpdate = 0;
            for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.updatableColumns[pos];
                ParameterHolder value = this.updatableParameterHolders[pos];
                if (value == null) continue;
                if (!firstUpdate) {
                    updateSql.append(",");
                }
                firstUpdate = false;
                ++fieldsToUpdate;
                if (this.protocol.isOracleMode()) {
                    updateSql.append("\"").append(colInfo.getName()).append("\" = ? ");
                    continue;
                }
                updateSql.append("`").append(colInfo.getName()).append("` = ? ");
            }
            updateSql.append((CharSequence)whereClause);
            ClientSidePreparedStatement preparedStatement = this.connection.clientPrepareStatement(updateSql.toString());
            int fieldsIndex = 0;
            int fieldsPrimaryIndex = 0;
            for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
                UpdatableColumnDefinition colInfo;
                ParameterHolder value = this.updatableParameterHolders[pos];
                if (value != null) {
                    preparedStatement.setParameter(fieldsIndex++ + 1, value);
                }
                if (this.protocol.isOracleMode() || !(colInfo = this.updatableColumns[pos]).isPrimary()) continue;
                preparedStatement.setObject(fieldsToUpdate + fieldsPrimaryIndex++ + 1, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
            }
            if (this.protocol.isOracleMode()) {
                int rowidColumnIndex = this.statement.isAddRowid() ? 0 : 1;
                preparedStatement.setRowId(fieldsToUpdate + 1, this.getRowId(rowidColumnIndex));
            }
            preparedStatement.execute();
            preparedStatement.close();
            this.state = 2;
            if (this.protocol.isOracleMode()) {
                this.refreshRowInternalOracle(1);
            } else {
                this.refreshRow();
            }
            Arrays.fill(this.updatableParameterHolders, null);
            this.state = 0;
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4ResultSet.updateRow");
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported("deleteRow are not supported when using ResultSet.CONCUR_READ_ONLY");
        }
        if (this.state == 3) {
            throw new SQLException("Cannot call deleteRow() when inserting a new row");
        }
        if (!this.canBeUpdate) {
            throw new SQLDataException(this.exceptionUpdateMsg);
        }
        if (this.rowPointer < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.rowPointer >= this.dataSize) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        if (this.deletePreparedStatement == null) {
            StringBuilder deleteSql;
            if (this.protocol.isOracleMode()) {
                deleteSql = new StringBuilder("DELETE FROM \"" + this.database + "\".\"" + this.table + "\" WHERE ROWID = ?");
            } else {
                deleteSql = new StringBuilder("DELETE FROM `" + this.database + "`.`" + this.table + "` ");
                StringBuilder whereClause = this.generateWhereClauseForMysql();
                deleteSql.append((CharSequence)whereClause);
            }
            this.deletePreparedStatement = this.connection.clientPrepareStatement(deleteSql.toString());
        }
        if (this.protocol.isOracleMode()) {
            int rowidColumnIndex = this.statement.isAddRowid() ? 0 : 1;
            this.deletePreparedStatement.setRowId(1, this.getRowId(rowidColumnIndex));
        } else {
            int fieldsPrimaryIndex = 1;
            for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.updatableColumns[pos];
                if (!colInfo.isPrimary()) continue;
                this.deletePreparedStatement.setObject(fieldsPrimaryIndex++, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
            }
        }
        this.deletePreparedStatement.executeUpdate();
        if (!this.protocol.isOracleMode() || this.resultSetScrollType != 1003) {
            this.deleteCurrentRowData();
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4ResultSet.deleteRow");
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.protocol.isOracleMode() && (this.resultSetScrollType == 1003 || this.resultSetScrollType == 1004 && this.resultSetConcurType == 1007) || !this.protocol.isOracleMode() && this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported("refreshRow are not supported when using " + this.resultSetScrollType + " and " + this.resultSetConcurType);
        }
        if (!this.checkRefreshable()) {
            return;
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        if (this.protocol.isOracleMode()) {
            this.refreshRowInternalOracle(this.fetchSize);
        } else {
            this.updateRowData(this.refreshRowInternalMysql());
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("JDBC4ResultSet.refreshRow");
        }
    }

    private void prepareRefreshStmt() throws SQLException {
        if (this.refreshPreparedStatement == null) {
            StringBuilder selectSql = new StringBuilder("SELECT ");
            StringBuilder columnClause = this.generateColumnClause();
            selectSql.append((CharSequence)columnClause);
            StringBuilder whereClause = this.generateWhereClauseForMysql();
            selectSql.append(" FROM `").append(this.database).append("`.`").append(this.table).append("`").append((CharSequence)whereClause);
            this.refreshPreparedStatement = this.isBinaryEncoded() ? this.connection.serverPrepareStatement(selectSql.toString()) : this.connection.clientPrepareStatement(selectSql.toString());
        }
    }

    private byte[] refreshRowInternalMysql() throws SQLException {
        this.prepareRefreshStmt();
        int fieldsPrimaryIndex = 1;
        for (int pos = 0; pos < this.updatableColumnLength; ++pos) {
            UpdatableColumnDefinition colInfo = this.updatableColumns[pos];
            if (!colInfo.isPrimary()) continue;
            ParameterHolder value = this.updatableParameterHolders[pos];
            if (this.state != 0 && value != null) {
                if (this.isBinaryEncoded()) {
                    ((ServerSidePreparedStatement)this.refreshPreparedStatement).setParameter(fieldsPrimaryIndex++, value);
                    continue;
                }
                ((ClientSidePreparedStatement)this.refreshPreparedStatement).setParameter(fieldsPrimaryIndex++, value);
                continue;
            }
            this.refreshPreparedStatement.setObject(fieldsPrimaryIndex++, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
        }
        SelectResultSet rs = (SelectResultSet)this.refreshPreparedStatement.executeQuery();
        if (rs.next()) {
            byte[] rowData = rs.getCurrentRowData();
            rs.close();
            return rowData;
        }
        throw new SQLException(UpdatableResultSet_12);
    }

    protected int refreshRowInternalOracle(int size) throws SQLException {
        int rowidColumnIndex = 0;
        int curRowPointer = this.rowPointer;
        int refetchSize = 0;
        RowId[] refetchRowids = new RowId[size];
        while (refetchSize < size && this.isValidRow(this.rowPointer)) {
            refetchRowids[refetchSize++] = this.getRowId(rowidColumnIndex);
            ++this.rowPointer;
        }
        this.rowPointer = curRowPointer;
        if (refetchSize > 0) {
            PreparedStatement pstmt = this.statement.getConnection().prepareStatement(this.getRefetchSql(refetchSize));
            int userParamCount = ((BasePrepareStatement)this.statement).getParameterCount();
            ((BasePrepareStatement)pstmt).setParameterCount(refetchSize + userParamCount);
            ((BasePrepareStatement)pstmt).setParameters(((BasePrepareStatement)this.statement).getParameters());
            for (int i = 0; i < refetchSize; ++i) {
                pstmt.setRowId(userParamCount + i + 1, refetchRowids[i]);
            }
            ResultSet refetchRs = pstmt.executeQuery();
            while (refetchRs.next()) {
                RowId freshRowid = refetchRs.getRowId(1);
                boolean find = false;
                while (!find && this.rowPointer < curRowPointer + refetchSize) {
                    if (Arrays.equals(this.getRowId(rowidColumnIndex).getBytes(), freshRowid.getBytes())) {
                        find = true;
                        continue;
                    }
                    ++this.rowPointer;
                }
                if (find && !Arrays.equals(this.data[this.rowPointer], ((JDBC4ResultSet)refetchRs).getCurrentRowData())) {
                    this.data[this.rowPointer] = Arrays.copyOf(((JDBC4ResultSet)refetchRs).getCurrentRowData(), ((JDBC4ResultSet)refetchRs).getCurrentRowData().length);
                    this.isModified = true;
                }
                this.rowPointer = curRowPointer;
            }
            refetchRs.close();
            pstmt.close();
        }
        return refetchSize;
    }

    protected boolean isValidRow(int rowIndex) throws SQLException {
        if (rowIndex >= 0 && rowIndex < this.dataSize) {
            return true;
        }
        if (rowIndex < 0) {
            return false;
        }
        while (rowIndex >= this.dataSize && this.next()) {
            this.rowPointer = rowIndex;
        }
        return rowIndex < this.dataSize;
    }

    private String getRefetchSql(int refetchSize) {
        int clauseStartPos = this.statement.getClauseStartPos();
        int rowidLen = " rowid,".length();
        String fetchSql = clauseStartPos == -1 ? this.statement.getActualSql() : this.statement.getActualSql().substring(0, clauseStartPos + rowidLen);
        StringBuilder sb = new StringBuilder(fetchSql);
        sb.append(this.statement.getWhereEndPos() == -1 ? " WHERE (ROWID=?" : " AND (ROWID=?");
        for (int i = 0; i < refetchSize - 1; ++i) {
            sb.append(" OR ROWID=?");
        }
        sb.append(")");
        if (clauseStartPos != -1) {
            sb.append(" ").append(this.statement.getActualSql().substring(clauseStartPos + rowidLen));
        }
        return String.valueOf(sb);
    }

    protected void cancelRowInserts() {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
        }
        Arrays.fill(this.updatableParameterHolders, null);
        this.state = 0;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
        }
        if (!this.canBeInserted) {
            throw new SQLException(this.exceptionInsertMsg);
        }
        Arrays.fill(this.updatableParameterHolders, null);
        this.state = 3;
        this.notInsertRowPointer = this.rowPointer;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        if (this.resultSetConcurType == 1007) {
            throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
        }
        Arrays.fill(this.updatableParameterHolders, null);
        this.state = 0;
        this.setRowPointer(this.notInsertRowPointer);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new NullParameter();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.checkUpdatable();
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new ByteParameter(bool ? (byte)1 : 0);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        this.checkUpdatable();
        this.updateBoolean(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new ByteParameter(value);
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        this.checkUpdatable();
        this.updateByte(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new ShortParameter(value);
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        this.checkUpdatable();
        this.updateShort(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new IntParameter(value);
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        this.checkUpdatable();
        this.updateInt(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new FloatParameter(value);
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        this.checkUpdatable();
        this.updateFloat(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new DoubleParameter(value);
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        this.checkUpdatable();
        this.updateDouble(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DECIMAL);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new BigDecimalParameter(value);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        this.checkUpdatable();
        this.updateBigDecimal(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.STRING);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new StringParameter(value, this.noBackslashEscapes, this.protocol.getOptions().getCharacterEncoding());
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        this.checkUpdatable();
        this.updateString(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = this.protocol.isOracleMode() ? new OBByteArrayParameter(value, this.noBackslashEscapes) : new ByteArrayParameter(value, this.noBackslashEscapes);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        this.checkUpdatable();
        this.updateBytes(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateDate(int columnIndex, java.sql.Date date) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (date == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DATE);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new DateParameter(date, TimeZone.getDefault(), this.options);
    }

    @Override
    public void updateDate(String columnLabel, java.sql.Date value) throws SQLException {
        this.checkUpdatable();
        this.updateDate(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (time == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.TIME);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            Timestamp ts = new Timestamp(time.getTime());
            TimeZone tz = this.connection.getProtocol().getTimeZone();
            this.updatableParameterHolders[columnIndex - 1] = new TimestampParameter(ts, tz, this.options.useFractionalSeconds);
        } else {
            this.updatableParameterHolders[columnIndex - 1] = new TimeParameter(time, TimeZone.getDefault(), this.options.useFractionalSeconds);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        this.checkUpdatable();
        this.updateTime(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (timeStamp == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DATETIME);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new TimestampParameter(timeStamp, this.timeZone, this.options.useFractionalSeconds);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        this.checkUpdatable();
        this.updateTimestamp(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkUpdatable();
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        this.updateAsciiStream(columnIndex, inputStream, (long)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, int length) throws SQLException {
        this.checkUpdatable();
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = this.protocol.isOracleMode() ? new OBStreamParameter(inputStream, length, this.noBackslashEscapes) : new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable();
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, (long)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = this.protocol.isOracleMode() ? new OBStreamParameter(inputStream, length, this.noBackslashEscapes) : new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, int length) throws SQLException {
        this.checkUpdatable();
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream, (long)length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable();
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkUpdatable();
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        this.updateCharacterStream(columnIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkUpdatable();
        this.updateCharacterStream(this.findColumn(columnLabel), reader, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new ReaderParameter(value, length, this.noBackslashEscapes);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkUpdatable();
        this.updateCharacterStream(this.findColumn(columnLabel), reader, Long.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateInternalObject(int parameterIndex, Object obj, int targetSqlType, long scaleOrLength) throws SQLException {
        this.checkUpdatable(parameterIndex);
        switch (targetSqlType) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw ExceptionFactory.INSTANCE.notSupported("Type not supported");
            }
        }
        if (obj == null) {
            this.updateNull(parameterIndex);
            return;
        } else if (obj instanceof String) {
            if (targetSqlType == 2004) {
                throw ExceptionFactory.INSTANCE.create("Cannot convert a String to a Blob");
            }
            String str = (String)obj;
            try {
                switch (targetSqlType) {
                    case -7: 
                    case 16: {
                        this.updateBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                        return;
                    }
                    case -6: {
                        this.updateByte(parameterIndex, Byte.parseByte(str));
                        return;
                    }
                    case 5: {
                        this.updateShort(parameterIndex, Short.parseShort(str));
                        return;
                    }
                    case 4: {
                        this.updateInt(parameterIndex, Integer.parseInt(str));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.updateDouble(parameterIndex, (double)Double.valueOf(str));
                        return;
                    }
                    case 7: {
                        this.updateFloat(parameterIndex, Float.valueOf(str).floatValue());
                        return;
                    }
                    case -5: {
                        this.updateLong(parameterIndex, (long)Long.valueOf(str));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.updateBigDecimal(parameterIndex, new BigDecimal(str));
                        return;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        this.updateString(parameterIndex, str);
                        return;
                    }
                    case 93: {
                        if (str.startsWith("0000-00-00")) {
                            this.updateTimestamp(parameterIndex, null);
                            return;
                        }
                        this.updateTimestamp(parameterIndex, Timestamp.valueOf(str));
                        return;
                    }
                    case 92: {
                        this.updateTime(parameterIndex, Time.valueOf((String)obj));
                        return;
                    }
                    case 2013: {
                        this.updatableParameterHolders[parameterIndex - 1] = new OffsetTimeParameter(OffsetTime.parse(str), this.timeZone.toZoneId(), this.options.useFractionalSeconds, this.options);
                        return;
                    }
                    case 2014: {
                        this.updatableParameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter(ZonedDateTime.parse(str, BasePrepareStatement.SPEC_ISO_ZONED_DATE_TIME), this.timeZone.toZoneId(), this.options.useFractionalSeconds, this.options);
                        return;
                    }
                    default: {
                        throw ExceptionFactory.INSTANCE.create("Could not convert [" + str + "] to " + targetSqlType);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.INSTANCE.create("Could not convert [" + str + "] to " + targetSqlType, e);
            }
        } else if (obj instanceof Number) {
            Number bd = (Number)obj;
            switch (targetSqlType) {
                case -6: {
                    this.updateByte(parameterIndex, bd.byteValue());
                    return;
                }
                case 5: {
                    this.updateShort(parameterIndex, bd.shortValue());
                    return;
                }
                case 4: {
                    this.updateInt(parameterIndex, bd.intValue());
                    return;
                }
                case -5: {
                    this.updateLong(parameterIndex, bd.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.updateDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 7: {
                    this.updateFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (obj instanceof BigDecimal) {
                        this.updateBigDecimal(parameterIndex, (BigDecimal)obj);
                        return;
                    }
                    if (obj instanceof Double || obj instanceof Float) {
                        this.updateDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    this.updateLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.updateBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.updateString(parameterIndex, bd.toString());
                    return;
                }
                default: {
                    throw ExceptionFactory.INSTANCE.create("Could not convert [" + bd + "] to " + targetSqlType);
                }
            }
        } else if (obj instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw ExceptionFactory.INSTANCE.create("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.updateBytes(parameterIndex, (byte[])obj);
            return;
        } else if (obj instanceof Time) {
            this.updateTime(parameterIndex, (Time)obj);
            return;
        } else if (obj instanceof Timestamp) {
            this.updateTimestamp(parameterIndex, (Timestamp)obj);
            return;
        } else if (obj instanceof java.sql.Date) {
            this.updateDate(parameterIndex, (java.sql.Date)obj);
            return;
        } else if (obj instanceof Date) {
            long timemillis = ((Date)obj).getTime();
            if (targetSqlType == 91) {
                this.updateDate(parameterIndex, new java.sql.Date(timemillis));
                return;
            } else if (targetSqlType == 92) {
                this.updateTime(parameterIndex, new Time(timemillis));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.updateTimestamp(parameterIndex, new Timestamp(timemillis));
            }
            return;
        } else if (obj instanceof Boolean) {
            this.updateBoolean(parameterIndex, (boolean)((Boolean)obj));
            return;
        } else if (obj instanceof java.sql.Blob) {
            this.updateBlob(parameterIndex, (java.sql.Blob)obj);
            return;
        } else if (obj instanceof java.sql.Clob) {
            this.updateClob(parameterIndex, (java.sql.Clob)obj);
            return;
        } else if (obj instanceof InputStream) {
            this.updateBinaryStream(parameterIndex, (InputStream)obj, scaleOrLength);
            return;
        } else if (obj instanceof Reader) {
            this.updateCharacterStream(parameterIndex, (Reader)obj, scaleOrLength);
            return;
        } else if (obj instanceof LocalDateTime) {
            this.updateTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)obj));
            return;
        } else if (obj instanceof Instant) {
            this.updateTimestamp(parameterIndex, Timestamp.from((Instant)obj));
            return;
        } else if (obj instanceof LocalDate) {
            this.updateDate(parameterIndex, java.sql.Date.valueOf((LocalDate)obj));
            return;
        } else if (obj instanceof OffsetDateTime) {
            this.updatableParameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter(((OffsetDateTime)obj).toZonedDateTime(), this.timeZone.toZoneId(), this.options.useFractionalSeconds, this.options);
            return;
        } else if (obj instanceof OffsetTime) {
            this.updatableParameterHolders[parameterIndex - 1] = new OffsetTimeParameter((OffsetTime)obj, this.timeZone.toZoneId(), this.options.useFractionalSeconds, this.options);
            return;
        } else if (obj instanceof ZonedDateTime) {
            this.updatableParameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter((ZonedDateTime)obj, this.timeZone.toZoneId(), this.options.useFractionalSeconds, this.options);
            return;
        } else {
            if (!(obj instanceof LocalTime)) throw ExceptionFactory.INSTANCE.create("Could not set parameter in setObject, could not convert: " + obj.getClass() + " to " + targetSqlType);
            this.updateTime(parameterIndex, Time.valueOf((LocalTime)obj));
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updateInternalObject(columnIndex, value, this.updatableColumns[columnIndex - 1].getColumnType().getSqlType(), scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updateInternalObject(columnIndex, value, this.updatableColumns[columnIndex - 1].getColumnType().getSqlType(), Long.MAX_VALUE);
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        this.checkUpdatable();
        this.updateObject(this.findColumn(columnLabel), value, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        this.checkUpdatable();
        this.updateObject(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updateInternalObject(columnIndex, x, targetSqlType.getVendorTypeNumber(), Long.MAX_VALUE);
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updatableParameterHolders[columnIndex - 1] = new LongParameter(value);
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        this.checkUpdatable();
        this.updateLong(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("REF not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("REF not supported");
    }

    @Override
    public void updateBlob(int columnIndex, java.sql.Blob blob) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (blob == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = this.protocol.isOracleMode() ? new OBStreamParameter(blob.getBinaryStream(), blob.length(), this.noBackslashEscapes) : new StreamParameter(blob.getBinaryStream(), blob.length(), this.noBackslashEscapes);
    }

    @Override
    public void updateBlob(String columnLabel, java.sql.Blob blob) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported(NOT_UPDATABLE_ERROR);
    }

    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.checkUpdatable();
        this.updateBlob(this.findColumn(columnLabel), (java.sql.Blob)blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBlob(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkUpdatable();
        this.updateBlob(this.findColumn(columnLabel), inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = this.protocol.isOracleMode() ? new OBStreamParameter(inputStream, length, this.noBackslashEscapes) : new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable();
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, java.sql.Clob clob) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (clob == null) {
            this.updatableParameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.updatableParameterHolders[columnIndex - 1] = new ReaderParameter(clob.getCharacterStream(), clob.length(), this.noBackslashEscapes);
    }

    @Override
    public void updateClob(String columnLabel, java.sql.Clob clob) throws SQLException {
        this.checkUpdatable();
        this.updateClob(this.findColumn(columnLabel), clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkUpdatable();
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("RowIDs not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("RowIDs not supported");
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        this.updateString(columnIndex, nstring);
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        this.checkUpdatable();
        this.updateString(columnLabel, nstring);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        this.updateClob(columnIndex, (java.sql.Clob)nclob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        this.updateClob(columnLabel, (java.sql.Clob)nclob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQLXML not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, value, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (!this.protocol.isOracleMode()) {
            throw ExceptionFactory.INSTANCE.notSupported("Method ResultSet.getHoldability() not supported");
        }
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface " + iface.getName());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (!this.protocol.isOracleMode()) {
            this.checkClose();
        }
        return iface.isInstance(this);
    }

    public void setForceTableAlias() {
        this.forceAlias = true;
    }

    private void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnDefinition columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    public int getRowPointer() {
        return this.rowPointer;
    }

    protected void setRowPointer(int pointer) {
        this.rowPointer = pointer;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public boolean isBinaryEncoded() {
        return this.row.isBinaryEncoded();
    }

    public boolean isEof() {
        return this.isEof;
    }

    public byte[][] getRowData() {
        return this.data;
    }

    private String getRegisterTypeName(SQLException e, int internalColumnIndex) throws SQLException {
        CallableProcedureStatement procedureStatement = (CallableProcedureStatement)this.getStatement();
        ParameterMetaData parameterMetaData = procedureStatement.getParameterMetaData();
        Map<String, CallParameter> mapNameToParameter = ((OceanBaseCallableParameterMetaData)parameterMetaData).getMapNameToParameter();
        CallParameter parameter = mapNameToParameter.get(this.columnsInformation[internalColumnIndex].getName());
        String parameterTypeName = parameter.getTypeName();
        if (!parameter.isOutput() || parameterTypeName == null || parameterTypeName.isEmpty()) {
            throw e;
        }
        return parameterTypeName;
    }

    private String getAttrTypeNameOfSetArray(int internalColumnIndex) throws SQLException {
        if (this.getStatement() instanceof CallableProcedureStatement) {
            ParameterHolder holder;
            CallParameter parameter;
            CallableProcedureStatement procedureStatement = (CallableProcedureStatement)this.getStatement();
            int paramIndex = -1;
            for (int i = 0; i < procedureStatement.outputParameterMapper.length; ++i) {
                if (procedureStatement.outputParameterMapper[i] != internalColumnIndex) continue;
                paramIndex = i;
                break;
            }
            if (paramIndex > -1 && (parameter = procedureStatement.params.get(paramIndex)).isInput() && parameter.isOutput() && (holder = (ParameterHolder)procedureStatement.currentParameterHolder.get(paramIndex)) instanceof OBArrayParameter) {
                return ((OBArrayParameter)holder).getArrayValue().getComplexType().getAttrType(0).getTypeName();
            }
        }
        return "";
    }

    static {
        UpdatableResultSet_12 = "refreshRow() called on row that has been deleted or had primary key changed.";
        INSERT_ID_COLUMNS = new ColumnDefinition[1];
        JDBC4ResultSet.INSERT_ID_COLUMNS[0] = ColumnDefinition.create("insert_id", ColumnType.BIGINT, false, "UTF-8", null);
    }

    public static enum ResultSetClass {
        COMPLETE,
        STREAMING,
        CURSOR;

    }
}

