/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseDataSource;
import com.oceanbase.jdbc.OceanBasePooledConnection;
import com.oceanbase.jdbc.OceanBaseXaConnection;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import com.oceanbase.jdbc.internal.util.pool.Pool;
import com.oceanbase.jdbc.internal.util.pool.Pools;
import com.oceanbase.jdbc.util.DefaultOptions;
import com.oceanbase.jdbc.util.Options;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class OceanBasePoolDataSource
extends OceanBaseDataSource
implements ConnectionPoolDataSource,
XADataSource,
Closeable,
AutoCloseable {
    private UrlParser poolUrlParser;
    private Pool pool;
    private String poolName;
    private Integer maxPoolSize;
    private Integer minPoolSize;
    private Integer maxIdleTime;
    private Boolean staticGlobal;
    private Integer poolValidMinDelay;
    private Boolean enablePool;

    public OceanBasePoolDataSource(String hostname, int port, String database) {
        super(hostname, port, database);
    }

    public OceanBasePoolDataSource(String url) {
        super(url);
    }

    public OceanBasePoolDataSource() {
    }

    @Override
    public void setDatabaseName(String database) throws SQLException {
        this.checkNotInitialized();
        this.database = database;
    }

    private void checkNotInitialized() throws SQLException {
        if (this.pool != null) {
            throw new SQLException("can not perform a configuration change once initialized");
        }
    }

    @Override
    public void setUser(String user) throws SQLException {
        this.checkNotInitialized();
        this.user = user;
    }

    @Override
    public void setPassword(String password) throws SQLException {
        this.checkNotInitialized();
        this.password = password;
    }

    @Override
    public void setPort(int port) throws SQLException {
        this.checkNotInitialized();
        this.port = port;
    }

    @Override
    public int getPortNumber() {
        return this.getPort();
    }

    @Override
    public void setPortNumber(int port) throws SQLException {
        this.checkNotInitialized();
        if (port > 0) {
            this.setPort(port);
        }
    }

    @Override
    public void setUrl(String url) throws SQLException {
        this.checkNotInitialized();
        this.url = url;
    }

    @Override
    public void setServerName(String serverName) throws SQLException {
        this.checkNotInitialized();
        this.hostname = serverName;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.poolUrlParser == null) {
            this.initializeUrlParser();
        }
        if (this.enablePool != null && !this.enablePool.booleanValue()) {
            return new OceanBasePooledConnection((OceanBaseConnection)super.getConnection());
        }
        if (this.pool == null) {
            this.initializePool();
        }
        return this.pool.getPooledConnection();
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (this.poolUrlParser == null) {
            this.initializeUrlParser();
        }
        if (this.enablePool != null && !this.enablePool.booleanValue()) {
            return new OceanBasePooledConnection((OceanBaseConnection)super.getConnection(user, password));
        }
        if (this.pool == null) {
            this.user = user;
            this.password = password;
            this.initializePool();
            return this.pool.getPooledConnection();
        }
        if ((this.poolUrlParser.getUsername() != null ? this.poolUrlParser.getUsername().equals(user) : user == null) && (this.poolUrlParser.getPassword() != null ? this.poolUrlParser.getPassword().equals(password) : password == null || password.isEmpty())) {
            return this.pool.getPooledConnection();
        }
        return new OceanBasePooledConnection((OceanBaseConnection)super.getConnection(user, password));
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.connectTimeoutInMs != null) {
            return this.connectTimeoutInMs / 1000;
        }
        return this.poolUrlParser != null ? this.poolUrlParser.getOptions().connectTimeout / 1000 : 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.checkNotInitialized();
        this.connectTimeoutInMs = seconds * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface " + iface.getName());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new OceanBaseXaConnection((OceanBaseConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new OceanBaseXaConnection((OceanBaseConnection)this.getConnection(user, password));
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    protected UrlParser getUrlParser() {
        return this.poolUrlParser;
    }

    public String getPoolName() {
        return this.pool != null ? this.pool.getPoolTag() : this.poolName;
    }

    public void setPoolName(String poolName) throws SQLException {
        this.checkNotInitialized();
        this.poolName = poolName;
    }

    public int getMaxPoolSize() {
        if (this.maxPoolSize == null) {
            return 8;
        }
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) throws SQLException {
        this.checkNotInitialized();
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        if (this.minPoolSize == null) {
            return this.getMaxPoolSize();
        }
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) throws SQLException {
        this.checkNotInitialized();
        this.minPoolSize = minPoolSize;
    }

    public int getMaxIdleTime() {
        if (this.maxIdleTime == null) {
            return 600;
        }
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) throws SQLException {
        this.checkNotInitialized();
        this.maxIdleTime = maxIdleTime;
    }

    public Boolean getStaticGlobal() {
        return this.staticGlobal;
    }

    public void setStaticGlobal(Boolean staticGlobal) {
        this.staticGlobal = staticGlobal;
    }

    public Integer getPoolValidMinDelay() {
        if (this.poolValidMinDelay == null) {
            return 1000;
        }
        return this.poolValidMinDelay;
    }

    public void setPoolValidMinDelay(Integer poolValidMinDelay) {
        this.poolValidMinDelay = poolValidMinDelay;
    }

    private synchronized void initializeUrlParser() throws SQLException {
        if (this.url != null && !this.url.isEmpty()) {
            Properties props = new Properties();
            if (this.user != null) {
                props.setProperty("user", this.user);
            }
            if (this.password != null) {
                props.setProperty("password", this.password);
            }
            if (this.poolName != null) {
                props.setProperty("poolName", this.poolName);
            }
            if (this.database != null) {
                props.setProperty("database", this.database);
            }
            if (this.maxPoolSize != null) {
                props.setProperty("maxPoolSize", String.valueOf(this.maxPoolSize));
            }
            if (this.minPoolSize != null) {
                props.setProperty("minPoolSize", String.valueOf(this.minPoolSize));
            }
            if (this.maxIdleTime != null) {
                props.setProperty("maxIdleTime", String.valueOf(this.maxIdleTime));
            }
            if (this.connectTimeoutInMs != null) {
                props.setProperty("connectTimeout", String.valueOf(this.connectTimeoutInMs));
            }
            if (this.staticGlobal != null) {
                props.setProperty("staticGlobal", String.valueOf(this.staticGlobal));
            }
            if (this.poolValidMinDelay != null) {
                props.setProperty("poolValidMinDelay", String.valueOf(this.poolValidMinDelay));
            }
            this.poolUrlParser = UrlParser.parse(this.url, props);
            this.enablePool = this.poolUrlParser.getOptions().pool;
        } else {
            Options options = DefaultOptions.defaultValues(HaMode.NONE);
            options.user = this.user;
            options.password = this.password;
            options.poolName = this.poolName;
            if (this.maxPoolSize != null) {
                options.maxPoolSize = this.maxPoolSize;
            }
            if (this.minPoolSize != null) {
                options.minPoolSize = this.minPoolSize;
            }
            if (this.maxIdleTime != null) {
                options.maxIdleTime = this.maxIdleTime;
            }
            if (this.staticGlobal != null) {
                options.staticGlobal = this.staticGlobal;
            }
            if (this.connectTimeoutInMs != null) {
                options.connectTimeout = this.connectTimeoutInMs;
            }
            if (this.poolValidMinDelay != null) {
                options.poolValidMinDelay = this.poolValidMinDelay;
            }
            if (this.enablePool != null) {
                options.pool = this.enablePool;
            } else {
                this.enablePool = false;
            }
            this.poolUrlParser = new UrlParser(this.database, Collections.singletonList(new HostAddress(this.hostname == null || this.hostname.isEmpty() ? "localhost" : this.hostname, this.port == null ? 3306 : this.port)), options, HaMode.NONE);
        }
    }

    @Override
    public void close() {
        try {
            if (this.pool != null) {
                this.pool.close();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void initializePool() throws SQLException {
        if (this.pool == null) {
            this.pool = Pools.retrievePool(this.poolUrlParser);
        }
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        return this.pool.testGetConnectionIdleThreadIds();
    }

    public void testForceMaxIdleTime(int maxIdleTime) throws SQLException {
        this.initializeUrlParser();
        this.poolUrlParser.getOptions().maxIdleTime = maxIdleTime;
        this.pool = Pools.retrievePool(this.poolUrlParser);
    }

    public Pool testGetPool() {
        return this.pool;
    }
}

