/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.util.StringUtils;
import com.oceanbase.jdbc.util.Options;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class ColumnDefinition {
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final Buffer buffer;
    private final short charsetNumber;
    private final long length;
    private final ColumnType type;
    private int decimals;
    private int precision;
    private final int inoutType;
    private final int sqltype;
    private int catalogNameStart;
    private int catalogNameLength;
    private int databaseNameStart;
    private int databaseNameLength;
    private int tableNameStart;
    private int tableNameLength;
    private int originalTableNameStart;
    private int originalTableNameLength;
    private int nameStart;
    private int nameLength;
    private int originalColumnNameStart;
    private int originalColumnNameLength;
    private short longColFlag;
    private int complexSchemaNameStart = -1;
    private int complexSchemaNameLength = -1;
    private int complexTypeNameStart = -1;
    private int complexTypeNameLength = -1;
    private int complexVersion = 0;
    private int elemSqlType = -1;
    private final boolean isOracleMode;
    private int precisionAdjustFactor = 0;
    private String encoding = "UTF-8";
    private Options options;
    private String name;
    private String originalName;
    private String databaseName;
    private String tableName;
    private String originalTableName;
    private String complexTypeName;

    public ColumnDefinition(ColumnDefinition other) {
        this.buffer = other.buffer;
        this.charsetNumber = other.charsetNumber;
        this.length = other.length;
        this.sqltype = other.sqltype;
        this.type = other.type;
        this.decimals = other.decimals;
        this.isOracleMode = other.isOracleMode;
        this.precision = other.precision;
        this.inoutType = other.inoutType;
        this.catalogNameLength = other.nameLength;
        this.catalogNameStart = other.catalogNameStart;
        this.databaseNameStart = other.nameStart;
        this.databaseNameLength = other.nameLength;
        this.tableNameLength = other.tableNameLength;
        this.tableNameStart = other.tableNameStart;
        this.originalTableNameStart = other.originalTableNameStart;
        this.originalTableNameLength = other.originalTableNameLength;
        this.originalColumnNameLength = other.originalColumnNameLength;
        this.originalColumnNameStart = other.originalColumnNameStart;
        this.nameStart = other.nameStart;
        this.nameLength = other.nameLength;
        this.longColFlag = other.longColFlag;
        this.options = other.options;
    }

    public ColumnDefinition(Buffer buffer, boolean OracleMode, String encoding, Options options) {
        this.isOracleMode = OracleMode;
        this.encoding = encoding;
        this.buffer = buffer;
        this.options = options;
        this.catalogNameStart = buffer.getPosition() + 1;
        this.catalogNameLength = buffer.fastSkipLenString();
        this.catalogNameStart = this.adjustStartForFieldLength(this.catalogNameStart, this.catalogNameLength);
        this.databaseNameStart = buffer.getPosition() + 1;
        this.databaseNameLength = buffer.fastSkipLenString();
        this.databaseNameStart = this.adjustStartForFieldLength(this.databaseNameStart, this.databaseNameLength);
        this.tableNameStart = buffer.getPosition() + 1;
        this.tableNameLength = buffer.fastSkipLenString();
        this.tableNameStart = this.adjustStartForFieldLength(this.tableNameStart, this.tableNameLength);
        this.originalTableNameStart = buffer.getPosition() + 1;
        this.originalTableNameLength = buffer.fastSkipLenString();
        this.originalTableNameStart = this.adjustStartForFieldLength(this.originalTableNameStart, this.originalTableNameLength);
        this.nameStart = buffer.getPosition() + 1;
        this.nameLength = buffer.fastSkipLenString();
        this.nameStart = this.adjustStartForFieldLength(this.nameStart, this.nameLength);
        this.originalColumnNameStart = buffer.getPosition() + 1;
        this.originalColumnNameLength = buffer.fastSkipLenString();
        this.originalColumnNameStart = this.adjustStartForFieldLength(this.originalColumnNameStart, this.originalColumnNameLength);
        buffer.readByte();
        this.charsetNumber = buffer.readShort();
        this.length = buffer.readLong4BytesV1();
        this.sqltype = buffer.readByte() & 0xFF;
        this.longColFlag = buffer.readShort();
        this.type = ColumnType.convertProtocolTypeToColumnType(this.sqltype, this.charsetNumber, OracleMode, options);
        this.decimals = (byte)(buffer.readByte() & 0xFF);
        this.precision = (byte)(buffer.readByte() & 0xFF);
        this.inoutType = (byte)(buffer.readByte() & 0xFF);
        if (this.isOracleMode && 3 == this.type.getSqlType()) {
            if (this.precision == -1) {
                this.precision = 0;
            }
            if (this.decimals == -85) {
                this.decimals = 0;
            }
        }
        if (ColumnType.COMPLEX.getType() == this.type.getType()) {
            buffer.setPosition(buffer.getPosition());
            this.complexSchemaNameStart = buffer.getPosition() + 1;
            this.complexSchemaNameLength = buffer.fastSkipLenString();
            this.complexSchemaNameStart = this.adjustStartForFieldLength(this.complexSchemaNameStart, this.complexSchemaNameLength);
            this.complexTypeNameStart = buffer.getPosition() + 1;
            this.complexTypeNameLength = buffer.fastSkipLenString();
            this.complexTypeNameStart = this.adjustStartForFieldLength(this.complexTypeNameStart, this.complexTypeNameLength);
            this.complexVersion = (int)buffer.readFieldLength();
            if (this.complexTypeNameLength == 0) {
                this.elemSqlType = buffer.readByte() & 0xFF;
            }
        }
        if (this.isSigned()) {
            switch (this.type) {
                case DECIMAL: 
                case OBDECIMAL: 
                case OLDDECIMAL: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case DOUBLE: 
                case BINARY_DOUBLE: 
                case FLOAT: 
                case BINARY_FLOAT: {
                    this.precisionAdjustFactor = 1;
                }
            }
        } else {
            switch (this.type) {
                case DOUBLE: 
                case BINARY_DOUBLE: 
                case FLOAT: 
                case BINARY_FLOAT: {
                    this.precisionAdjustFactor = 1;
                }
            }
        }
    }

    public static ColumnDefinition create(String name, ColumnType type, boolean isOracleMode, String encoding, Options options) {
        int len;
        int i;
        Charset charset = StringUtils.getCharset(encoding);
        byte[] nameBytes = name.getBytes(charset);
        byte[] arr = new byte[19 + 2 * nameBytes.length];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            arr[pos++] = 0;
        }
        for (i = 0; i < 2; ++i) {
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        arr[pos++] = 12;
        arr[pos++] = 33;
        arr[pos++] = 0;
        switch (type.getSqlType()) {
            case 1: 
            case 12: {
                len = 192;
                break;
            }
            case 5: {
                len = 5;
                break;
            }
            case 0: {
                len = 0;
                break;
            }
            default: {
                len = 1;
            }
        }
        arr[pos] = (byte)len;
        pos += 4;
        arr[pos++] = (byte)type.getType();
        return new ColumnDefinition(new Buffer(arr), isOracleMode, encoding, options);
    }

    private int adjustStartForFieldLength(int nameStart, int nameLength) {
        if (nameLength < 251) {
            return nameStart;
        }
        if (nameLength >= 251 && nameLength < 65536) {
            return nameStart + 2;
        }
        if (nameLength >= 65536 && nameLength < 0x1000000) {
            return nameStart + 3;
        }
        return nameStart + 8;
    }

    public String getDatabase() {
        if (null == this.databaseName) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        return this.databaseName;
    }

    public String getTable() {
        if (null == this.tableName) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public String getOriginalTable() {
        if (null == this.originalTableName) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        return this.originalTableName;
    }

    public String getName() {
        if (null == this.name) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public String getOriginalName() {
        if (null == this.originalName) {
            this.originalName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        return this.originalName;
    }

    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    public long getLength() {
        return this.length;
    }

    public long getPrecision() {
        switch (this.type.getSqlType()) {
            case 3: {
                if (this.isOracleMode) {
                    if (this.precision == 0) {
                        if (this.decimals != 0 && this.decimals >= -84 && this.decimals <= 127) {
                            return 38L;
                        }
                        if (this.decimals == 0) {
                            return 0L;
                        }
                    }
                    return this.precision;
                }
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.options.useNewResultSetMetaData) {
                    return this.getPrecisionWithNewResultSet();
                }
                if (this.decimals > 0) {
                    return this.length - 1L + (long)this.precisionAdjustFactor;
                }
                return this.length + (long)this.precisionAdjustFactor;
            }
        }
        int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
        if (maxWidth == 0) {
            maxWidth = 1;
        }
        switch (this.type) {
            case NVARCHAR2: 
            case NCHAR: {
                if (this.isOracleMode) {
                    if (this.options.useNewResultSetMetaData) {
                        return this.getPrecisionWithNewResultSet();
                    }
                    return this.length / (long)maxWidth;
                }
                return this.length;
            }
            case VARCHAR2: 
            case STRING: 
            case VARSTRING: 
            case ORA_CLOB: {
                if (this.options.useNewResultSetMetaData) {
                    return this.getPrecisionWithNewResultSet();
                }
                if (this.isOracleMode) {
                    return this.length;
                }
                return this.length / (long)maxWidth;
            }
        }
        if (this.options.useNewResultSetMetaData) {
            return this.getPrecisionWithNewResultSet();
        }
        return this.length;
    }

    public long getPrecisionWithNewResultSet() {
        switch (this.type.getSqlType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.isOracleMode) {
                    return this.precision;
                }
                if (!this.isOracleMode && this.options.compatibleMysqlVersion == 8) {
                    return this.clampGetLength(this.getDisplaySize());
                }
                if (this.decimals > 0) {
                    return this.length - 1L + (long)this.precisionAdjustFactor;
                }
                return this.length + (long)this.precisionAdjustFactor;
            }
        }
        int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
        if (maxWidth == 0) {
            maxWidth = 1;
        }
        switch (this.type) {
            case COMPLEX: {
                return this.precision;
            }
            case DATETIME: 
            case TIMESTAMP_NANO: 
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_TZ: 
            case INTERVALYM: 
            case INTERVALDS: 
            case RAW: 
            case ROWID: {
                if (this.isOracleMode) {
                    return this.precision;
                }
            }
            case ORA_CLOB: 
            case ORA_BLOB: 
            case BLOB: {
                if (this.isOracleMode) {
                    return -1L;
                }
            }
            case NVARCHAR2: 
            case NCHAR: 
            case VARCHAR2: 
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                if (this.isOracleMode) {
                    return this.length;
                }
                return this.clampGetLength(this.length) / maxWidth;
            }
        }
        return this.clampGetLength(this.length);
    }

    public int getDisplaySize() {
        if (!this.isOracleMode) {
            if (this.options.useNewResultSetMetaData && this.options.compatibleMysqlVersion == 8) {
                switch (this.type) {
                    case TINYINT: 
                    case SMALLINT: 
                    case MEDIUMINT: 
                    case INTEGER: 
                    case BIGINT: {
                        String typeName = ColumnType.getColumnTypeName(this.type, this.length, this.isSigned(), this.isBinary(), this.isOracleMode, this.options);
                        return (int)ColumnType.getPrecisionBYTypeNameForMysql8(typeName);
                    }
                    case DECIMAL: {
                        long colength = this.length;
                        --colength;
                        if (this.decimals > 0) {
                            --colength;
                        }
                        return (int)colength;
                    }
                }
                int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
                if (maxWidth == 0) {
                    maxWidth = 1;
                }
                return this.clampGetLength(this.length) / maxWidth;
            }
            int vtype = this.type.getSqlType();
            if (vtype == 12 || vtype == 1 || vtype == -9 || vtype == -15 || vtype == 2005) {
                int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
                if (maxWidth == 0) {
                    maxWidth = 1;
                }
                return this.length > Integer.MAX_VALUE ? Integer.MAX_VALUE / maxWidth : (int)this.length / maxWidth;
            }
            if (vtype == -4 && this.length == 0xFFFFFFFFL) {
                return Integer.MAX_VALUE;
            }
        }
        if (this.isOracleMode && this.options.useNewResultSetMetaData) {
            return this.getDisplaySizeWithNewResultSet();
        }
        if (this.type.getSqlType() == 3 && this.isOracleMode) {
            int columnPrecision = this.precision;
            int columnDecimals = this.decimals;
            if (columnPrecision != 0 && columnDecimals == -127) {
                columnPrecision = (int)((double)columnPrecision / 3.32193);
                columnDecimals = 1;
            } else {
                if (columnPrecision == 0) {
                    columnPrecision = 38;
                }
                if (columnDecimals == -127) {
                    columnDecimals = 0;
                }
            }
            int displaySize = columnPrecision + (columnDecimals != 0 ? 1 : 0) + 1;
            return displaySize;
        }
        return (int)this.length;
    }

    public int getDisplaySizeWithNewResultSet() {
        if (this.isOracleMode) {
            switch (this.type.getSqlType()) {
                case 2: 
                case 3: 
                case 8: {
                    if (this.type.equals((Object)ColumnType.BINARY_DOUBLE)) break;
                    int columnPrecision = this.precision;
                    int columnDecimals = this.decimals;
                    if (columnPrecision != 0 && columnDecimals == -127) {
                        columnPrecision = (int)((double)columnPrecision / 3.32193);
                        columnDecimals = 1;
                    } else {
                        if (columnPrecision == 0) {
                            columnPrecision = 38;
                        }
                        if (columnDecimals == -127) {
                            columnDecimals = 0;
                        }
                    }
                    int displaySize = columnPrecision + (columnDecimals != 0 ? 1 : 0) + 1;
                    return displaySize;
                }
            }
        }
        return (int)this.length;
    }

    public int getDecimals() {
        switch (this.type.getSqlType()) {
            case 6: 
            case 7: 
            case 8: {
                if (this.options.useNewResultSetMetaData) {
                    return this.getDecimalsWithNewResultSet();
                }
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.decimals;
            }
            case -102: 
            case -101: 
            case 93: 
            case 1111: {
                if (!this.isOracleMode || !this.options.useNewResultSetMetaData) break;
                return this.getDecimalsWithNewResultSet();
            }
        }
        return 0;
    }

    public int getDecimalsWithNewResultSet() {
        switch (this.type.getSqlType()) {
            case 6: 
            case 7: 
            case 8: {
                if (!this.isOracleMode && this.options.compatibleMysqlVersion == 8 && this.decimals == 31) {
                    return 0;
                }
                return this.decimals;
            }
            case -102: 
            case -101: 
            case 93: 
            case 1111: {
                if (!this.isOracleMode) break;
                if (this.type == ColumnType.COMPLEX) {
                    return 0;
                }
                return this.decimals;
            }
        }
        return 0;
    }

    public int getPrimitiveDecimals() {
        return this.decimals;
    }

    public ColumnType getColumnType() {
        return this.type;
    }

    public short getFlags() {
        return this.longColFlag;
    }

    public boolean isSigned() {
        return (this.longColFlag & 0x20) == 0;
    }

    public void setUnSigned() {
        this.longColFlag = (short)(this.longColFlag | 0x20);
    }

    public boolean isNotNull() {
        return (this.longColFlag & 1) > 0;
    }

    public boolean isPrimaryKey() {
        return (this.longColFlag & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.longColFlag & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.longColFlag & 8) > 0;
    }

    public boolean isBlob() {
        return (this.longColFlag & 0x10) > 0;
    }

    public boolean isZeroFill() {
        return (this.longColFlag & 0x40) > 0;
    }

    public boolean isBinary() {
        return this.getCharsetNumber() == 63;
    }

    public String getComplexTypeName() throws SQLException {
        if (null == this.complexTypeName) {
            this.complexTypeName = this.getStringFromBytes(this.complexTypeNameStart, this.complexTypeNameLength);
        }
        return this.complexTypeName;
    }

    private String toAsciiString(byte[] buffer, int startPos, int length) {
        Charset cs = StringUtils.getCharset(this.encoding);
        return cs.decode(ByteBuffer.wrap(buffer, startPos, length)).toString();
    }

    private String getStringFromBytes(int stringStart, int stringLength) {
        if (stringStart == -1 || stringLength == -1) {
            return null;
        }
        return this.toAsciiString(this.buffer.buf, stringStart, stringLength);
    }

    public int getSqltype() {
        return this.sqltype;
    }

    public boolean isOracleMode() {
        return this.isOracleMode;
    }

    public int clampGetLength(long length) {
        if (length > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)length;
    }

    public int getElemSqlType() {
        return this.elemSqlType;
    }

    public boolean isOutput() {
        return this.inoutType == RoutineParamInOutMode.PARAM_OUT.getValue() || this.inoutType == RoutineParamInOutMode.PARAM_INOUT.getValue();
    }

    public static enum RoutineParamInOutMode {
        PARAM_INVALID(0),
        PARAM_IN(1),
        PARAM_OUT(2),
        PARAM_INOUT(3);

        private final int value;

        private RoutineParamInOutMode(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }
}

