/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset;

import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.Cursor;
import com.oceanbase.jdbc.internal.com.read.resultset.RefCursor;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CursorResultSet
extends Cursor {
    private int statementId;
    protected boolean isServerSide;
    private int currentIndexInEntireResult;
    private int fetchIndexInEntireResult;
    private int lastRowIndexInEntireResult;
    private PreparedStatement statementUsedForFetch;

    public CursorResultSet(ColumnDefinition[] columnsInformation, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParamter) throws IOException, SQLException {
        super(columnsInformation, results, protocol, callableResult, eofDeprecated, isPsOutParamter);
        this.statementId = results.getStatementId();
        if (protocol.supportStmtPrepareExecute() && !(this instanceof RefCursor)) {
            if (protocol != null) {
                protocol.startCallInterface();
            }
            this.getCursorFetchData(this.fetchSize);
            if (protocol != null) {
                protocol.endCallInterface("CursorResultSet");
            }
        }
        if (protocol.supportFetchWithOffset() && !(this instanceof RefCursor)) {
            if (this.resultSetScrollType == 1003) {
                this.isServerSide = true;
            } else if (protocol.supportStmtPrepareExecute()) {
                this.isServerSide = true;
            }
        }
    }

    private void setLastRowIndex() {
        if (this.isLastRowSent && this.lastRowIndexInEntireResult != this.endIndexInEntireResult) {
            this.lastRowIndexInEntireResult = this.endIndexInEntireResult;
        }
    }

    @Override
    protected boolean cursorFetch() throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.lock.lock();
        try {
            lockLogger.debug("CursorResultSet.cursorFetch locked");
            if (this.isLastRowSent || this.statement != null && this.statement.getMaxRows() > 0 && this.endIndexInEntireResult >= this.statement.getMaxRows()) {
                this.isLastRowSent = true;
                boolean bl = false;
                return bl;
            }
            ((ServerSidePreparedStatement)this.getStatement()).cursorFetch(this.statementId, this.getFetchSize());
            this.getCursorFetchData(this.fetchSize);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if ("ORA-01002: fetch out of sequence".equals(e.getMessage())) {
                this.isLastRowSent = true;
            }
            throw e;
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("CursorResultSet.cursorFetch unlocked");
            if (this.protocol != null) {
                this.protocol.endCallInterface("CursorResultSet.cursorFetch");
            }
        }
    }

    private boolean cursorFetchForOracle(byte offsetType, int offset) throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.lock.lock();
        try {
            lockLogger.debug("CursorResultSet.cursorFetchForOracle locked");
            if (this.statement != null && this.statement.getMaxRows() > 0 && this.endIndexInEntireResult >= this.statement.getMaxRows()) {
                this.isLastRowSent = true;
                boolean bl = false;
                return bl;
            }
            ((ServerSidePreparedStatement)this.getStatement()).cursorFetchForOracle(this.statementId, this.getFetchSize(), offsetType, offset);
            if (offsetType == 8) {
                this.endIndexInEntireResult = 0;
            } else if (offsetType == 32) {
                this.endIndexInEntireResult = offset - 1;
            }
            this.getCursorFetchData(this.fetchSize);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if ("ORA-01002: fetch out of sequence".equals(e.getMessage())) {
                this.isLastRowSent = true;
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("CursorResultSet.cursorFetchForOracle unlocked");
            if (this.protocol != null) {
                this.protocol.endCallInterface("CursorResultSet.cursorFetchForOracle");
            }
        }
    }

    private void resetState() {
        this.dataSize = 0;
        this.rowPointer = -1;
        this.lastRowPointer = -1;
    }

    protected void getCursorFetchData(int tmpFetchSize) throws SQLException {
        try {
            if (this.protocol.isOracleMode()) {
                this.processedRows = 0L;
            }
            if (this.dataSize > 0) {
                if (this.resultSetScrollType == 1003) {
                    this.discardedRows += this.dataSize;
                    this.resetState();
                } else if (this.isServerSide) {
                    this.resetState();
                }
            }
            this.isEof = false;
            while (tmpFetchSize >= 0 && !this.isEof) {
                --tmpFetchSize;
                this.addStreamingValue();
            }
            if (this.isServerSide) {
                Buffer buffer = this.reader.getPacket(true);
                if (buffer.getByteAt(0) != 0) {
                    throw ExceptionFactory.INSTANCE.create("expected OK packet at the end of FETCH Response not found");
                }
                buffer.skipByte();
                long rowCount = buffer.getLengthEncodedNumeric();
                this.reader.getLogger().trace("Got tail OK packet in FETCH.");
                this.endIndexInEntireResult = (int)rowCount;
                if (this.statement != null && this.statement.getMaxRows() > 0 && this.endIndexInEntireResult > this.statement.getMaxRows()) {
                    this.dataSize = 0;
                }
                this.updateStartIndexInEntireResult();
                this.setLastRowIndex();
            } else if (this.resultSetScrollType == 1003) {
                this.updateStartIndexInEntireResult();
            } else {
                this.updateStartIndexInEntireResult();
            }
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        if (this.protocol.isOracleMode() && this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.rowPointer == -1;
        }
        return this.currentIndexInEntireResult == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.protocol.isOracleMode() && this.dataSize <= 0 && !this.isLastRowSent) {
            return false;
        }
        if (!this.isServerSide) {
            return this.isLastRowSent && this.rowPointer >= this.dataSize;
        }
        return this.currentIndexInEntireResult == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        if (this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.rowPointer == 0;
        }
        return this.currentIndexInEntireResult == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003 && this.getProtocol().isOracleMode()) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY ResultSet");
        }
        if (this.dataSize <= 0) {
            return false;
        }
        if (!this.isServerSide) {
            return this.isLastRowSent && this.rowPointer == this.dataSize - 1;
        }
        return this.isLastRowSent && this.currentIndexInEntireResult == this.lastRowIndexInEntireResult;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (!this.isServerSide) {
            this.rowPointer = -1;
        } else {
            this.rowPointer = -1;
            this.currentIndexInEntireResult = 0;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return;
        }
        if (!this.isServerSide) {
            while (!this.isLastRowSent && this.cursorFetch()) {
            }
            this.rowPointer = this.dataSize;
        } else {
            this.rowPointer = this.dataSize;
            this.currentIndexInEntireResult = -1;
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            while (!this.isLastRowSent && this.cursorFetch()) {
            }
            this.rowPointer = this.dataSize - 1;
            return this.dataSize > 0;
        }
        if (!this.isLastRowSent) {
            this.cursorFetchForOracle((byte)8, 0);
            if (this.startIndexInEntireResult != this.endIndexInEntireResult) {
                throw new SQLException("startIndexInEntireResult is supposed to equal to endIndexInEntireResult, but actually startIndexInEntireResult is " + this.startIndexInEntireResult + " and endIndexInEntireResult is " + this.endIndexInEntireResult);
            }
        }
        this.rowPointer = this.dataSize - 1;
        this.currentIndexInEntireResult = this.lastRowIndexInEntireResult;
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet: absolute");
        }
        if (row == 0 && this.protocol.isOracleMode()) {
            throw new SQLException("Invalid parameter: absolute(0)");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (row > 0) {
                while (!this.isLastRowSent && row > this.dataSize && this.cursorFetch()) {
                }
                if (row <= this.dataSize) {
                    this.rowPointer = row - 1;
                    return true;
                }
                this.afterLast();
                return false;
            }
            this.last();
            if (row >= -this.dataSize) {
                this.rowPointer = this.dataSize + row;
                return true;
            }
            this.beforeFirst();
            return false;
        }
        if (row > 0) {
            this.fetchIndexInEntireResult = row;
        } else {
            if (this.lastRowIndexInEntireResult == 0 && !this.last()) {
                return false;
            }
            this.fetchIndexInEntireResult = this.lastRowIndexInEntireResult + row + 1;
        }
        return this.fetchAbsoluteRow(this.fetchIndexInEntireResult);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            int newPos = this.rowPointer + rows;
            if (newPos < 0) {
                this.beforeFirst();
                return false;
            }
            return this.absolute(newPos + 1);
        }
        if (this.isAfterLast() && rows >= 0 || this.isBeforeFirst() && rows <= 0) {
            return false;
        }
        if (this.isLast() && rows > 0) {
            this.afterLast();
            return false;
        }
        if (this.isFirst() && rows < 0) {
            this.beforeFirst();
            return false;
        }
        if (this.isAfterLast() && rows < 0) {
            if (!this.last()) {
                return false;
            }
            return this.absolute(this.currentIndexInEntireResult + rows + 1);
        }
        return this.absolute(this.currentIndexInEntireResult + rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation on TYPE_FORWARD_ONLY CURSOR ResultSet");
        }
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (this.rowPointer > -1) {
                --this.rowPointer;
                return this.rowPointer > -1;
            }
            return false;
        }
        if (this.isAfterLast()) {
            return this.last();
        }
        this.fetchIndexInEntireResult = this.currentIndexInEntireResult - 1;
        return this.fetchAbsoluteRow(this.fetchIndexInEntireResult);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        this.cancelRowInserts();
        if (this.dataSize == 0) {
            return false;
        }
        if (!this.isServerSide) {
            if (this.rowPointer < this.dataSize - 1) {
                ++this.rowPointer;
                return true;
            }
            if (this.isLastRowSent) {
                this.rowPointer = this.dataSize;
                return false;
            }
            if (!this.cursorFetch()) {
                if (this.rowPointer < this.dataSize) {
                    ++this.rowPointer;
                }
                return false;
            }
            ++this.rowPointer;
            return this.dataSize > this.rowPointer;
        }
        if (this.isAfterLast()) {
            return false;
        }
        this.fetchIndexInEntireResult = this.currentIndexInEntireResult + 1;
        return this.fetchAbsoluteRow(this.fetchIndexInEntireResult);
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (!this.isServerSide) {
            return super.getRow();
        }
        return this.currentIndexInEntireResult;
    }

    private boolean fetchAbsoluteRow(int fetchIndex) throws SQLException {
        if (fetchIndex < 1) {
            this.rowPointer = -1;
            this.currentIndexInEntireResult = 0;
            return false;
        }
        if (this.lastRowIndexInEntireResult < fetchIndex && this.lastRowIndexInEntireResult > 0) {
            this.rowPointer = this.dataSize;
            this.currentIndexInEntireResult = -1;
            return false;
        }
        if (this.startIndexInEntireResult <= fetchIndex && fetchIndex <= this.endIndexInEntireResult) {
            this.rowPointer = fetchIndex - this.startIndexInEntireResult;
            this.currentIndexInEntireResult = fetchIndex;
            return true;
        }
        try {
            this.cursorFetchForOracle((byte)32, fetchIndex);
            this.rowPointer = 0;
            this.currentIndexInEntireResult = this.startIndexInEntireResult;
            return this.dataSize > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setStatementUsedForFetch(PreparedStatement stmt) {
        this.statementUsedForFetch = stmt;
    }

    @Override
    public void close() throws SQLException {
        if (this.statementUsedForFetch != null) {
            this.statementUsedForFetch.close();
            this.statementUsedForFetch = null;
        }
        super.close();
    }
}

