/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send;

import com.oceanbase.jdbc.JDBC4ServerCallableStatement;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.send.parameters.OBArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStructParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBVarcharParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class ComStmtPrepareExecute {
    private static int NOT_RETURNING_RESULT_SET = 0;
    private static int RETURNING_RESULT_SET_WITHOUT_FIELD = 1;
    private static int ARRAY_BINDING_FIELD = 2;
    private static int RETURNING_RESULT_SET_WITH_FIELD = 3;
    private static int PL_OUT_PARAMETER = 4;

    public static void send(PacketOutputStream pos, Results results, int parameterCount, ParameterHolder[] parameters, ColumnType[] parameterTypeHeader, byte cursorFlag, Protocol protocol, ServerPrepareResult serverPrepareResult) throws IOException, SQLException {
        pos.startPacket(0);
        pos.write(-95);
        if (serverPrepareResult == null) {
            pos.writeInt(results.getStatementId());
        } else {
            pos.writeInt(serverPrepareResult.getStatementId());
        }
        pos.write(cursorFlag);
        pos.writeInt(protocol.getIterationCount());
        OBVarcharParameter lengthEncodedString = new OBVarcharParameter(results.getStatement().getActualSql(), protocol.noBackslashEscapes(), protocol.getOptions().getCharacterEncoding());
        lengthEncodedString.writeBinary(pos);
        pos.writeInt(parameterCount);
        if (parameterCount > 0) {
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (!parameters[i2].isNullData()) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterTypeHeader == null || parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader[i].equals((Object)parameters[i].getColumnType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            pos.write((byte)(mustSendHeaderType ? 1 : 0));
            if (mustSendHeaderType) {
                for (i = 0; i < parameterCount; ++i) {
                    ColumnType columnType = parameters[i].getColumnType();
                    if (parameterTypeHeader != null) {
                        parameterTypeHeader[i] = columnType;
                    }
                    pos.writeShort(columnType.getType());
                    if (columnType.getType() != ColumnType.COMPLEX.getType()) continue;
                    ParameterHolder obj = parameters[i];
                    if (obj instanceof OBArrayParameter) {
                        ((OBArrayParameter)obj).storeArrayTypeInfo(pos);
                        continue;
                    }
                    if (obj instanceof OBStructParameter) {
                        ((OBStructParameter)obj).storeStructTypeInfo(pos);
                        continue;
                    }
                    throw new SQLException("complex param type is not supported\uff0c only array is supported");
                }
            }
            for (i = 0; i < parameterCount; ++i) {
                ParameterHolder holder = parameters[i];
                if (holder.isNullData() || holder.isLongData()) continue;
                holder.writeBinary(pos);
            }
        }
        pos.writeInt(protocol.getExecuteMode());
        pos.writeInt(0);
        pos.writeInt((int)protocol.getChecksum());
        pos.writeInt(0);
        pos.flush();
    }

    public static ServerPrepareResult read(Protocol protocol, PacketInputStream reader, ServerPrepareResult serverPrepareResult, Results results) throws IOException, SQLException {
        reader.startReceiveResponse();
        try {
            boolean eofDeprecated = protocol.isEofDeprecated();
            Buffer buffer = reader.getPacket(true);
            byte firstByte = buffer.getByteAt(0);
            switch (firstByte) {
                case 0: {
                    buffer.skipByte();
                    int statementId = buffer.readInt();
                    results.setStatementId(statementId);
                    int numColumns = buffer.readShort() & 0xFFFF;
                    int numParams = buffer.readInt2BytesV1();
                    byte reserved1 = buffer.readByte();
                    short warningCount = buffer.readShort();
                    int extendFlag = buffer.readInt();
                    byte hasResultSet = buffer.readByte();
                    reader.getLogger().trace("Got header OK packet.");
                    ColumnDefinition[] params = new ColumnDefinition[numParams];
                    if (numParams > 0) {
                        for (int i = 0; i < numParams; ++i) {
                            params[i] = new ColumnDefinition(reader.getPacket(false), true, protocol.getOptions().getCharacterEncoding(), protocol.getOptions());
                        }
                        if (!eofDeprecated) {
                            protocol.skipEofPacket();
                        }
                        reader.getLogger().trace("Got param definition.");
                    }
                    ColumnDefinition[] columns = new ColumnDefinition[numColumns];
                    if (hasResultSet == 1) {
                        if ((extendFlag & RETURNING_RESULT_SET_WITHOUT_FIELD) != 0 || (extendFlag & ARRAY_BINDING_FIELD) != 0 || (extendFlag & PL_OUT_PARAMETER) != 0) {
                            results.setInternalResult(true);
                        }
                        results.setToPrepareExecute(true);
                        results.setReturning((extendFlag & RETURNING_RESULT_SET_WITHOUT_FIELD) != 0);
                        protocol.readResultSet(columns, results);
                        results.setToPrepareExecute(false);
                        results.setInternalResult(false);
                    }
                    buffer = reader.getPacket(false);
                    switch (buffer.getByteAt(0)) {
                        case 0: {
                            protocol.readOkPacket(buffer, results);
                            reader.getLogger().trace("Got tail OK packet.");
                            break;
                        }
                        case -1: {
                            reader.getLogger().trace("Got tail ERROR packet.");
                            if (serverPrepareResult == null && statementId != 0) {
                                protocol.forceReleasePrepareStatement(statementId);
                            }
                            throw protocol.readErrorPacket(buffer, results);
                        }
                        default: {
                            reader.getLogger().error("Got unexpected tail packet returned by server, first byte " + firstByte);
                            throw new SQLException("Unexpected tail packet returned by server, first byte " + firstByte);
                        }
                    }
                    if (serverPrepareResult == null) {
                        String sql = results.getSql();
                        serverPrepareResult = new ServerPrepareResult(sql, statementId, columns, params, protocol);
                        serverPrepareResult.setReturnByPrepareExecute(true);
                        if (results.getStatement() != null && results.getStatement() instanceof JDBC4ServerCallableStatement) {
                            JDBC4ServerCallableStatement callableStatement = (JDBC4ServerCallableStatement)results.getStatement();
                            callableStatement.addCallableStatementCacheIfNeed(serverPrepareResult);
                        }
                        if (protocol.getOptions().cachePrepStmts && protocol.getOptions().useServerPrepStmts && sql != null && sql.length() < protocol.getOptions().prepStmtCacheSqlLimit) {
                            String key = protocol.getDatabase() + "-" + sql;
                            ServerPrepareResult cachedServerPrepareResult = protocol.addPrepareInCache(key, serverPrepareResult);
                            ServerPrepareResult serverPrepareResult2 = cachedServerPrepareResult != null ? cachedServerPrepareResult : serverPrepareResult;
                            return serverPrepareResult2;
                        }
                    } else {
                        serverPrepareResult.setStatementId(statementId);
                    }
                    ServerPrepareResult serverPrepareResult3 = serverPrepareResult;
                    return serverPrepareResult3;
                }
                case -1: {
                    reader.getLogger().trace("Got header ERROR packet.");
                    throw protocol.readErrorPacket(buffer, results);
                }
            }
            reader.getLogger().error("Got unexpected header packet returned by server, first byte " + firstByte);
            throw new SQLException("Unexpected header packet returned by server, first byte " + firstByte);
        }
        finally {
            reader.endReceiveResponse(results.getSql());
        }
    }

    public static void readTailPacket(Protocol protocol, PacketInputStream reader, Results results, boolean hasResultSet) throws IOException, SQLException {
        Buffer buffer = reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case 0: {
                if (hasResultSet) break;
                protocol.readOkPacket(buffer, results);
                break;
            }
            case -1: {
                throw protocol.readErrorPacket(buffer, results);
            }
        }
    }

    private static void writeCmdArrayBinding(int statementId, List<ParameterHolder[]> queryParameters, int queryParamtersSize, int parameterCount, ColumnType[] parameterTypeHeader, PacketOutputStream pos, byte cursorFlag, Protocol protocol, Results results, ServerPrepareResult serverPrepareResult) throws IOException, SQLException {
        pos.write(-95);
        if (serverPrepareResult == null) {
            pos.writeInt(results.getStatementId());
        } else {
            pos.writeInt(serverPrepareResult.getStatementId());
        }
        pos.write(cursorFlag);
        pos.writeInt(protocol.getIterationCount());
        OBVarcharParameter lengthEncodedString = new OBVarcharParameter(results.getStatement().getActualSql(), protocol.noBackslashEscapes(), protocol.getOptions().getCharacterEncoding());
        lengthEncodedString.writeBinary(pos);
        pos.writeInt(parameterCount);
        if (parameterCount > 0) {
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = true;
            if (mustSendHeaderType) {
                pos.write(1);
                for (int i = 0; i < parameterCount; ++i) {
                    pos.writeShort(ColumnType.COMPLEX.getType());
                    pos.writeFieldLength(0L);
                    pos.writeFieldLength(0L);
                    pos.writeFieldLength(0L);
                    short elementType = queryParameters.get(0)[i].getColumnType().getType();
                    pos.writeBytes((byte)elementType, 1);
                }
            } else {
                pos.write(0);
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            ParameterHolder curHolder = queryParameters.get(0)[i];
            pos.writeFieldLength(queryParamtersSize);
            int nullCount = (queryParamtersSize + 7) / 8;
            int nullBitsPosition = pos.getPosition();
            if (!curHolder.isLongData()) {
                for (int j = 0; j < nullCount; ++j) {
                    pos.writeBytes((byte)0, 1);
                }
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int j = 0; j < queryParamtersSize; ++j) {
                ParameterHolder holder = queryParameters.get(j)[i];
                if (null != holder && !holder.isLongData() && !holder.isNullData()) {
                    holder.writeBinary(pos);
                    continue;
                }
                int n = j / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << j % 8);
            }
            if (curHolder.isLongData()) continue;
            int endPosition = pos.getPosition();
            pos.setPosition(nullBitsPosition);
            pos.write(nullBitsBuffer);
            pos.setPosition(endPosition);
        }
        pos.writeInt(protocol.getExecuteMode());
        pos.writeInt(0);
        pos.writeInt((int)protocol.getChecksum());
        pos.writeInt(0);
    }

    public static void sendArrayBinding(PacketOutputStream pos, int statementId, List<ParameterHolder[]> queryParameters, int queryParamtersSize, int parameterCount, ColumnType[] parameterTypeHeader, byte cursorFlag, Protocol protocol, Results results, ServerPrepareResult serverPrepareResult) throws IOException, SQLException {
        pos.startPacket(0);
        ComStmtPrepareExecute.writeCmdArrayBinding(statementId, queryParameters, queryParamtersSize, parameterCount, parameterTypeHeader, pos, cursorFlag, protocol, results, serverPrepareResult);
        pos.flush();
    }
}

