/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util.dao;

import com.oceanbase.jdbc.internal.util.StringUtils;
import com.oceanbase.jdbc.internal.util.dao.PrepareResult;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ClientPrepareResult
implements PrepareResult {
    private final String sql;
    private final List<byte[]> queryParts;
    private final boolean rewriteType;
    private final int paramCount;
    private boolean isQueryMultiValuesRewritable = true;
    private boolean isQueryMultipleRewritable = true;

    private ClientPrepareResult(String sql, List<byte[]> queryParts, boolean isQueryMultiValuesRewritable, boolean isQueryMultipleRewritable, boolean rewriteType, boolean hasParam) {
        this.sql = sql;
        this.queryParts = queryParts;
        this.isQueryMultiValuesRewritable = isQueryMultiValuesRewritable;
        this.isQueryMultipleRewritable = isQueryMultipleRewritable;
        this.paramCount = !hasParam ? 0 : queryParts.size() - (rewriteType ? 3 : 1);
        this.rewriteType = rewriteType;
    }

    public static ClientPrepareResult parameterParts(String queryString, boolean noBackslashEscapes, boolean isOracleMode, String encoding) {
        Charset charset = StringUtils.getCharset(encoding);
        boolean reWritablePrepare = false;
        boolean multipleQueriesPrepare = true;
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean endingSemicolon = false;
        int lastCommentEndStarPos = -2;
        int lastCommentBeginSlashPos = 0;
        boolean singleQuotes = false;
        int lastParameterPosition = 0;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        boolean slashend = false;
        boolean endNameBinding = false;
        StringBuilder paramSb = new StringBuilder();
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/' || i <= lastCommentEndStarPos + 2) break;
                    state = LexState.SlashStarComment;
                    lastCommentBeginSlashPos = i - 1;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*' && i > lastCommentBeginSlashPos + 2) {
                        state = LexState.Normal;
                        slashend = true;
                        lastCommentEndStarPos = i - 1;
                        break;
                    }
                    if (state == LexState.Normal && slashend && lastChar == '/') {
                        slashend = false;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (isOracleMode || state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '\n': {
                    if (state == LexState.EOLComment) {
                        multipleQueriesPrepare = true;
                        state = LexState.Normal;
                    }
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || !singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || isOracleMode || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case ';': {
                    if (isOracleMode && state == LexState.NabmeBinding) {
                        endNameBinding = true;
                    }
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    partList.add(queryString.substring(lastParameterPosition, i).getBytes(charset));
                    lastParameterPosition = i + 1;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case ':': {
                    if (!isOracleMode) break;
                    if (state == LexState.Normal) {
                        state = LexState.NabmeBinding;
                    }
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                    multipleQueriesPrepare = true;
                    break;
                }
                case '=': {
                    if (!isOracleMode) break;
                    if (state == LexState.NabmeBinding) {
                        state = LexState.Normal;
                    }
                    if (state != LexState.Normal || !endingSemicolon || car < 40) break;
                    endingSemicolon = false;
                    multipleQueriesPrepare = true;
                    break;
                }
                case ' ': 
                case ')': 
                case ',': 
                case '}': {
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || car < 40) break;
                    endingSemicolon = false;
                    multipleQueriesPrepare = true;
                }
            }
            if (isOracleMode && state == LexState.NabmeBinding && car >= '(' && !endNameBinding) {
                paramSb.append(car);
            }
            if (isOracleMode && state == LexState.NabmeBinding && (endNameBinding || i == queryLength - 1)) {
                String tmp = paramSb.toString();
                if (tmp.indexOf(46) != -1) {
                    paramSb.setLength(0);
                    state = LexState.Normal;
                } else {
                    partList.add(queryString.substring(lastParameterPosition, i - paramSb.length()).getBytes(charset));
                    paramSb.setLength(0);
                    state = LexState.Normal;
                    lastParameterPosition = endNameBinding ? i : i + 1;
                    endNameBinding = false;
                }
            }
            lastChar = car;
        }
        if (lastParameterPosition == 0) {
            partList.add(queryString.getBytes(charset));
        } else {
            partList.add(queryString.substring(lastParameterPosition, queryLength).getBytes(charset));
        }
        return new ClientPrepareResult(queryString, partList, reWritablePrepare, multipleQueriesPrepare, false, true);
    }

    public static boolean canAggregateSemiColon(String queryString, boolean noBackslashEscapes, boolean isOracleMode) {
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        boolean endingSemicolon = false;
        char[] query = queryString.toCharArray();
        int lastCommentEndStarPos = -2;
        int lastCommentBeginSlashPos = 0;
        int i = 0;
        for (char car : query) {
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/' || i <= lastCommentEndStarPos + 2) break;
                    state = LexState.SlashStarComment;
                    lastCommentBeginSlashPos = i - 1;
                    break;
                }
                case '/': {
                    if (state != LexState.SlashStarComment || lastChar != '*' || i <= lastCommentBeginSlashPos + 2) break;
                    state = LexState.Normal;
                    lastCommentEndStarPos = i - 1;
                    break;
                }
                case '#': {
                    if (isOracleMode || state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || !singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || isOracleMode || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                }
            }
            ++i;
            lastChar = car;
        }
        return state != LexState.EOLComment && !endingSemicolon;
    }

    public static ClientPrepareResult rewritableParts(String queryString, boolean noBackslashEscapes, boolean isOracleMode, String encoding) {
        Charset charset = StringUtils.getCharset(encoding);
        boolean reWritablePrepare = true;
        boolean multipleQueriesPrepare = true;
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        LexState state = LexState.Normal;
        KeyState keyState = KeyState.Normal;
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        String preValuePart1 = null;
        String preValuePart2 = null;
        String postValuePart = null;
        boolean singleQuotes = false;
        int isInParenthesis = 0;
        boolean skipChar = false;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        boolean hasParam = false;
        boolean endNameBinding = false;
        boolean flagValues = false;
        boolean flagValue = false;
        int onDuplicateKeyUpdateIndex = -1;
        int lastCommentEndStarPos = -2;
        int lastCommentBeginSlashPos = 0;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                sb.append(car);
                lastChar = car;
                state = LexState.String;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/' || i <= lastCommentEndStarPos + 2) break;
                    state = LexState.SlashStarComment;
                    lastCommentBeginSlashPos = i - 1;
                    break;
                }
                case '/': {
                    if (state != LexState.SlashStarComment || lastChar != '*' || i <= lastCommentBeginSlashPos + 2) break;
                    state = LexState.Normal;
                    lastCommentEndStarPos = i - 1;
                    break;
                }
                case '#': {
                    if (isOracleMode || state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '\n': {
                    if (state == LexState.EOLComment) {
                        state = LexState.Normal;
                    }
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case ';': {
                    if (state == LexState.Normal) {
                        semicolon = true;
                        multipleQueriesPrepare = false;
                    }
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || !singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || isOracleMode || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    hasParam = true;
                    if (preValuePart1 == null) {
                        preValuePart1 = sb.toString();
                        sb.setLength(0);
                    }
                    if (preValuePart2 == null) {
                        preValuePart2 = sb.toString();
                        sb.setLength(0);
                    } else {
                        if (postValuePart != null) {
                            reWritablePrepare = false;
                            sb.insert(0, postValuePart);
                            postValuePart = null;
                        }
                        partList.add(sb.toString().getBytes(charset));
                        sb.setLength(0);
                    }
                    if (isInsert && !flagValue && !flagValues) {
                        reWritablePrepare = false;
                    }
                    skipChar = true;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != LexState.Normal || postValuePart != null || queryLength <= i + 7 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T' || i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1 || query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) break;
                    reWritablePrepare = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != LexState.Normal || preValuePart1 != null || lastChar != ')' && (byte)lastChar > 40 || queryLength <= i + 6 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E') break;
                    flagValues = !(query[i + 5] != 's' && query[i + 5] != 'S' || query.length <= i + 6 || query[i + 6] != '(' && (byte)query[i + 6] > 40);
                    boolean bl = flagValue = query[i + 5] == '(' || (byte)query[i + 5] <= 40;
                    if ((!isOracleMode || !flagValues) && (isOracleMode || !flagValues && !flagValue) || keyState == KeyState.Update) break;
                    sb.append(car);
                    sb.append(query[i + 1]);
                    sb.append(query[i + 2]);
                    sb.append(query[i + 3]);
                    sb.append(query[i + 4]);
                    if (flagValue && !isOracleMode) {
                        i += 4;
                    } else {
                        sb.append(query[i + 5]);
                        i += 5;
                    }
                    preValuePart1 = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    if (state != LexState.Normal || queryLength <= i + 14 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 's' && query[i + 2] != 'S' || query[i + 3] != 't' && query[i + 3] != 'T' || query[i + 4] != '_' || query[i + 5] != 'i' && query[i + 5] != 'I' || query[i + 6] != 'n' && query[i + 6] != 'N' || query[i + 7] != 's' && query[i + 7] != 'S' || query[i + 8] != 'e' && query[i + 8] != 'E' || query[i + 9] != 'r' && query[i + 9] != 'R' || query[i + 10] != 't' && query[i + 10] != 'T' || query[i + 11] != '_' || query[i + 12] != 'i' && query[i + 12] != 'I' || query[i + 13] != 'd' && query[i + 13] != 'D' || query[i + 14] != '(') break;
                    sb.append(car);
                    reWritablePrepare = false;
                    skipChar = true;
                    break;
                }
                case '(': {
                    if (state != LexState.Normal) break;
                    ++isInParenthesis;
                    break;
                }
                case ')': {
                    if (state != LexState.Normal || --isInParenthesis != 0 || preValuePart2 == null || postValuePart != null) break;
                    sb.append(car);
                    postValuePart = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                case 'O': 
                case 'o': {
                    if (state != LexState.Normal || postValuePart != null || queryLength <= i + 1 || query[i + 1] != 'n' && query[i + 1] != 'N') break;
                    onDuplicateKeyUpdateIndex = sb.toString().length();
                    sb.append(car);
                    keyState = KeyState.No;
                    skipChar = true;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state != LexState.Normal || keyState != KeyState.No || postValuePart != null || queryLength <= i + 8 || query[i + 1] != 'u' && query[i + 1] != 'U' || query[i + 2] != 'p' && query[i + 2] != 'P' || query[i + 3] != 'l' && query[i + 3] != 'L' || query[i + 4] != 'i' && query[i + 4] != 'I' || query[i + 5] != 'c' && query[i + 5] != 'C' || query[i + 6] != 'a' && query[i + 6] != 'A' || query[i + 7] != 't' && query[i + 7] != 'T' || query[i + 8] != 'e' && query[i + 8] != 'E') break;
                    sb.append(car);
                    keyState = KeyState.Duplicate;
                    skipChar = true;
                    break;
                }
                case 'K': 
                case 'k': {
                    if (state != LexState.Normal || keyState != KeyState.Duplicate || postValuePart != null || queryLength <= i + 2 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'y' && query[i + 2] != 'Y') break;
                    sb.append(car);
                    keyState = KeyState.Key;
                    skipChar = true;
                    break;
                }
                case 'U': 
                case 'u': {
                    if (state != LexState.Normal || keyState != KeyState.Key || postValuePart != null || queryLength <= i + 5 || query[i + 1] != 'p' && query[i + 1] != 'P' || query[i + 2] != 'd' && query[i + 2] != 'D' || query[i + 3] != 'a' && query[i + 3] != 'A' || query[i + 4] != 't' && query[i + 4] != 'T' || query[i + 5] != 'e' && query[i + 5] != 'E') break;
                    sb.append(car);
                    keyState = KeyState.Update;
                    skipChar = true;
                    break;
                }
                default: {
                    if (state == LexState.Normal && isFirstChar && (byte)car >= 40) {
                        if (car == 'I' || car == 'i') {
                            isInsert = true;
                        }
                        isFirstChar = false;
                    }
                    if (state != LexState.Normal || !semicolon || (byte)car < 40) break;
                    reWritablePrepare = false;
                    multipleQueriesPrepare = true;
                }
            }
            lastChar = car;
            if (skipChar) {
                skipChar = false;
                continue;
            }
            sb.append(car);
        }
        if (!hasParam) {
            if (preValuePart1 == null) {
                partList.add(0, sb.toString().getBytes(charset));
                partList.add(1, new byte[0]);
            } else {
                partList.add(0, preValuePart1.getBytes(charset));
                if (keyState == KeyState.Update && onDuplicateKeyUpdateIndex != -1) {
                    partList.add(1, sb.substring(0, onDuplicateKeyUpdateIndex).getBytes(charset));
                    partList.add(2, sb.substring(onDuplicateKeyUpdateIndex).getBytes(charset));
                } else {
                    partList.add(1, sb.toString().getBytes(charset));
                }
            }
            sb.setLength(0);
        } else {
            partList.add(0, preValuePart1 == null ? new byte[]{} : preValuePart1.getBytes(charset));
            partList.add(1, preValuePart2 == null ? new byte[]{} : preValuePart2.getBytes(charset));
        }
        if (!isInsert) {
            reWritablePrepare = false;
        }
        if (hasParam) {
            partList.add(postValuePart == null ? new byte[]{} : postValuePart.getBytes(charset));
        }
        partList.add(sb.toString().getBytes(charset));
        return new ClientPrepareResult(queryString, partList, reWritablePrepare, multipleQueriesPrepare, true, hasParam);
    }

    public static List<String> rewritablePartsInsertSql(String queryString, boolean noBackslashEscapes, boolean isOracleMode, String encoding) {
        Charset charset = StringUtils.getCharset(encoding);
        boolean reWritablePrepare = true;
        boolean multipleQueriesPrepare = true;
        ArrayList<String> stringPartList = new ArrayList<String>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        String preValuePart1 = null;
        String preValuePart2 = null;
        String postValuePart = null;
        boolean singleQuotes = false;
        int isInParenthesis = 0;
        boolean skipChar = false;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        boolean hasParam = false;
        boolean endNameBinding = false;
        boolean flagValues = false;
        boolean flagValue = false;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        KeyState keyState = KeyState.Normal;
        int onDuplicateKeyUpdateIndex = -1;
        int lastCommentEndStarPos = -2;
        int lastCommentBeginSlashPos = 0;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                sb.append(car);
                lastChar = car;
                state = LexState.String;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/' || i <= lastCommentEndStarPos + 2) break;
                    state = LexState.SlashStarComment;
                    lastCommentBeginSlashPos = i - 1;
                    break;
                }
                case '/': {
                    if (state != LexState.SlashStarComment || lastChar != '*' || i <= lastCommentBeginSlashPos + 2) break;
                    state = LexState.Normal;
                    lastCommentEndStarPos = i - 1;
                    break;
                }
                case '#': {
                    if (isOracleMode || state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '\n': {
                    if (state == LexState.EOLComment) {
                        state = LexState.Normal;
                    }
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case ';': {
                    if (state == LexState.Normal) {
                        semicolon = true;
                        multipleQueriesPrepare = false;
                    }
                    if (!isOracleMode || state != LexState.NabmeBinding) break;
                    endNameBinding = true;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || !singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || isOracleMode || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    hasParam = true;
                    if (preValuePart1 == null) {
                        preValuePart1 = sb.toString();
                        sb.setLength(0);
                    }
                    if (preValuePart2 == null) {
                        preValuePart2 = sb.toString();
                        sb.setLength(0);
                    } else {
                        if (postValuePart != null) {
                            reWritablePrepare = false;
                            sb.insert(0, postValuePart);
                            postValuePart = null;
                        }
                        stringPartList.add(sb.toString());
                        sb.setLength(0);
                    }
                    if (isInsert && !flagValue && !flagValues) {
                        reWritablePrepare = false;
                    }
                    skipChar = true;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != LexState.Normal || postValuePart != null || queryLength <= i + 7 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T' || i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1 || query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) break;
                    reWritablePrepare = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != LexState.Normal || preValuePart1 != null || lastChar != ')' && (byte)lastChar > 40 || queryLength <= i + 6 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E') break;
                    flagValues = !(query[i + 5] != 's' && query[i + 5] != 'S' || query.length <= i + 6 || query[i + 6] != '(' && (byte)query[i + 6] > 40);
                    boolean bl = flagValue = query[i + 5] == '(' || (byte)query[i + 5] <= 40;
                    if ((!isOracleMode || !flagValues) && (isOracleMode || !flagValues && !flagValue) || keyState == KeyState.Update) break;
                    sb.append(car);
                    sb.append(query[i + 1]);
                    sb.append(query[i + 2]);
                    sb.append(query[i + 3]);
                    sb.append(query[i + 4]);
                    if (flagValue && !isOracleMode) {
                        i += 4;
                    } else {
                        sb.append(query[i + 5]);
                        i += 5;
                    }
                    preValuePart1 = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    if (state != LexState.Normal || queryLength <= i + 14 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 's' && query[i + 2] != 'S' || query[i + 3] != 't' && query[i + 3] != 'T' || query[i + 4] != '_' || query[i + 5] != 'i' && query[i + 5] != 'I' || query[i + 6] != 'n' && query[i + 6] != 'N' || query[i + 7] != 's' && query[i + 7] != 'S' || query[i + 8] != 'e' && query[i + 8] != 'E' || query[i + 9] != 'r' && query[i + 9] != 'R' || query[i + 10] != 't' && query[i + 10] != 'T' || query[i + 11] != '_' || query[i + 12] != 'i' && query[i + 12] != 'I' || query[i + 13] != 'd' && query[i + 13] != 'D' || query[i + 14] != '(') break;
                    sb.append(car);
                    reWritablePrepare = false;
                    skipChar = true;
                    break;
                }
                case 'O': 
                case 'o': {
                    if (state != LexState.Normal || postValuePart != null || queryLength <= i + 1 || query[i + 1] != 'n' && query[i + 1] != 'N') break;
                    onDuplicateKeyUpdateIndex = sb.toString().length();
                    sb.append(car);
                    keyState = KeyState.No;
                    skipChar = true;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state != LexState.Normal || keyState != KeyState.No || postValuePart != null || queryLength <= i + 8 || query[i + 1] != 'u' && query[i + 1] != 'U' || query[i + 2] != 'p' && query[i + 2] != 'P' || query[i + 3] != 'l' && query[i + 3] != 'L' || query[i + 4] != 'i' && query[i + 4] != 'I' || query[i + 5] != 'c' && query[i + 5] != 'C' || query[i + 6] != 'a' && query[i + 6] != 'A' || query[i + 7] != 't' && query[i + 7] != 'T' || query[i + 8] != 'e' && query[i + 8] != 'E') break;
                    sb.append(car);
                    keyState = KeyState.Duplicate;
                    skipChar = true;
                    break;
                }
                case 'K': 
                case 'k': {
                    if (state != LexState.Normal || keyState != KeyState.Duplicate || postValuePart != null || queryLength <= i + 2 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'y' && query[i + 2] != 'Y') break;
                    sb.append(car);
                    keyState = KeyState.Key;
                    skipChar = true;
                    break;
                }
                case 'U': 
                case 'u': {
                    if (state != LexState.Normal || keyState != KeyState.Key || postValuePart != null || queryLength <= i + 5 || query[i + 1] != 'p' && query[i + 1] != 'P' || query[i + 2] != 'd' && query[i + 2] != 'D' || query[i + 3] != 'a' && query[i + 3] != 'A' || query[i + 4] != 't' && query[i + 4] != 'T' || query[i + 5] != 'e' && query[i + 5] != 'E') break;
                    sb.append(car);
                    keyState = KeyState.Update;
                    skipChar = true;
                    break;
                }
                case '(': {
                    if (state != LexState.Normal) break;
                    ++isInParenthesis;
                    break;
                }
                case ')': {
                    if (state != LexState.Normal || --isInParenthesis != 0 || preValuePart2 == null || postValuePart != null) break;
                    sb.append(car);
                    postValuePart = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                default: {
                    if (state == LexState.Normal && isFirstChar && (byte)car >= 40) {
                        if (car == 'I' || car == 'i') {
                            isInsert = true;
                        }
                        isFirstChar = false;
                    }
                    if (state != LexState.Normal || !semicolon || (byte)car < 40) break;
                    reWritablePrepare = false;
                    multipleQueriesPrepare = true;
                }
            }
            lastChar = car;
            if (skipChar) {
                skipChar = false;
                continue;
            }
            sb.append(car);
        }
        if (!hasParam) {
            if (preValuePart1 == null) {
                stringPartList.add(0, sb.toString());
                stringPartList.add(1, "?");
            } else {
                stringPartList.add(0, preValuePart1);
                if (keyState == KeyState.Update && onDuplicateKeyUpdateIndex != -1) {
                    stringPartList.add(1, sb.substring(0, onDuplicateKeyUpdateIndex));
                    stringPartList.add(2, sb.substring(onDuplicateKeyUpdateIndex));
                } else {
                    stringPartList.add(1, sb.toString());
                }
            }
            sb.setLength(0);
        } else {
            stringPartList.add(0, preValuePart1 == null ? "" : preValuePart1);
            stringPartList.add(1, preValuePart2 == null ? "" : preValuePart2);
        }
        if (!isInsert) {
            reWritablePrepare = false;
        }
        if (hasParam) {
            stringPartList.add(postValuePart == null ? "" : postValuePart.toString());
        }
        stringPartList.add(sb.toString());
        if (reWritablePrepare) {
            return stringPartList;
        }
        return null;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public List<byte[]> getQueryParts() {
        return this.queryParts;
    }

    public boolean isQueryMultiValuesRewritable() {
        return this.isQueryMultiValuesRewritable;
    }

    public boolean isQueryMultipleRewritable() {
        return this.isQueryMultipleRewritable;
    }

    public boolean isRewriteType() {
        return this.rewriteType;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    static enum KeyState {
        Normal,
        No,
        Duplicate,
        Key,
        Update;

    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick,
        NabmeBinding;

    }
}

