/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal;

import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.extend.datatype.ArrayImpl;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.NUMBER;
import com.oceanbase.jdbc.extend.datatype.StructImpl;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.util.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;

public enum ColumnType {
    OLDDECIMAL(0, 3, "Types.DECIMAL", BigDecimal.class.getName(), 3),
    TINYINT(1, -6, "Types.TINYINT", Integer.class.getName(), 3),
    SMALLINT(2, 5, "Types.SMALLINT", Integer.class.getName(), 3),
    INTEGER(3, 4, "Types.INTEGER", Integer.class.getName(), 1),
    FLOAT(4, 7, "Types.REAL", Float.class.getName(), 1),
    DOUBLE(5, 8, "Types.DOUBLE", Double.class.getName(), 1),
    NULL(6, 0, "Types.NULL", String.class.getName(), 3),
    TIMESTAMP(7, 93, "Types.TIMESTAMP", Timestamp.class.getName(), 3),
    BIGINT(8, -5, "Types.BIGINT", Long.class.getName(), 3),
    MEDIUMINT(9, 4, "Types.INTEGER", Integer.class.getName(), 3),
    DATE(10, 91, "Types.DATE", Date.class.getName(), 3),
    TIME(11, 92, "Types.TIME", Time.class.getName(), 3),
    DATETIME(12, 93, "Types.TIMESTAMP", Timestamp.class.getName(), 3),
    YEAR(13, 91, "Types.SMALLINT", Short.class.getName(), 3),
    NEWDATE(14, 91, "Types.DATE", Date.class.getName(), 3),
    VARCHAR(15, 12, "Types.VARCHAR", String.class.getName(), 3),
    BIT(16, -7, "Types.BIT", "[B", 3),
    JSON(245, 12, "Types.VARCHAR", String.class.getName(), 3),
    DECIMAL(246, 3, "Types.DECIMAL", BigDecimal.class.getName(), 3),
    OBDECIMAL(246, 3, "Types.DECIMAL", BigDecimal.class.getName(), 2),
    ENUM(247, 1, "Types.VARCHAR", String.class.getName(), 3),
    SET(248, 1, "Types.VARCHAR", String.class.getName(), 3),
    TINYBLOB(249, -3, "Types.VARBINARY", "[B", 3),
    MEDIUMBLOB(250, -3, "Types.VARBINARY", "[B", 3),
    LONGBLOB(251, -4, "Types.LONGVARBINARY", "[B", 3),
    BLOB(252, -4, "Types.LONGVARBINARY", "[B", 3),
    VARSTRING(253, 12, "Types.VARCHAR", String.class.getName(), 1),
    VARCHAR2(253, 12, "Types.VARCHAR", String.class.getName(), 2),
    STRING(254, 1, "Types.CHAR", String.class.getName(), 3),
    GEOMETRY(255, 1, "Types.VARBINARY", "[B", 3),
    TIMESTAMP_TZ(200, -101, "Types.TIMESTAMP", TIMESTAMPTZ.class.getName(), 2),
    TIMESTAMP_LTZ(201, -102, "Types.TIMESTAMP", TIMESTAMPLTZ.class.getName(), 2),
    TIMESTAMP_NANO(202, 93, "Types.TIMESTAMP", Timestamp.class.getName(), 2),
    ORA_BLOB(210, 2004, "Types.LONGVARBINARY", "com.oceanbase.jdbc.Blob", 2),
    ORA_CLOB(211, 2005, "Types.LONGVARBINARY", "com.oceanbase.jdbc.Clob", 2),
    INTERVALYM(204, 1111, "Types.OTHER", String.class.getName(), 2),
    INTERVALDS(205, 1111, "Types.OTHER", String.class.getName(), 2),
    COMPLEX(160, 1111, "Types.OTHER", ComplexData.class.getName(), 2),
    ARRAY(161, 2003, "Types.Array", ArrayImpl.class.getName(), 2),
    STRUCT(162, 2002, "Types.STRUCT", StructImpl.class.getName(), 2),
    RAW(203, -3, "Types.VARBINARY", "[B", 2),
    CURSOR(163, 1111, "Types.OTHER", "CURSORTEMP", 2),
    NUMBER(3, 4, "Types.INTEGER", NUMBER.class.getName(), 2),
    NUMBER_FLOAT(206, 12, "Types.FLOAT", String.class.getName(), 2),
    BINARY_DOUBLE(5, 8, "Types.DOUBLE", Double.class.getName(), 2),
    NCHAR(208, -15, "Types.NCHAR", String.class.getName(), 2),
    NVARCHAR2(207, 12, "Types.NVARCHAR2", String.class.getName(), 2),
    ROWID(209, -8, "Types.ROWID", String.class.getName(), 2),
    BINARY_FLOAT(4, 6, "Types.FLOAT", Float.class.getName(), 2);

    static final ColumnType[] typeMysqlMap;
    static final ColumnType[] typeOracleMap;
    static final int MYSQL_TYPE = 1;
    static final int ORACLE_TYPE = 2;
    static final int BOTH_TYPE = 3;
    private final short protocolType;
    private final int sqlType;
    private final String sqlTypeName;
    private final String className;
    private final int serverType;

    private ColumnType(int protocolType, int sqlType, String sqlTypeName, String className, int serverType) {
        this.protocolType = (short)protocolType;
        this.sqlType = sqlType;
        this.sqlTypeName = sqlTypeName;
        this.className = className;
        this.serverType = serverType;
    }

    public static int convertDbTypeToSqlType(String str) {
        switch (str.toUpperCase(Locale.ROOT)) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "MEDIUMINT": {
                return 4;
            }
            case "INT": {
                return 4;
            }
            case "INTEGER": {
                return 4;
            }
            case "LONG": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "INT24": {
                return 4;
            }
            case "REAL": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "DOUBLE": {
                return 8;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "YEAR": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "DATETIME": {
                return 93;
            }
            case "TINYBLOB": {
                return -2;
            }
            case "BLOB": {
                return -4;
            }
            case "MEDIUMBLOB": {
                return -4;
            }
            case "LONGBLOB": {
                return -4;
            }
            case "TINYTEXT": {
                return 12;
            }
            case "TEXT": {
                return -1;
            }
            case "MEDIUMTEXT": {
                return -1;
            }
            case "LONGTEXT": {
                return -1;
            }
            case "ENUM": {
                return 12;
            }
            case "SET": {
                return 12;
            }
            case "GEOMETRY": {
                return -4;
            }
            case "VARBINARY": {
                return -3;
            }
        }
        return 1111;
    }

    public static Class convertSqlTypeToClass(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: {
                return Integer.class;
            }
            case 5: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 91: {
                return Date.class;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2011: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: {
                return byte[].class;
            }
            case 0: {
                return null;
            }
            case 92: {
                return Time.class;
            }
            case 2004: {
                return Blob.class;
            }
            case 2005: {
                return Clob.class;
            }
        }
        return null;
    }

    public static ColumnType convertProtocolTypeToColumnType(int typeValue, int charsetNumber, boolean isOracleMode) {
        ColumnType columnType = isOracleMode ? typeOracleMap[typeValue] : typeMysqlMap[typeValue];
        if (columnType == null) {
            columnType = BLOB;
        }
        if (charsetNumber != 63 && typeValue >= 249 && typeValue <= 252) {
            return VARCHAR;
        }
        return columnType;
    }

    public static ColumnType convertSqlTypeToColumnType(int sqlType) {
        for (ColumnType v : ColumnType.values()) {
            if (v.sqlType != sqlType) continue;
            return v;
        }
        return BLOB;
    }

    public static String getColumnTypeName(ColumnType type, long len, boolean signed, boolean binary, boolean isOracelMode) {
        long l = len;
        switch (type) {
            case SMALLINT: 
            case MEDIUMINT: 
            case BIGINT: {
                if (!signed) {
                    return type.getTypeName() + " UNSIGNED";
                }
                return type.getTypeName();
            }
            case INTEGER: {
                if (!signed) {
                    return isOracelMode ? type.getTypeName() : "INT UNSIGNED";
                }
                return isOracelMode ? type.getTypeName() : "INT";
            }
            case BLOB: {
                if (binary) {
                    l -= 2L;
                }
                if (len < 0L) {
                    return "LONGBLOB";
                }
                if (l <= 255L) {
                    return "TINYBLOB";
                }
                if (l <= 65535L) {
                    return "BLOB";
                }
                if (l <= 0xFFFFFFL) {
                    return "MEDIUMBLOB";
                }
                return "LONGBLOB";
            }
            case VARSTRING: 
            case VARCHAR: {
                if (binary) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case STRING: {
                if (binary) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case ORA_CLOB: {
                return "CLOB";
            }
            case ORA_BLOB: {
                return "BLOB";
            }
            case TIMESTAMP_NANO: {
                return "TIMESTAMP";
            }
            case TIMESTAMP_TZ: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case TIMESTAMP_LTZ: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return !signed ? "DECIMAL UNSIGNED" : "DECIMAL";
            }
            case OBDECIMAL: {
                return !signed ? "NUMBER UNSIGNED" : "NUMBER";
            }
            case NUMBER_FLOAT: {
                return "NUMBER";
            }
            case DATETIME: {
                if (!isOracelMode) break;
                return "DATE";
            }
        }
        return type.getTypeName();
    }

    public static String getClassName(ColumnType type, int len, boolean signed, boolean binary, Options options) {
        switch (type) {
            case TINYINT: {
                if (len == 1 && options.tinyInt1isBit) {
                    return Boolean.class.getName();
                }
                return Integer.class.getName();
            }
            case INTEGER: {
                return signed ? Integer.class.getName() : Long.class.getName();
            }
            case BIGINT: {
                return signed ? Long.class.getName() : BigInteger.class.getName();
            }
            case YEAR: {
                if (options.yearIsDateType) {
                    return Date.class.getName();
                }
                return Short.class.getName();
            }
            case BIT: {
                return len == 1 ? Boolean.class.getName() : "[B";
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                return binary ? "[B" : String.class.getName();
            }
        }
        return type.getClassName();
    }

    public String getClassName() {
        return this.className;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getTypeName() {
        return this.name();
    }

    public short getType() {
        return this.protocolType;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public static boolean isNumeric(ColumnType type) {
        switch (type) {
            case SMALLINT: 
            case MEDIUMINT: 
            case BIGINT: 
            case INTEGER: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case TINYINT: 
            case BIT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    static {
        typeMysqlMap = new ColumnType[256];
        typeOracleMap = new ColumnType[256];
        for (ColumnType v : ColumnType.values()) {
            if (v.serverType == 1) {
                ColumnType.typeMysqlMap[v.protocolType] = v;
                continue;
            }
            if (v.serverType == 2) {
                ColumnType.typeOracleMap[v.protocolType] = v;
                continue;
            }
            if (v.serverType != 3) continue;
            ColumnType.typeMysqlMap[v.protocolType] = v;
            ColumnType.typeOracleMap[v.protocolType] = v;
        }
    }
}

