/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol;

import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.ObArray;
import com.oceanbase.jdbc.ObStruct;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.extend.datatype.ArrayImpl;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.RowObCursorData;
import com.oceanbase.jdbc.extend.datatype.StructImpl;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.util.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;

public class BinaryRowProtocol
extends RowProtocol {
    private final ColumnDefinition[] columnDefinition;
    private final int columnInformationLength;

    public BinaryRowProtocol(ColumnDefinition[] columnDefinition, int columnInformationLength, int maxFieldSize, Options options) {
        super(maxFieldSize, options);
        this.columnDefinition = columnDefinition;
        this.columnInformationLength = columnInformationLength;
    }

    @Override
    public void setPosition(int newIndex) {
        if ((this.buf[1 + (newIndex + 2) / 8] & 1 << (newIndex + 2) % 8) != 0) {
            this.lastValueNull = 1;
            return;
        }
        boolean readFromHead = false;
        block33: for (int i = 0; i < this.columnDefinition.length; ++i) {
            switch (this.columnDefinition[i].getColumnType()) {
                case COMPLEX: 
                case CURSOR: {
                    readFromHead = true;
                    continue block33;
                }
            }
        }
        int internalPos = 0;
        boolean doRead = true;
        if (readFromHead) {
            this.index = 0;
            internalPos = 1 + (this.columnInformationLength + 9) / 8;
        } else if (this.index != newIndex) {
            internalPos = this.pos;
            if (this.index == -1 || this.index > newIndex) {
                this.index = 0;
                internalPos = 1 + (this.columnInformationLength + 9) / 8;
            } else {
                ++this.index;
                internalPos += this.length;
            }
            doRead = true;
        } else {
            doRead = false;
        }
        if (doRead) {
            while (this.index <= newIndex) {
                if ((this.buf[1 + (this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                    if (this.index != newIndex) {
                        block3 : switch (this.columnDefinition[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                internalPos += 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: 
                            case NUMBER: {
                                internalPos += 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                internalPos += 2;
                                break;
                            }
                            case TINYINT: {
                                ++internalPos;
                                break;
                            }
                            case COMPLEX: {
                                internalPos = this.complexEndPos[this.index];
                                break;
                            }
                            case CURSOR: {
                                internalPos = this.complexEndPos[this.index];
                                break;
                            }
                            default: {
                                int type = this.buf[internalPos++] & 0xFF;
                                switch (type) {
                                    case 251: {
                                        break block3;
                                    }
                                    case 252: {
                                        internalPos += 2 + (0xFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8));
                                        break block3;
                                    }
                                    case 253: {
                                        internalPos += 3 + (0xFFFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8) + ((this.buf[internalPos + 2] & 0xFF) << 16));
                                        break block3;
                                    }
                                    case 254: {
                                        internalPos = (int)((long)internalPos + (8L + ((long)(this.buf[internalPos] & 0xFF) + ((long)(this.buf[internalPos + 1] & 0xFF) << 8) + ((long)(this.buf[internalPos + 2] & 0xFF) << 16) + ((long)(this.buf[internalPos + 3] & 0xFF) << 24) + ((long)(this.buf[internalPos + 4] & 0xFF) << 32) + ((long)(this.buf[internalPos + 5] & 0xFF) << 40) + ((long)(this.buf[internalPos + 6] & 0xFF) << 48) + ((long)(this.buf[internalPos + 7] & 0xFF) << 56))));
                                        break block3;
                                    }
                                }
                                internalPos += type;
                                break;
                            }
                        }
                    } else {
                        switch (this.columnDefinition[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.pos = internalPos;
                                this.length = 8;
                                this.lastValueNull = 0;
                                return;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: 
                            case NUMBER: {
                                this.pos = internalPos;
                                this.length = 4;
                                this.lastValueNull = 0;
                                return;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.pos = internalPos;
                                this.length = 2;
                                this.lastValueNull = 0;
                                return;
                            }
                            case TINYINT: {
                                this.pos = internalPos;
                                this.length = 1;
                                this.lastValueNull = 0;
                                return;
                            }
                            case COMPLEX: {
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case CURSOR: {
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case BINARY_FLOAT: {
                                this.pos = internalPos;
                                this.length = 4;
                                this.lastValueNull = 0;
                                return;
                            }
                            case BINARY_DOUBLE: {
                                this.pos = internalPos;
                                this.length = 8;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        int typeOrLength = this.buf[internalPos++] & 0xFF;
                        switch (typeOrLength) {
                            case 251: {
                                throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
                            }
                            case 252: {
                                this.length = 0xFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8);
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 253: {
                                this.length = 0xFFFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8) + ((this.buf[internalPos++] & 0xFF) << 16);
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 254: {
                                this.length = (int)((long)(this.buf[internalPos++] & 0xFF) + ((long)(this.buf[internalPos++] & 0xFF) << 8) + ((long)(this.buf[internalPos++] & 0xFF) << 16) + ((long)(this.buf[internalPos++] & 0xFF) << 24) + ((long)(this.buf[internalPos++] & 0xFF) << 32) + ((long)(this.buf[internalPos++] & 0xFF) << 40) + ((long)(this.buf[internalPos++] & 0xFF) << 48) + ((long)(this.buf[internalPos++] & 0xFF) << 56));
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        this.length = typeOrLength;
                        this.pos = internalPos;
                        this.lastValueNull = 0;
                        return;
                    }
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        Charset charset = Charset.forName(this.options.characterEncoding);
        if (this.lastValueWasNull()) {
            switch (columnInfo.getColumnType()) {
                case BINARY_DOUBLE: {
                    return Double.toString(0.0);
                }
                case BINARY_FLOAT: {
                    return Float.toString(0.0f);
                }
            }
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case NUMBER: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalInt(columnInfo)), columnInfo);
            }
            case TINYINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalTinyInt(columnInfo)), columnInfo);
            }
            case SMALLINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalSmallInt(columnInfo)), columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalMediumInt(columnInfo)), columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.zeroFillingIfNeeded(String.valueOf(this.getInternalBigInteger(columnInfo)), columnInfo);
                }
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalLong(columnInfo)), columnInfo);
            }
            case FLOAT: 
            case NUMBER_FLOAT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalFloat(columnInfo)), columnInfo);
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                return bigDecimal == null ? null : this.zeroFillingIfNeeded(bigDecimal.toString(), columnInfo);
            }
            case BINARY_FLOAT: {
                Float f = Float.valueOf(this.getInternalFloat(columnInfo));
                return Float.toString(f.floatValue());
            }
            case DOUBLE: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalDouble(columnInfo)), columnInfo);
            }
            case BINARY_DOUBLE: {
                Double d = this.getInternalDouble(columnInfo);
                return Double.toString(d);
            }
            case TIME: {
                return this.getInternalTimeString(columnInfo);
            }
            case DATE: {
                Date date = this.getInternalDate(columnInfo, cal, TimeZone.getDefault());
                if (date == null) {
                    return null;
                }
                return date.toString();
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    Date dateInter = this.getInternalDate(columnInfo, cal, TimeZone.getDefault());
                    return dateInter == null ? null : dateInter.toString();
                }
                return String.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case DATETIME: {
                if (this.length == 0 && !this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                    return "0000-00-00 00:00:00";
                }
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, TimeZone.getDefault());
                if (timestamp == null) {
                    return null;
                }
                if (this.getProtocol().isOracleMode()) {
                    LocalDateTime localDateTime = timestamp.toLocalDateTime();
                    String str = DataTypeUtilities.TIMESTAMPTZToString(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() == 0 ? -1 : localDateTime.getNano(), 0, null);
                    return str;
                }
                return timestamp.toString();
            }
            case INTERVALDS: {
                INTERVALDS intervalds = this.getInternalINTERVALDS(columnInfo);
                return intervalds.toString();
            }
            case INTERVALYM: {
                INTERVALYM intervalym = this.getInternalINTERVALYM(columnInfo);
                return intervalym.toString();
            }
            case NULL: {
                return null;
            }
            case VARSTRING: {
                return new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            }
            case STRING: {
                if (this.getMaxFieldSize() > 0) {
                    return new String(this.buf, this.pos, Math.min(this.getMaxFieldSize() * 3, this.length), this.getCurrentEncoding(columnInfo.getColumnType())).substring(0, Math.min(this.getMaxFieldSize(), this.length));
                }
                return new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            }
            case RAW: {
                byte[] returnBytes = new byte[this.length];
                System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
                return Utils.toHexString(returnBytes);
            }
            case ORA_CLOB: {
                if (this.options.supportLobLocator) {
                    String encoding = this.options.characterEncoding;
                    byte[] data = new byte[this.buf.length];
                    System.arraycopy(this.buf, this.pos, data, 0, this.length);
                    Clob c = new Clob(true, data, encoding, null);
                    return c.toString();
                }
                return new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            }
            case GEOMETRY: {
                return new String(this.buf, this.pos, this.length);
            }
        }
        if (this.getMaxFieldSize() > 0) {
            return new String(this.buf, this.pos, Math.min(this.getMaxFieldSize() * 3, this.length), charset).substring(0, Math.min(this.getMaxFieldSize(), this.length));
        }
        return new String(this.buf, this.pos, this.length, charset);
    }

    @Override
    public int getInternalInt(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        try {
            long value;
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    value = this.parseBit();
                    break;
                }
                case TINYINT: {
                    value = this.getInternalTinyInt(columnInfo);
                    break;
                }
                case SMALLINT: 
                case YEAR: {
                    value = this.getInternalSmallInt(columnInfo);
                    break;
                }
                case INTEGER: 
                case MEDIUMINT: 
                case NUMBER: {
                    value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                    if (columnInfo.isSigned()) {
                        return (int)value;
                    }
                    if (value >= 0L) break;
                    value &= 0xFFFFFFFFL;
                    break;
                }
                case BIGINT: {
                    value = this.getInternalLong(columnInfo);
                    break;
                }
                case FLOAT: {
                    value = (long)this.getInternalFloat(columnInfo);
                    break;
                }
                case DOUBLE: {
                    value = (long)this.getInternalDouble(columnInfo);
                    break;
                }
                case DECIMAL: 
                case OLDDECIMAL: 
                case OBDECIMAL: {
                    BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                    this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, bigDecimal, columnInfo);
                    return bigDecimal.intValue();
                }
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    value = Long.parseLong(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
                    break;
                }
                default: {
                    throw new SQLException("getInt not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
                }
            }
            this.rangeCheck((Object)Integer.class, (long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE, value, columnInfo);
            return (int)value;
        }
        catch (NumberFormatException nfe) {
            String stringVal = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            if (isIntegerRegex.matcher(stringVal).find()) {
                try {
                    return Integer.parseInt(stringVal.substring(0, stringVal.indexOf(".")));
                }
                catch (NumberFormatException bigDecimal) {
                    // empty catch block
                }
            }
            if (!this.getProtocol().isOracleMode()) {
                try {
                    double doubleVal = Double.parseDouble(stringVal);
                    if (this.options.jdbcCompliantTruncation) {
                        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, doubleVal, columnInfo);
                    }
                    return (int)doubleVal;
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + stringVal, "22003", 1264);
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + stringVal, "22003", 1264);
        }
    }

    @Override
    public long getInternalLong(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        try {
            long value;
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    return this.parseBit();
                }
                case TINYINT: {
                    value = this.getInternalTinyInt(columnInfo);
                    break;
                }
                case SMALLINT: 
                case YEAR: {
                    value = this.getInternalSmallInt(columnInfo);
                    break;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    value = this.getInternalMediumInt(columnInfo);
                    break;
                }
                case BIGINT: {
                    long value2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                    if (columnInfo.isSigned()) {
                        return value2;
                    }
                    BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                    if (unsignedValue.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + unsignedValue + " is not in Long range", "22003", 1264);
                    }
                    return unsignedValue.longValue();
                }
                case FLOAT: 
                case BINARY_FLOAT: 
                case NUMBER_FLOAT: {
                    Float floatValue = Float.valueOf(this.getInternalFloat(columnInfo));
                    if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + floatValue + " is not in Long range", "22003", 1264);
                    }
                    return floatValue.longValue();
                }
                case DOUBLE: {
                    Double doubleValue = this.getInternalDouble(columnInfo);
                    if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + doubleValue + " is not in Long range", "22003", 1264);
                    }
                    return doubleValue.longValue();
                }
                case DECIMAL: 
                case OLDDECIMAL: {
                    BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                    this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, bigDecimal, columnInfo);
                    return bigDecimal.longValue();
                }
                case OBDECIMAL: 
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    return Long.parseLong(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
                }
                default: {
                    throw new SQLException("getLong not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
                }
            }
            this.rangeCheck((Object)Long.class, Long.MIN_VALUE, Long.MAX_VALUE, value, columnInfo);
            return value;
        }
        catch (NumberFormatException nfe) {
            String stringVal = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            if (isIntegerRegex.matcher(stringVal).find()) {
                try {
                    return Long.parseLong(stringVal.substring(0, stringVal.indexOf(".")));
                }
                catch (NumberFormatException doubleValue) {
                    // empty catch block
                }
            }
            if (!this.getProtocol().isOracleMode()) {
                try {
                    double doubleVal = Double.parseDouble(stringVal);
                    if (this.options.jdbcCompliantTruncation) {
                        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, doubleVal, columnInfo);
                    }
                    return (long)doubleVal;
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + stringVal, "22003", 1264);
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + stringVal, "22003", 1264);
        }
    }

    @Override
    public float getInternalFloat(ColumnDefinition columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                return unsignedValue.floatValue();
            }
            case FLOAT: {
                int valueFloat = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return Float.intBitsToFloat(valueFloat);
            }
            case BINARY_FLOAT: {
                int asInt = this.buf[this.pos + 0] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8 | (this.buf[this.pos + 2] & 0xFF) << 16 | (this.buf[this.pos + 3] & 0xFF) << 24;
                return Float.intBitsToFloat(asInt);
            }
            case NUMBER_FLOAT: {
                String str = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                Float f = Float.valueOf(str);
                return f.floatValue();
            }
            case DOUBLE: {
                return (float)this.getInternalDouble(columnInfo);
            }
            case DECIMAL: 
            case VARSTRING: 
            case STRING: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR2: {
                try {
                    return Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()))).floatValue();
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getSqlTypeName(), "22003", 1264, nfe);
                    throw sqlException;
                }
            }
            case OBDECIMAL: {
                String val = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                BigDecimal bigDecimal = new BigDecimal(val);
                return bigDecimal.floatValue();
            }
            default: {
                throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
            }
        }
        try {
            return Float.valueOf(String.valueOf(value)).floatValue();
        }
        catch (NumberFormatException nfe) {
            SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getSqlTypeName(), "22003", 1264, nfe);
            throw sqlException;
        }
    }

    @Override
    public double getInternalDouble(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                return this.getInternalTinyInt(columnInfo);
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt(columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt(columnInfo);
            }
            case BIGINT: {
                long valueLong = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return valueLong;
                }
                return new BigInteger(1, new byte[]{(byte)(valueLong >> 56), (byte)(valueLong >> 48), (byte)(valueLong >> 40), (byte)(valueLong >> 32), (byte)(valueLong >> 24), (byte)(valueLong >> 16), (byte)(valueLong >> 8), (byte)valueLong}).doubleValue();
            }
            case FLOAT: {
                return this.getInternalFloat(columnInfo);
            }
            case DOUBLE: {
                long valueDouble = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                return Double.longBitsToDouble(valueDouble);
            }
            case DECIMAL: 
            case VARSTRING: 
            case STRING: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR2: {
                try {
                    return Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getDouble for data field with type " + columnInfo.getColumnType().getSqlTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
            case BINARY_DOUBLE: {
                long valueAsLong = (long)(this.buf[this.pos + 0] & 0xFF) | (long)(this.buf[this.pos + 1] & 0xFF) << 8 | (long)(this.buf[this.pos + 2] & 0xFF) << 16 | (long)(this.buf[this.pos + 3] & 0xFF) << 24 | (long)(this.buf[this.pos + 4] & 0xFF) << 32 | (long)(this.buf[this.pos + 5] & 0xFF) << 40 | (long)(this.buf[this.pos + 6] & 0xFF) << 48 | (long)(this.buf[this.pos + 7] & 0xFF) << 56;
                return Double.longBitsToDouble(valueAsLong);
            }
            case BINARY_FLOAT: {
                return this.getInternalFloat(columnInfo);
            }
            case OBDECIMAL: {
                String val = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                BigDecimal bigDecimal = new BigDecimal(val);
                return bigDecimal.doubleValue();
            }
            case NUMBER_FLOAT: {
                Float f = Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                return f.floatValue();
            }
        }
        throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigDecimal.valueOf(this.parseBit());
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getInternalTinyInt(columnInfo));
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getInternalMediumInt(columnInfo));
            }
            case BIGINT: {
                long value = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value}))).setScale(columnInfo.getDecimals());
            }
            case FLOAT: 
            case BINARY_FLOAT: {
                return BigDecimal.valueOf(this.getInternalFloat(columnInfo));
            }
            case DOUBLE: 
            case BINARY_DOUBLE: {
                if (!this.getProtocol().isOracleMode()) {
                    return BigDecimal.valueOf(this.getInternalDouble(columnInfo)).setScale(columnInfo.getDecimals());
                }
                return BigDecimal.valueOf(this.getInternalDouble(columnInfo));
            }
            case NUMBER_FLOAT: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: 
            case VARSTRING: 
            case STRING: 
            case VARCHAR: 
            case VARCHAR2: 
            case NVARCHAR2: {
                String strValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim();
                try {
                    BigDecimal retVal = new BigDecimal(strValue);
                    return retVal;
                }
                catch (Exception e) {
                    throw new SQLException("Bad format for BigDecimal '" + strValue + "'");
                }
            }
        }
        throw new SQLException("getBigDecimal not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getInternalDate(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        try {
            if (this.lastValueWasNull()) {
                return null;
            }
            switch (columnInfo.getColumnType()) {
                case TIMESTAMP: 
                case TIMESTAMP_NANO: 
                case DATETIME: 
                case TIMESTAMP_TZ: 
                case TIMESTAMP_LTZ: {
                    Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
                    if (timestamp == null) {
                        return null;
                    }
                    Date date = new Date(timestamp.getTime());
                    return date;
                }
                case TIME: {
                    Calendar dateCal;
                    if (this.length == 0) throw new SQLException("Cannot read Date using a Types.TIME field");
                    int year = 0;
                    int month = 0;
                    int day = 0;
                    byte hour = 0;
                    byte minute = 0;
                    byte seconds = 0;
                    if (this.length != 0) {
                        hour = this.buf[this.pos + 5];
                        minute = this.buf[this.pos + 6];
                        seconds = this.buf[this.pos + 7];
                    }
                    year = 1970;
                    month = 1;
                    day = 1;
                    Calendar calendar = dateCal = this.getCalendarInstance(cal);
                    synchronized (calendar) {
                        java.util.Date origCalDate = dateCal.getTime();
                        try {
                            dateCal.clear();
                            dateCal.set(14, 0);
                            dateCal.set(year, month - 1, day, 0, 0, 0);
                            long dateAsMillis = dateCal.getTimeInMillis();
                            Date date = new Date(dateAsMillis);
                            return date;
                        }
                        finally {
                            dateCal.setTime(origCalDate);
                        }
                    }
                }
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    if (!this.getProtocol().isOracleMode()) {
                        return this.getDateFromString(rawValue, cal, columnInfo);
                    }
                    if ("0000-00-00".equals(rawValue)) {
                        this.lastValueNull |= 2;
                        return null;
                    }
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        sdf.setTimeZone(timeZone);
                        java.util.Date utilDate = sdf.parse(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                        return new Date(utilDate.getTime());
                    }
                    catch (ParseException e) {
                        throw ExceptionFactory.INSTANCE.create("Could not get object as Date : " + e.getMessage(), "S1009", e);
                    }
                }
            }
            if (this.length == 0) {
                this.lastValueNull |= 1;
                return null;
            }
            int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
            if (this.length == 2 && columnInfo.getLength() == 2L) {
                year = year <= 69 ? (year += 2000) : (year += 1900);
            }
            byte month = 1;
            byte day = 1;
            if (this.length >= 4) {
                month = this.buf[this.pos + 2];
                day = this.buf[this.pos + 3];
            }
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Date(calendar.getTimeInMillis());
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException("Bad format for DATE " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getInternalTime(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case DATETIME: 
            case TIMESTAMP_TZ: 
            case TIMESTAMP_LTZ: {
                Timestamp ts = this.getInternalTimestamp(columnInfo, cal, timeZone);
                return ts == null ? null : new Time(ts.getTime());
            }
            case DATE: {
                if (this.length != 0) {
                    Calendar calendar;
                    int year = 0;
                    byte month = 0;
                    byte day = 0;
                    int hour = 0;
                    int minute = 0;
                    int seconds = 0;
                    year = this.buf[this.pos + 0] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    month = this.buf[this.pos + 2];
                    day = this.buf[this.pos + 3];
                    Calendar calendar2 = calendar = this.getCalendarInstance(cal);
                    synchronized (calendar2) {
                        Time time;
                        java.util.Date origCalDate = calendar.getTime();
                        try {
                            calendar.clear();
                            calendar.set(1970, 0, 1, hour, minute, seconds);
                            long timeAsMillis = calendar.getTimeInMillis();
                            time = new Time(timeAsMillis);
                            calendar.setTime(origCalDate);
                        }
                        catch (Throwable throwable) {
                            calendar.setTime(origCalDate);
                            throw throwable;
                        }
                        return time;
                    }
                }
                throw new SQLException("Cannot read Time using a Types.DATE field");
            }
        }
        ColumnType type = columnInfo.getColumnType();
        if (!(this.getProtocol().isOracleMode() || type != ColumnType.STRING && type != ColumnType.VARCHAR && type != ColumnType.VARSTRING)) {
            String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            return this.getTimeFromString(raw, cal);
        }
        Calendar calendar = this.getCalendarInstance(cal);
        calendar.clear();
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        int seconds = 0;
        boolean negate = false;
        if (this.length > 0) {
            boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
        }
        if (this.length > 4) {
            day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
        }
        if (this.length > 7) {
            hour = this.buf[this.pos + 5];
            minutes = this.buf[this.pos + 6];
            seconds = this.buf[this.pos + 7];
        }
        calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
        int nanoseconds = 0;
        if (this.length > 8) {
            nanoseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getInternalTimestamp(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        try {
            Timestamp tt;
            Calendar calendar;
            if (this.lastValueWasNull()) {
                return null;
            }
            if (this.getProtocol().isOracleMode()) {
                Calendar cal = this.getCalendarInstanceWithTimezone(userCalendar, timeZone);
                TIMESTAMP timestamp = null;
                switch (columnInfo.getColumnType()) {
                    case TIMESTAMP_TZ: {
                        TIMESTAMPTZ oracleTimestampZ = this.getInternalTIMESTAMPTZ(columnInfo, userCalendar, timeZone);
                        timestamp = TIMESTAMPTZ.resultTIMESTAMP(this.getProtocol(), oracleTimestampZ.toBytes());
                        return timestamp.timestampValue(cal);
                    }
                    case TIMESTAMP_LTZ: {
                        TIMESTAMPLTZ oracleTimestampLTZ = this.getInternalTIMESTAMPLTZ(columnInfo, userCalendar, timeZone);
                        timestamp = TIMESTAMPLTZ.resultTIMESTAMP(this.getProtocol(), oracleTimestampLTZ.getBytes());
                        return timestamp.timestampValue(cal);
                    }
                    case TIMESTAMP_NANO: {
                        Calendar calWithoutTZ = this.getCalendarInstance(userCalendar);
                        return this.getInternalTIMESTAMP(columnInfo, userCalendar, TimeZone.getDefault()).timestampValue(calWithoutTZ);
                    }
                }
            }
            int year = 1970;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int microseconds = 0;
            int nanos = 0;
            switch (columnInfo.getColumnType()) {
                case TIME: {
                    boolean negate = false;
                    if (this.length > 0) {
                        boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
                    }
                    if (this.length > 4) {
                        day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                    }
                    if (this.length > 7) {
                        hour = this.buf[this.pos + 5];
                        minutes = this.buf[this.pos + 6];
                        seconds = this.buf[this.pos + 7];
                    }
                    if (this.length > 8) {
                        microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                        nanos = microseconds * 1000000;
                    }
                    year = 1970;
                    month = 1;
                    day = (negate ? -1 : 1) * day + 1;
                    hour = (negate ? -1 : 1) * hour;
                    break;
                }
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    if (!this.getProtocol().isOracleMode()) {
                        return this.getTimestampFromString(columnInfo, rawValue, userCalendar, timeZone);
                    }
                    if (rawValue.startsWith("0000-00-00 00:00:00")) {
                        this.lastValueNull |= 2;
                        return null;
                    }
                    if (rawValue.length() < 4) break;
                    year = Integer.parseInt(rawValue.substring(0, 4));
                    if (rawValue.length() < 7) break;
                    month = Integer.parseInt(rawValue.substring(5, 7));
                    if (rawValue.length() < 10) break;
                    day = Integer.parseInt(rawValue.substring(8, 10));
                    if (rawValue.length() >= 19) {
                        hour = Integer.parseInt(rawValue.substring(11, 13));
                        minutes = Integer.parseInt(rawValue.substring(14, 16));
                        seconds = Integer.parseInt(rawValue.substring(17, 19));
                    }
                    nanos = this.extractNanos(rawValue);
                    break;
                }
                default: {
                    if (this.length <= 0) break;
                    year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    month = this.buf[this.pos + 2];
                    day = this.buf[this.pos + 3];
                    if (this.length <= 4) break;
                    hour = this.buf[this.pos + 4];
                    minutes = this.buf[this.pos + 5];
                    seconds = this.buf[this.pos + 6];
                    if (this.length <= 7) break;
                    microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    nanos = microseconds * 1000;
                }
            }
            if (this.length == 0 || year == 0 && month == 0 && day == 0) {
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
                    throw new SQLException("Value '0000-00-00' can not be represented as java.sql.Timestamp");
                }
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("convertToNull")) {
                    return null;
                }
                year = 1;
                month = 1;
                day = 1;
            }
            Calendar calendar2 = calendar = this.getCalendarInstance(userCalendar);
            synchronized (calendar2) {
                calendar.clear();
                calendar.set(year, month - 1, day, hour, minutes, seconds);
                tt = new Timestamp(calendar.getTimeInMillis());
            }
            tt.setNanos(nanos);
            return tt;
        }
        catch (NumberFormatException e) {
            SQLException sqlException = new SQLException("Cannot convert value " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + " to TIMESTAMP.");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    public Object getInternalObject(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                byte[] dataBit = new byte[this.length];
                System.arraycopy(this.buf, this.pos, dataBit, 0, this.length);
                return dataBit;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                return this.getInternalInt(columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalLong(columnInfo);
                }
                return this.getInternalInt(columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalBigInteger(columnInfo);
                }
                return this.getInternalLong(columnInfo);
            }
            case DOUBLE: 
            case BINARY_DOUBLE: {
                return this.getInternalDouble(columnInfo);
            }
            case VARSTRING: 
            case STRING: 
            case VARCHAR: 
            case VARCHAR2: 
            case ENUM: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case DATETIME: {
                return this.getInternalTimestamp(columnInfo, null, timeZone);
            }
            case DATE: {
                return this.getInternalDate(columnInfo, null, timeZone);
            }
            case NUMBER_FLOAT: 
            case DECIMAL: 
            case OBDECIMAL: {
                return this.getInternalBigDecimal(columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                byte[] dataBlob = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, dataBlob, 0, this.getLengthMaxFieldSize());
                return dataBlob;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return this.getInternalDate(columnInfo, null, timeZone);
                }
                return this.getInternalShort(columnInfo);
            }
            case MEDIUMINT: 
            case NUMBER: 
            case SMALLINT: {
                return this.getInternalInt(columnInfo);
            }
            case FLOAT: 
            case BINARY_FLOAT: {
                return Float.valueOf(this.getInternalFloat(columnInfo));
            }
            case TIME: {
                return this.getInternalTime(columnInfo, null, timeZone);
            }
            case OLDDECIMAL: 
            case JSON: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case GEOMETRY: {
                byte[] data = new byte[this.length];
                System.arraycopy(this.buf, this.pos, data, 0, this.length);
                return data;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
            case TIMESTAMP_TZ: {
                return this.getInternalTIMESTAMPTZ(columnInfo, null, timeZone);
            }
            case TIMESTAMP_LTZ: {
                return this.getInternalTIMESTAMPLTZ(columnInfo, null, timeZone);
            }
            case INTERVALYM: {
                return this.getInternalINTERVALYM(columnInfo);
            }
            case INTERVALDS: {
                return this.getInternalINTERVALDS(columnInfo);
            }
            case STRUCT: {
                byte[] structData = new byte[this.length];
                System.arraycopy(this.buf, this.pos, structData, 0, this.length);
                return structData;
            }
            case ARRAY: {
                byte[] arrayData = new byte[this.length];
                System.arraycopy(this.buf, this.pos, arrayData, 0, this.length);
                return arrayData;
            }
            case CURSOR: {
                return null;
            }
            case RAW: {
                byte[] returnBytes = new byte[this.length];
                System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
                return returnBytes;
            }
            case NVARCHAR2: 
            case NCHAR: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
        }
        throw ExceptionFactory.INSTANCE.notSupported(String.format("Type '%s' is not supported", columnInfo.getColumnType().getTypeName()));
    }

    @Override
    public boolean getInternalBoolean(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return false;
        }
        if (columnInfo.getColumnType() == ColumnType.BIT) {
            return this.parseBit() != 0L;
        }
        long boolVal = 0L;
        switch (columnInfo.getColumnType()) {
            case BIGINT: 
            case DOUBLE: 
            case INTEGER: 
            case MEDIUMINT: 
            case FLOAT: 
            case SMALLINT: 
            case YEAR: 
            case TINYINT: 
            case DECIMAL: 
            case OLDDECIMAL: {
                boolVal = this.getInternalLong(columnInfo);
                return boolVal > 0L || boolVal == -1L;
            }
        }
        if (columnInfo.isBinary()) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, bytes, 0, this.length);
            return Utils.convertBytesToBoolean(bytes);
        }
        String rawVal = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        return Utils.convertStringToBoolean(rawVal);
    }

    @Override
    public byte getInternalByte(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        try {
            long value;
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    value = this.parseBit();
                    break;
                }
                case TINYINT: {
                    value = this.getInternalTinyInt(columnInfo);
                    break;
                }
                case SMALLINT: 
                case YEAR: {
                    value = this.getInternalSmallInt(columnInfo);
                    break;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    value = this.getInternalMediumInt(columnInfo);
                    break;
                }
                case BIGINT: {
                    value = this.getInternalLong(columnInfo);
                    break;
                }
                case FLOAT: {
                    value = (long)this.getInternalFloat(columnInfo);
                    break;
                }
                case DOUBLE: {
                    value = (long)this.getInternalDouble(columnInfo);
                    break;
                }
                case DECIMAL: 
                case OLDDECIMAL: {
                    BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                    this.rangeCheck(Byte.class, -128L, 127L, bigDecimal, columnInfo);
                    return bigDecimal.byteValue();
                }
                case OBDECIMAL: 
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    value = Long.parseLong(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
                    break;
                }
                default: {
                    throw new SQLException("getByte not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
                }
            }
            this.rangeCheck((Object)Byte.class, -128L, 127L, value, columnInfo);
            return (byte)value;
        }
        catch (NumberFormatException nfe) {
            String valueParams = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            if (isIntegerRegex.matcher(valueParams).find()) {
                try {
                    long value = Long.parseLong(valueParams.substring(0, valueParams.indexOf(".")).trim());
                    this.rangeCheck((Object)Byte.class, -128L, 127L, value, columnInfo);
                    return (byte)value;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + valueParams, "22003", 1264);
        }
    }

    @Override
    public short getInternalShort(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        try {
            long value;
            switch (columnInfo.getColumnType()) {
                case BIT: {
                    value = this.parseBit();
                    break;
                }
                case TINYINT: {
                    value = this.getInternalTinyInt(columnInfo);
                    break;
                }
                case SMALLINT: 
                case YEAR: {
                    value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
                    if (columnInfo.isSigned()) {
                        return (short)value;
                    }
                    value &= 0xFFFFL;
                    break;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    value = this.getInternalMediumInt(columnInfo);
                    break;
                }
                case BIGINT: {
                    value = this.getInternalLong(columnInfo);
                    break;
                }
                case FLOAT: {
                    value = (long)this.getInternalFloat(columnInfo);
                    break;
                }
                case DOUBLE: {
                    value = (long)this.getInternalDouble(columnInfo);
                    break;
                }
                case DECIMAL: 
                case OLDDECIMAL: {
                    BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                    this.rangeCheck(Short.class, -32768L, 32767L, bigDecimal, columnInfo);
                    return bigDecimal.shortValue();
                }
                case OBDECIMAL: 
                case VARSTRING: 
                case STRING: 
                case VARCHAR: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    value = Long.parseLong(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
                    break;
                }
                default: {
                    throw new SQLException("getShort not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
                }
            }
            this.rangeCheck((Object)Short.class, -32768L, 32767L, value, columnInfo);
            return (short)value;
        }
        catch (NumberFormatException nfe) {
            String valueParams = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            if (isIntegerRegex.matcher(valueParams).find()) {
                try {
                    long value = Long.parseLong(valueParams.substring(0, valueParams.indexOf(".")).trim());
                    this.rangeCheck((Object)Short.class, -32768L, 32767L, value, columnInfo);
                    return (short)value;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + valueParams, "22003", 1264);
        }
    }

    @Override
    public String getInternalTimeString(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            if (columnInfo.getDecimals() == 0) {
                return "00:00:00";
            }
            StringBuilder value = new StringBuilder("00:00:00.");
            int decimal = columnInfo.getDecimals();
            while (decimal-- > 0) {
                value.append("0");
            }
            return value.toString();
        }
        String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        byte hour = this.buf[this.pos + 5];
        int day = this.buf[this.pos + 1] & 0xFF | (this.buf[this.pos + 2] & 0xFF) << 8 | (this.buf[this.pos + 3] & 0xFF) << 16 | (this.buf[this.pos + 4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = this.buf[this.pos + 6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = this.buf[this.pos + 7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (this.length > 8) {
            microseconds = this.buf[this.pos + 8] & 0xFF | (this.buf[this.pos + 9] & 0xFF) << 8 | (this.buf[this.pos + 10] & 0xFF) << 16 | (this.buf[this.pos + 11] & 0xFF) << 24;
        }
        StringBuilder microsecondString = new StringBuilder(Integer.toString(microseconds));
        while (microsecondString.length() < 6) {
            microsecondString.insert(0, "0");
        }
        boolean negative = this.buf[this.pos] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString + (microsecondString.toString().matches("[0]+") && !this.getProtocol().isOracleMode() ? "" : "." + microsecondString);
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigInteger.valueOf(this.buf[this.pos]);
            }
            case TINYINT: {
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)this.buf[this.pos] : (long)(this.buf[this.pos] & 0xFF));
            }
            case SMALLINT: 
            case YEAR: {
                short valueShort = (short)(this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8);
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)valueShort : (long)(valueShort & 0xFFFF));
            }
            case INTEGER: 
            case MEDIUMINT: {
                int valueInt = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)valueInt : (valueInt >= 0 ? (long)valueInt : (long)valueInt & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long value = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getInternalFloat(columnInfo));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getInternalDouble(columnInfo));
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                return BigInteger.valueOf(this.getInternalBigDecimal(columnInfo).longValue());
            }
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
    }

    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnDefinition columnInfo, Class clazz, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (this.getProtocol().isOracleMode() && (columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO || columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ || columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ)) {
            Timestamp oracleTimestamp = this.getInternalTimestamp(columnInfo, null, timeZone);
            if (oracleTimestamp == null) {
                return null;
            }
            LocalDateTime localDateTimeNoTimeZone = oracleTimestamp.toLocalDateTime();
            return localDateTimeNoTimeZone.atZone(timeZone.toZoneId());
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 91: 
            case 93: {
                int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte month = this.buf[this.pos + 2];
                byte day = this.buf[this.pos + 3];
                byte hour = 0;
                int minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                if (this.length > 4) {
                    hour = this.buf[this.pos + 4];
                    minutes = this.buf[this.pos + 5];
                    seconds = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, timeZone.toZoneId());
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(raw, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = timeZone.toZoneId().normalized();
        if (zoneId instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)zoneId;
            int day = 0;
            byte hour = 0;
            byte minutes = 0;
            int seconds = 0;
            int microseconds = 0;
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    byte month = this.buf[this.pos + 2];
                    day = this.buf[this.pos + 3];
                    if (this.length > 4) {
                        hour = this.buf[this.pos + 4];
                        minutes = this.buf[this.pos + 5];
                        seconds = this.buf[this.pos + 6];
                        if (this.length > 7) {
                            microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                        }
                    }
                    return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, zoneOffset).toOffsetDateTime().toOffsetTime();
                }
                case 92: {
                    boolean negate;
                    boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
                    if (this.length > 4) {
                        day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                    }
                    if (this.length > 7) {
                        hour = this.buf[this.pos + 5];
                        minutes = this.buf[this.pos + 6];
                        seconds = this.buf[this.pos + 7];
                    }
                    if (this.length > 8) {
                        microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                    }
                    return OffsetTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000, zoneOffset);
                }
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
        }
        if (!this.getProtocol().isOracleMode()) {
            switch (columnInfo.getColumnType().getSqlType()) {
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public OffsetDateTime getInternalOffsetDateTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = timeZone.toZoneId().normalized();
        if (zoneId instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)zoneId;
            byte day = 0;
            byte hour = 0;
            int minutes = 0;
            int seconds = 0;
            int microseconds = 0;
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    byte month = this.buf[this.pos + 2];
                    day = this.buf[this.pos + 3];
                    if (this.length > 4) {
                        hour = this.buf[this.pos + 4];
                        minutes = this.buf[this.pos + 5];
                        seconds = this.buf[this.pos + 6];
                        if (this.length > 7) {
                            microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                        }
                    }
                    return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, zoneOffset).toOffsetDateTime();
                }
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    try {
                        return OffsetDateTime.parse(raw.replace(" ", "T"));
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
        }
        if (!this.getProtocol().isOracleMode()) {
            switch (columnInfo.getColumnType().getSqlType()) {
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    try {
                        return OffsetDateTime.parse(raw.replace(" ", "T"));
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 92: {
                boolean negate;
                int day = 0;
                byte hour = 0;
                byte minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
                if (this.length > 4) {
                    day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                }
                if (this.length > 7) {
                    hour = this.buf[this.pos + 5];
                    minutes = this.buf[this.pos + 6];
                    seconds = this.buf[this.pos + 7];
                }
                if (this.length > 8) {
                    microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                }
                return LocalTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000);
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                try {
                    return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalTime.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 91: {
                int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte month = this.buf[this.pos + 2];
                byte day = this.buf[this.pos + 3];
                return LocalDate.of(year, month, (int)day);
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalDate.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                if (raw.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDate. time must have \"yyyy-MM-dd\" format");
                }
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    private ComplexData getComplexField(Buffer packet, ComplexDataType type, Connection connection) throws SQLException {
        ComplexData value = null;
        if (null == type || !type.isValid()) {
            throw new SQLException(String.format("invalid complex type, check if exists, typeName=%s", type.getTypeName()));
        }
        switch (type.getType()) {
            case 4: {
                value = this.getComplexArray(packet, type, connection);
                break;
            }
            case 3: {
                value = this.getComplexStruct(packet, type, connection);
                break;
            }
            default: {
                throw new SQLException(String.format("invalid complex type, check if exists, typeName=%s", type.getTypeName()));
            }
        }
        return value;
    }

    private ComplexData getComplexArray(Buffer packet, ComplexDataType type, Connection connection) throws SQLException {
        ArrayImpl array = new ArrayImpl(type);
        int attrCount = (int)packet.readFieldLength();
        array.setAttrCount(attrCount);
        int curPos = packet.getPosition();
        byte[] nullBitsBuffer = packet.getBytes(curPos, (attrCount + 7 + 2) / 8);
        packet.setPosition(curPos + (attrCount + 7 + 2) / 8);
        for (int i = 0; i < attrCount; ++i) {
            if ((nullBitsBuffer[(i + 2) / 8] & 1 << (i + 2) % 8) == 0) {
                Object value = this.getComplexAttrData(packet, type.getAttrType(0), connection);
                array.addAttrData(i, value);
                continue;
            }
            array.addAttrData(i, null);
        }
        return array;
    }

    public ComplexData getComplexStruct(Buffer packet, ComplexDataType type, Connection connection) throws SQLException {
        StructImpl struct = new StructImpl(type);
        int attrCount = type.getAttrCount();
        struct.setAttrCount(attrCount);
        int curPos = packet.getPosition();
        byte[] nullBitsBuffer = packet.getBytes(curPos, (attrCount + 7 + 2) / 8);
        packet.setPosition(curPos + (attrCount + 7 + 2) / 8);
        for (int i = 0; i < attrCount; ++i) {
            if ((nullBitsBuffer[(i + 2) / 8] & 1 << (i + 2) % 8) == 0) {
                Object value = this.getComplexAttrData(packet, type.getAttrType(i), connection);
                struct.addAttrData(i, value);
                continue;
            }
            struct.addAttrData(i, null);
        }
        return struct;
    }

    private Timestamp getComplexDate(byte[] bits) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int seconds = 0;
        int nanos = 0;
        if (null == bits) {
            return null;
        }
        int length = bits.length;
        if (length != 0) {
            year = bits[0] & 0xFF | (bits[1] & 0xFF) << 8;
            month = bits[2];
            day = bits[3];
            if (length > 4) {
                hour = bits[4];
                minute = bits[5];
                seconds = bits[6];
            }
            if (length > 7) {
                nanos = (bits[7] & 0xFF | (bits[8] & 0xFF) << 8 | (bits[9] & 0xFF) << 16 | (bits[10] & 0xFF) << 24) * 1000;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, seconds);
        long tsAsMillis = cal.getTimeInMillis();
        Timestamp ts = new Timestamp(tsAsMillis);
        ts.setNanos(nanos);
        return ts;
    }

    private Timestamp getComplexTimestamp(byte[] bits) throws SQLException {
        TIMESTAMP timestamp = this.buildTIMETAMP(bits, 0, bits.length);
        return timestamp.timestampValue();
    }

    private Object getComplexAttrData(Buffer packet, ComplexDataType type, Connection connection) throws SQLException {
        Object value = null;
        byte[] b = null;
        Charset charset = Charset.forName(this.getProtocol().getEncoding());
        switch (type.getType()) {
            case 0: {
                b = packet.readLenByteArray(0);
                value = new BigDecimal(new String(b, 0, b.length, StandardCharsets.UTF_8).trim());
                break;
            }
            case 1: {
                b = packet.readLenByteArray(0);
                value = new String(b, 0, b.length, charset);
                break;
            }
            case 6: {
                value = b = packet.readLenByteArray(0);
                break;
            }
            case 2: {
                value = this.getComplexDate(packet.readLenByteArray(0));
                break;
            }
            case 8: {
                value = this.getComplexTimestamp(packet.readLenByteArray(0));
                break;
            }
            case 4: {
                value = this.getComplexArray(packet, type, connection);
                break;
            }
            case 3: {
                value = this.getComplexStruct(packet, type, connection);
                break;
            }
            case 7: {
                b = packet.readLenByteArray(0);
                value = Character.valueOf((char)b[0]);
                break;
            }
            case 9: {
                b = packet.readLenByteArray(0);
                if (this.options.supportLobLocator) {
                    Clob c = new Clob(true, b, charset.name(), (OceanBaseConnection)connection);
                    value = c.toString();
                    c.free();
                    break;
                }
                return new String(this.buf, this.pos, this.length, charset);
            }
            case 10: {
                b = packet.readLenByteArray(0);
                if (this.options.supportLobLocator) {
                    Blob blob = new Blob(true, b, charset.name(), (OceanBaseConnection)connection);
                    value = blob.getBytes(1L, (int)blob.length());
                    blob.free();
                    break;
                }
                value = b;
                break;
            }
            default: {
                throw new SQLException("unsupported complex data type");
            }
        }
        return value;
    }

    @Override
    public Array getInternalArray(ColumnDefinition columnInf, ComplexDataType complexDataType, Connection connection) throws SQLException {
        ObArray ret = null;
        Buffer buffer = new Buffer(this.buf);
        buffer.setPosition(this.pos);
        ret = (ObArray)((Object)this.getComplexField(buffer, complexDataType, connection));
        this.pos = buffer.getPosition();
        return ret;
    }

    @Override
    public Struct getInternalStruct(ColumnDefinition columnInfo, ComplexDataType complexDataType, Connection connection) throws SQLException {
        ObStruct struct = null;
        Buffer buffer = new Buffer(this.buf);
        buffer.setPosition(this.pos);
        struct = (ObStruct)((Object)this.getComplexField(buffer, complexDataType, connection));
        this.pos = buffer.getPosition();
        return struct;
    }

    @Override
    public ComplexData getInternalComplexCursor(ColumnDefinition columnInfo, ComplexDataType complexDataType, Connection connection) throws SQLException {
        ComplexData value = new ComplexData(complexDataType);
        if (this.buf.length <= this.pos) {
            throw new SQLException("cursor is not open");
        }
        Buffer buffer = new Buffer(this.buf);
        buffer.setPosition(this.pos);
        int id = (int)buffer.readLong4BytesV1();
        value.setAttrCount(1);
        RowObCursorData rowObCursorData = new RowObCursorData(id, true);
        value.addAttrData(0, rowObCursorData);
        this.pos = buffer.getPosition();
        return value;
    }

    @Override
    public INTERVALDS getInternalINTERVALDS(ColumnDefinition columnInfo) throws SQLException {
        if (columnInfo.getColumnType() != ColumnType.INTERVALDS) {
            throw new SQLException("the field type is not FIELD_TYPE_INTERVALDS");
        }
        byte[] target = new byte[this.length];
        System.arraycopy(this.buf, this.pos, target, 0, this.length);
        return new INTERVALDS(target);
    }

    @Override
    public INTERVALYM getInternalINTERVALYM(ColumnDefinition columnInfo) throws SQLException {
        if (columnInfo.getColumnType() != ColumnType.INTERVALYM) {
            throw new SQLException("the field type is not FIELD_TYPE_INTERVALYM");
        }
        byte[] target = new byte[this.length];
        System.arraycopy(this.buf, this.pos, target, 0, this.length);
        return new INTERVALYM(target);
    }

    @Override
    public boolean isBinaryEncoded() {
        return true;
    }
}

