/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.ErrorPacket;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.io.IOException;
import java.sql.SQLException;

public class ComStmtPrepare {
    public static void send(PacketOutputStream pos, String sql) throws IOException {
        pos.startPacket(0);
        pos.write(22);
        pos.write(sql);
        pos.flush();
    }

    public static ServerPrepareResult read(PacketInputStream reader, boolean eofDeprecated, Protocol protocol, String sql) throws IOException, SQLException {
        reader.startReceiveResponse();
        try {
            Buffer buffer = reader.getPacket(true);
            byte firstByte = buffer.getByteAt(buffer.position);
            if (firstByte == -1) {
                throw ComStmtPrepare.buildErrorException(buffer);
            }
            if (firstByte == 0) {
                int i;
                buffer.readByte();
                int statementId = buffer.readInt();
                int numColumns = buffer.readShort() & 0xFFFF;
                int numParams = buffer.readShort() & 0xFFFF;
                ColumnDefinition[] params = new ColumnDefinition[numParams];
                ColumnDefinition[] columns = new ColumnDefinition[numColumns];
                if (numParams > 0) {
                    for (i = 0; i < numParams; ++i) {
                        params[i] = new ColumnDefinition(reader.getPacket(false), protocol.isOracleMode(), protocol.getOptions().characterEncoding);
                    }
                    if (numColumns > 0) {
                        if (!eofDeprecated) {
                            protocol.skipEofPacket();
                        }
                        for (i = 0; i < numColumns; ++i) {
                            columns[i] = new ColumnDefinition(reader.getPacket(false), protocol.isOracleMode(), protocol.getOptions().characterEncoding);
                        }
                    }
                    if (!eofDeprecated) {
                        protocol.readEofPacket();
                    }
                } else if (numColumns > 0) {
                    for (i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnDefinition(reader.getPacket(false), protocol.isOracleMode(), protocol.getOptions().characterEncoding);
                    }
                    if (!eofDeprecated) {
                        protocol.readEofPacket();
                    }
                } else {
                    buffer.readByte();
                    protocol.setHasWarnings(buffer.readShort() > 0);
                }
                ServerPrepareResult serverPrepareResult = new ServerPrepareResult(sql, statementId, columns, params, protocol);
                if (protocol.getOptions().cachePrepStmts && protocol.getOptions().useServerPrepStmts && sql != null && sql.length() < protocol.getOptions().prepStmtCacheSqlLimit) {
                    String key = protocol.getDatabase() + "-" + sql;
                    ServerPrepareResult cachedServerPrepareResult = protocol.addPrepareInCache(key, serverPrepareResult);
                    ServerPrepareResult serverPrepareResult2 = cachedServerPrepareResult != null ? cachedServerPrepareResult : serverPrepareResult;
                    return serverPrepareResult2;
                }
                ServerPrepareResult serverPrepareResult3 = serverPrepareResult;
                return serverPrepareResult3;
            }
            throw new SQLException("Unexpected packet returned by server, first byte " + firstByte);
        }
        finally {
            reader.endReceiveResponse(sql);
        }
    }

    private static SQLException buildErrorException(Buffer buffer) {
        ErrorPacket ep = new ErrorPacket(buffer);
        String message = ep.getMessage();
        if (1054 == ep.getErrorCode()) {
            return new SQLException(message + "\nIf column exists but type cannot be identified (example 'select ? `field1` from dual'). Use CAST function to solve this problem (example 'select CAST(? as integer) `field1` from dual')", ep.getSqlState(), ep.getErrorCode());
        }
        return new SQLException(message, ep.getSqlState(), ep.getErrorCode());
    }
}

