/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.input;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.TraceObject;
import com.oceanbase.jdbc.internal.io.input.AbstractPacketInputStream;
import com.oceanbase.jdbc.internal.io.input.ReadAheadBufferedStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.util.Options;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class StandardPacketInputStream
extends AbstractPacketInputStream {
    private static final Logger logger = LoggerFactory.getLogger(StandardPacketInputStream.class);
    protected byte[] mysqlHeader = new byte[4];
    protected int lastPacketLength;

    public StandardPacketInputStream(InputStream in, long threadId, Options options, TimeTrace timeTrace) {
        this.inputStream = options.useReadAheadInput ? new ReadAheadBufferedStream(in) : new BufferedInputStream(in, 16384);
        this.maxQuerySizeToLog = options.maxQuerySizeToLog;
        this.threadId = threadId;
        this.timeTrace = timeTrace;
    }

    public StandardPacketInputStream(long threadId, Options options, TimeTrace timeTrace) {
        this.maxQuerySizeToLog = options.maxQuerySizeToLog;
        this.threadId = threadId;
        this.timeTrace = timeTrace;
    }

    @Override
    public Buffer getPacket(boolean reUsable) throws IOException {
        return new Buffer(this.getPacketArray(reUsable), this.lastPacketLength);
    }

    @Override
    public byte[] getPacketArray(boolean reUsable) throws IOException {
        this.readMysqlStream(this.mysqlHeader, 0, 4);
        if (this.enableNetworkStatistics) {
            this.timestampAfterRead = System.currentTimeMillis();
        }
        this.lastPacketLength = (this.mysqlHeader[0] & 0xFF) + ((this.mysqlHeader[1] & 0xFF) << 8) + ((this.mysqlHeader[2] & 0xFF) << 16);
        this.mysqlSeqNo = this.mysqlHeader[3] & 0xFF;
        logger.debug("read: {}, packetLength = {}, packetNumber = {}", this.serverThreadLog, this.lastPacketLength, this.mysqlSeqNo);
        byte[] mysqlBody = reUsable && this.lastPacketLength < 1024 ? this.reusableArray : new byte[this.lastPacketLength];
        this.readMysqlStream(mysqlBody, 0, this.lastPacketLength);
        this.doTrace(0, this.lastPacketLength, mysqlBody);
        if (this.lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                this.readMysqlStream(this.mysqlHeader, 0, 4);
                packetLength = (this.mysqlHeader[0] & 0xFF) + ((this.mysqlHeader[1] & 0xFF) << 8) + ((this.mysqlHeader[2] & 0xFF) << 16);
                this.mysqlSeqNo = this.mysqlHeader[3] & 0xFF;
                int currentBufferLength = mysqlBody.length;
                byte[] newRawBytes = new byte[currentBufferLength + packetLength];
                System.arraycopy(mysqlBody, 0, newRawBytes, 0, currentBufferLength);
                mysqlBody = newRawBytes;
                this.readMysqlStream(mysqlBody, currentBufferLength, packetLength);
                this.lastPacketLength += packetLength;
                this.doTrace(currentBufferLength, packetLength, mysqlBody);
            } while (packetLength == 0xFFFFFF);
        }
        return mysqlBody;
    }

    @Override
    protected void readMysqlStream(byte[] rawBytes, int off, int remaining) throws IOException {
        int count;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
            }
            off += count;
        } while ((remaining -= count) > 0);
    }

    @Override
    protected void doTrace(int offset, int length, byte[] rawBytes) {
        if (this.traceCache != null) {
            this.traceCache.put(new TraceObject(false, 0, this.threadId, Arrays.copyOfRange(this.mysqlHeader, 0, 4), Arrays.copyOfRange(rawBytes, offset, Math.min(length, 1000))));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("read: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 4, offset, length, (byte[][])new byte[][]{this.mysqlHeader, rawBytes}));
        }
    }

    @Override
    public int getCompressLastPacketSeq() {
        return 0;
    }

    public static byte[] create(byte[] value) {
        if (value == null) {
            return new byte[]{-5};
        }
        int length = value.length;
        if (length < 251) {
            byte[] buf = new byte[length + 1];
            buf[0] = (byte)length;
            System.arraycopy(value, 0, buf, 1, length);
            return buf;
        }
        if (length < 65536) {
            byte[] buf = new byte[length + 3];
            buf[0] = -4;
            buf[1] = (byte)length;
            buf[2] = (byte)(length >>> 8);
            System.arraycopy(value, 0, buf, 3, length);
            return buf;
        }
        if (length < 0x1000000) {
            byte[] buf = new byte[length + 4];
            buf[0] = -3;
            buf[1] = (byte)length;
            buf[2] = (byte)(length >>> 8);
            buf[3] = (byte)(length >>> 16);
            System.arraycopy(value, 0, buf, 4, length);
            return buf;
        }
        byte[] buf = new byte[length + 9];
        buf[0] = -2;
        buf[1] = (byte)length;
        buf[2] = (byte)(length >>> 8);
        buf[3] = (byte)(length >>> 16);
        buf[4] = (byte)(length >>> 24);
        System.arraycopy(value, 0, buf, 9, length);
        return buf;
    }

    public static byte[] create(byte[][] row, ColumnType[] columnTypes) {
        int totalLength = 0;
        for (byte[] data : row) {
            if (data == null) {
                ++totalLength;
                continue;
            }
            int length = data.length;
            if (length < 251) {
                totalLength += length + 1;
                continue;
            }
            if (length < 65536) {
                totalLength += length + 3;
                continue;
            }
            if (length < 0x1000000) {
                totalLength += length + 4;
                continue;
            }
            totalLength += length + 9;
        }
        byte[] buf = new byte[totalLength];
        int pos = 0;
        for (byte[] data : row) {
            if (data == null) {
                buf[pos++] = -5;
                continue;
            }
            int length = data.length;
            if (length < 251) {
                buf[pos++] = (byte)length;
            } else if (length < 65536) {
                buf[pos++] = -4;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
            } else if (length < 0x1000000) {
                buf[pos++] = -3;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
                buf[pos++] = (byte)(length >>> 16);
            } else {
                buf[pos++] = -2;
                buf[pos++] = (byte)length;
                buf[pos++] = (byte)(length >>> 8);
                buf[pos++] = (byte)(length >>> 16);
                buf[pos++] = (byte)(length >>> 24);
                pos += 4;
            }
            System.arraycopy(data, 0, buf, pos, length);
            pos += length;
        }
        return buf;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

