/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.output;

import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.TimeZone;

public abstract class AbstractPacketOutputStream
extends FilterOutputStream
implements PacketOutputStream {
    protected long threadId;
    protected int mysqlSeqNo = 0;
    protected LruTraceCache traceCache = null;
    protected String serverThreadLog = "";
    protected final int maxQuerySizeToLog;
    protected boolean enableNetworkStatistics = false;
    protected long timestampBeforeFlush = 0L;
    private static final byte QUOTE = 39;
    private static final byte DBL_QUOTE = 34;
    private static final byte ZERO_BYTE = 0;
    private static final byte BACKSLASH = 92;
    private static final int SMALL_BUFFER_SIZE = 8192;
    private static final int MEDIUM_BUFFER_SIZE = 131072;
    private static final int LARGE_BUFFER_SIZE = 0x100000;
    protected byte[] buf;
    protected int pos;
    protected long cmdLength;
    protected int maxPacketLength;
    protected int maxAllowedPacket = Integer.MAX_VALUE;
    protected boolean permitTrace;
    private int mark = -1;
    private boolean bufferContainDataAfterMark = false;
    private TimeZone tm = null;
    protected Charset charset = null;
    private TimeTrace timeTrace;

    public AbstractPacketOutputStream(OutputStream out, int maxQuerySizeToLog, long threadId, String encoding, TimeTrace timeTrace) {
        super(out);
        this.buf = new byte[8192];
        this.maxQuerySizeToLog = maxQuerySizeToLog;
        this.cmdLength = 0L;
        this.threadId = threadId;
        this.charset = Charset.forName(encoding);
        this.timeTrace = timeTrace;
    }

    @Override
    public void setTimeZone(TimeZone tm) {
        this.tm = tm;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.tm;
    }

    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    @Override
    public abstract void startPacket(int var1);

    @Override
    public void enableNetworkStatistics(boolean flag) {
        this.enableNetworkStatistics = flag;
        this.timestampBeforeFlush = 0L;
    }

    @Override
    public long getTimestampBeforeFlush() {
        return this.timestampBeforeFlush;
    }

    @Override
    public void clearNetworkStatistics() {
        this.timestampBeforeFlush = 0L;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    protected abstract void flushBuffer(boolean var1) throws IOException;

    private void growBuffer(int len) throws IOException {
        int bufferLength = this.buf.length;
        int newCapacity = bufferLength == 8192 ? (len + this.pos < 131072 ? 131072 : (len + this.pos < 0x100000 ? 0x100000 : this.getMaxPacketLength())) : (bufferLength == 131072 ? (len + this.pos < 0x100000 ? 0x100000 : this.getMaxPacketLength()) : (this.bufferContainDataAfterMark ? Math.max(len + this.pos, this.getMaxPacketLength()) : this.getMaxPacketLength()));
        if (this.mark != -1 && len + this.pos > newCapacity) {
            this.flushBufferStopAtMark();
            if (len + this.pos <= bufferLength) {
                return;
            }
            if (len + this.pos > newCapacity) {
                newCapacity = len + this.pos;
            }
        }
        byte[] newBuf = new byte[newCapacity];
        System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
        this.buf = newBuf;
    }

    @Override
    public void writeEmptyPacket(int seqNo) throws IOException {
        this.startPacket(seqNo);
        this.writeEmptyPacket();
        this.out.flush();
        this.cmdLength = 0L;
    }

    @Override
    public abstract void writeEmptyPacket() throws IOException;

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
        this.out.flush();
        if (this.buf.length > 8192 && this.cmdLength * 2L < (long)this.buf.length) {
            this.buf = new byte[8192];
        }
        this.endSendRequest();
        if (this.cmdLength >= (long)this.maxAllowedPacket) {
            throw new MaxAllowedPacketException("query size (" + this.cmdLength + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", true);
        }
    }

    @Override
    public boolean checkRemainingSize(int len) {
        return this.getMaxPacketLength() - this.pos > len;
    }

    @Override
    public void checkMaxAllowedLength(int length) throws MaxAllowedPacketException {
        if (this.cmdLength + (long)length >= (long)this.maxAllowedPacket && this.cmdLength == 0L) {
            throw new MaxAllowedPacketException("query size (" + (this.cmdLength + (long)length) + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", false);
        }
    }

    @Override
    public boolean exceedMaxLength() {
        return this.cmdLength + (long)(this.pos - this.initialPacketPos()) >= (long)this.maxAllowedPacket;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void writeShort(short value) throws IOException {
        if (2 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{(byte)value, (byte)(value >> 8)};
            this.write(arr, 0, 2);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.pos += 2;
    }

    @Override
    public final void writeIntV1(int i) throws IOException {
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFF);
        b[this.pos++] = (byte)(i >>> 8);
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (4 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
            this.write(arr, 0, 4);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.buf[this.pos + 2] = (byte)(value >> 16);
        this.buf[this.pos + 3] = (byte)(value >> 24);
        this.pos += 4;
    }

    @Override
    public void writeFloatV1(float f) throws IOException {
        int i = Float.floatToIntBits(f);
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFF);
        b[this.pos++] = (byte)(i >>> 8);
        b[this.pos++] = (byte)(i >>> 16);
        b[this.pos++] = (byte)(i >>> 24);
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (8 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
            this.write(arr, 0, 8);
            return;
        }
        this.buf[this.pos] = (byte)value;
        this.buf[this.pos + 1] = (byte)(value >> 8);
        this.buf[this.pos + 2] = (byte)(value >> 16);
        this.buf[this.pos + 3] = (byte)(value >> 24);
        this.buf[this.pos + 4] = (byte)(value >> 32);
        this.buf[this.pos + 5] = (byte)(value >> 40);
        this.buf[this.pos + 6] = (byte)(value >> 48);
        this.buf[this.pos + 7] = (byte)(value >> 56);
        this.pos += 8;
    }

    @Override
    public void writeLongV1(long i) throws IOException {
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFFL);
        b[this.pos++] = (byte)(i >>> 8);
        b[this.pos++] = (byte)(i >>> 16);
        b[this.pos++] = (byte)(i >>> 24);
    }

    @Override
    public void writeBytes(byte value, int len) throws IOException {
        if (len > this.buf.length - this.pos) {
            byte[] arr = new byte[len];
            Arrays.fill(arr, value);
            this.write(arr, 0, len);
            return;
        }
        for (int i = this.pos; i < this.pos + len; ++i) {
            this.buf[i] = value;
        }
        this.pos += len;
    }

    @Override
    public void writeFieldLength(long length) throws IOException {
        if (length < 251L) {
            this.write((byte)length);
            return;
        }
        if (length < 65536L) {
            if (3 > this.buf.length - this.pos) {
                byte[] arr = new byte[]{-4, (byte)length, (byte)(length >>> 8)};
                this.write(arr, 0, 3);
                return;
            }
            this.buf[this.pos] = -4;
            this.buf[this.pos + 1] = (byte)length;
            this.buf[this.pos + 2] = (byte)(length >>> 8);
            this.pos += 3;
            return;
        }
        if (length < 0x1000000L) {
            if (4 > this.buf.length - this.pos) {
                byte[] arr = new byte[]{-3, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16)};
                this.write(arr, 0, 4);
                return;
            }
            this.buf[this.pos] = -3;
            this.buf[this.pos + 1] = (byte)length;
            this.buf[this.pos + 2] = (byte)(length >>> 8);
            this.buf[this.pos + 3] = (byte)(length >>> 16);
            this.pos += 4;
            return;
        }
        if (9 > this.buf.length - this.pos) {
            byte[] arr = new byte[]{-2, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16), (byte)(length >>> 24), (byte)(length >>> 32), (byte)(length >>> 40), (byte)(length >>> 48), (byte)(length >>> 56)};
            this.write(arr, 0, 9);
            return;
        }
        this.buf[this.pos] = -2;
        this.buf[this.pos + 1] = (byte)length;
        this.buf[this.pos + 2] = (byte)(length >>> 8);
        this.buf[this.pos + 3] = (byte)(length >>> 16);
        this.buf[this.pos + 4] = (byte)(length >>> 24);
        this.buf[this.pos + 5] = (byte)(length >>> 32);
        this.buf[this.pos + 6] = (byte)(length >>> 40);
        this.buf[this.pos + 7] = (byte)(length >>> 48);
        this.buf[this.pos + 8] = (byte)(length >>> 56);
        this.pos += 9;
    }

    @Override
    public void write(int value) throws IOException {
        if (this.pos >= this.buf.length) {
            if (this.pos >= this.getMaxPacketLength() && !this.bufferContainDataAfterMark) {
                this.flushBuffer(false);
            } else {
                this.growBuffer(1);
            }
        }
        this.buf[this.pos++] = (byte)value;
    }

    @Override
    public void write(byte[] arr) throws IOException {
        this.write(arr, 0, arr.length);
    }

    @Override
    public void write(byte[] arr, int off, int len) throws IOException {
        if (len > this.buf.length - this.pos) {
            if (this.buf.length != this.getMaxPacketLength()) {
                this.growBuffer(len);
            }
            if (len > this.buf.length - this.pos) {
                if (this.mark != -1) {
                    this.growBuffer(len);
                    if (this.mark != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    int remainingLen = len;
                    while (true) {
                        int lenToFillBuffer = Math.min(this.getMaxPacketLength() - this.pos, remainingLen);
                        System.arraycopy(arr, off, this.buf, this.pos, lenToFillBuffer);
                        off += lenToFillBuffer;
                        this.pos += lenToFillBuffer;
                        if ((remainingLen -= lenToFillBuffer) <= 0) break;
                        this.flushBuffer(false);
                    }
                    return;
                }
            }
        }
        System.arraycopy(arr, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, false, false);
    }

    @Override
    public void write(String str, boolean escape, boolean noBackslashEscapes) throws IOException {
        char currChar;
        int charsOffset;
        int charsLength = str.length();
        if (charsLength * 3 + 2 >= this.buf.length - this.pos || this.charset != StandardCharsets.UTF_8) {
            byte[] arr = str.getBytes(this.charset);
            if (escape) {
                this.write(39);
                this.writeBytesEscaped(arr, arr.length, noBackslashEscapes);
                this.write(39);
            } else {
                this.write(arr, 0, arr.length);
            }
            return;
        }
        if (escape) {
            this.buf[this.pos++] = 39;
            if (noBackslashEscapes) {
                for (charsOffset = 0; charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080'; ++charsOffset) {
                    if (currChar == '\'') {
                        this.buf[this.pos++] = 39;
                    }
                    this.buf[this.pos++] = (byte)currChar;
                }
            } else {
                while (charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080') {
                    switch (currChar) {
                        case '\u0000': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 48;
                            break;
                        }
                        case '\n': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 110;
                            break;
                        }
                        case '\r': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 114;
                            break;
                        }
                        case '\\': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 92;
                            break;
                        }
                        case '\'': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 39;
                            break;
                        }
                        case '\"': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 34;
                            break;
                        }
                        case '\u001a': {
                            this.buf[this.pos++] = 92;
                            this.buf[this.pos++] = 90;
                            break;
                        }
                        case '\u00a5': 
                        case '\u20a9': {
                            CharsetEncoder charsetEncoder = this.charset.newEncoder();
                            if (charsetEncoder != null) {
                                CharBuffer charBuffer = CharBuffer.allocate(1);
                                ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                                charBuffer.put(currChar);
                                charBuffer.position(0);
                                charsetEncoder.encode(charBuffer, byteBuffer, true);
                                if (byteBuffer.get(0) == 92) {
                                    this.buf[this.pos++] = 92;
                                }
                            }
                            this.buf[this.pos++] = (byte)currChar;
                            break;
                        }
                        default: {
                            this.buf[this.pos++] = (byte)currChar;
                        }
                    }
                    ++charsOffset;
                }
            }
        } else {
            while (charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080') {
                this.buf[this.pos++] = (byte)currChar;
                ++charsOffset;
            }
        }
        while (charsOffset < charsLength) {
            if ((currChar = str.charAt(charsOffset++)) < '\u0080') {
                if (escape) {
                    if (noBackslashEscapes) {
                        if (currChar == '\'') {
                            this.buf[this.pos++] = 39;
                        }
                    } else if (currChar == '\\' || currChar == '\'' || currChar == '\u0000' || currChar == '\"') {
                        this.buf[this.pos++] = 92;
                    }
                }
                this.buf[this.pos++] = (byte)currChar;
                continue;
            }
            if (currChar < '\u0800') {
                this.buf[this.pos++] = (byte)(0xC0 | currChar >> 6);
                this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
                continue;
            }
            if (currChar >= '\ud800' && currChar < '\ue000') {
                if (currChar < '\udc00') {
                    if (charsOffset + 1 > charsLength) {
                        this.buf[this.pos++] = 99;
                        continue;
                    }
                    char nextChar = str.charAt(charsOffset);
                    if (nextChar >= '\udc00' && nextChar < '\ue000') {
                        int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                        this.buf[this.pos++] = (byte)(0xF0 | surrogatePairs >> 18);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 12 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs >> 6 & 0x3F);
                        this.buf[this.pos++] = (byte)(0x80 | surrogatePairs & 0x3F);
                        ++charsOffset;
                        continue;
                    }
                    this.buf[this.pos++] = 63;
                    continue;
                }
                this.buf[this.pos++] = 63;
                continue;
            }
            this.buf[this.pos++] = (byte)(0xE0 | currChar >> 12);
            this.buf[this.pos++] = (byte)(0x80 | currChar >> 6 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | currChar & 0x3F);
        }
        if (escape) {
            this.buf[this.pos++] = 39;
        }
    }

    @Override
    public void write(InputStream is, boolean escape, boolean noBackslashEscapes) throws IOException {
        byte[] array = new byte[4096];
        if (escape) {
            int len;
            while ((len = is.read(array)) > 0) {
                this.writeBytesEscaped(array, len, noBackslashEscapes);
            }
        } else {
            int len;
            while ((len = is.read(array)) > 0) {
                this.write(array, 0, len);
            }
        }
    }

    @Override
    public void writeHex(InputStream is, boolean escape, boolean noBackslashEscapes) throws IOException {
        byte[] array = new byte[2048];
        if (escape) {
            int len;
            while ((len = is.read(array)) > 0) {
                this.writeBytesEscaped(Utils.toHexString(array).getBytes(), len << 1, noBackslashEscapes);
            }
        } else {
            int len;
            while ((len = is.read(array)) > 0) {
                this.write(Utils.toHexString(array).getBytes(), 0, len << 1);
            }
        }
    }

    @Override
    public void write(InputStream is, long length, boolean escape, boolean noBackslashEscapes) throws IOException {
        int len;
        byte[] array = new byte[4096];
        while (length > 0L && (len = is.read(array, 0, Math.min(4096, (int)length))) > 0) {
            if (escape) {
                this.writeBytesEscaped(array, len, noBackslashEscapes);
            } else {
                this.write(array, 0, len);
            }
            length -= (long)len;
        }
    }

    @Override
    public void writeHex(InputStream is, long length, boolean escape, boolean noBackslashEscapes) throws IOException {
        int len;
        byte[] array = new byte[2048];
        while (length > 0L && (len = is.read(array, 0, Math.min(2048, (int)length))) > 0) {
            this.writeBytesEscaped(Utils.toHexString(array).getBytes(), len << 1, escape);
            length -= (long)len;
        }
    }

    @Override
    public void write(Reader reader, boolean escape, boolean noBackslashEscapes) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while ((len = reader.read(buffer)) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes(this.charset);
            if (escape) {
                this.writeBytesEscaped(data, data.length, noBackslashEscapes);
                continue;
            }
            this.write(data);
        }
    }

    @Override
    public void writeEscapeQuote(Reader reader, boolean noBackslashEscapes) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while ((len = reader.read(buffer)) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes(this.charset);
            this.writeBytesEscapedQuote(data, data.length, noBackslashEscapes);
        }
    }

    @Override
    public void writeEscapeQuote(Reader reader, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while (length > 0L && (len = reader.read(buffer, 0, Math.min((int)length, 4096))) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes(this.charset);
            this.writeBytesEscapedQuote(data, data.length, noBackslashEscapes);
            length -= (long)len;
        }
    }

    @Override
    public void write(Reader reader, long length, boolean escape, boolean noBackslashEscapes) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while (length > 0L && (len = reader.read(buffer, 0, Math.min((int)length, 4096))) >= 0) {
            byte[] data = new String(buffer, 0, len).getBytes(this.charset);
            if (escape) {
                this.writeBytesEscaped(data, data.length, noBackslashEscapes);
            } else {
                this.write(data);
            }
            length -= (long)len;
        }
    }

    @Override
    public void writeBytesEscaped(byte[] bytes, int len, boolean noBackslashEscapes) throws IOException {
        if (len * 2 > this.buf.length - this.pos) {
            if (this.buf.length != this.getMaxPacketLength()) {
                this.growBuffer(len * 2);
            }
            if (len * 2 > this.buf.length - this.pos) {
                if (this.mark != -1) {
                    this.growBuffer(len * 2);
                    if (this.mark != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    if (noBackslashEscapes) {
                        for (int i = 0; i < len; ++i) {
                            if (39 == bytes[i]) {
                                this.buf[this.pos++] = 39;
                                if (this.buf.length <= this.pos) {
                                    this.flushBuffer(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.flushBuffer(false);
                        }
                    } else {
                        for (int i = 0; i < len; ++i) {
                            if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                                this.buf[this.pos++] = 92;
                                if (this.buf.length <= this.pos) {
                                    this.flushBuffer(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.flushBuffer(false);
                        }
                    }
                    return;
                }
            }
        }
        if (noBackslashEscapes) {
            for (int i = 0; i < len; ++i) {
                if (39 == bytes[i]) {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = bytes[i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                    this.buf[this.pos++] = 92;
                }
                this.buf[this.pos++] = bytes[i];
            }
        }
    }

    @Override
    public void writeBytesEscapedQuote(byte[] bytes, int len, boolean noBackslashEscapes) throws IOException {
        if (len * 2 > this.buf.length - this.pos) {
            if (this.buf.length != this.getMaxPacketLength()) {
                this.growBuffer(len * 2);
            }
            if (len * 2 > this.buf.length - this.pos) {
                if (this.mark != -1) {
                    this.growBuffer(len * 2);
                    if (this.mark != -1) {
                        this.flushBufferStopAtMark();
                    }
                } else {
                    if (noBackslashEscapes) {
                        for (int i = 0; i < len; ++i) {
                            if (39 == bytes[i]) {
                                this.buf[this.pos++] = 39;
                                if (this.buf.length <= this.pos) {
                                    this.flushBuffer(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.flushBuffer(false);
                        }
                    } else {
                        for (int i = 0; i < len; ++i) {
                            if (bytes[i] == 39) {
                                this.buf[this.pos++] = 39;
                                if (this.buf.length <= this.pos) {
                                    this.flushBuffer(false);
                                }
                            }
                            this.buf[this.pos++] = bytes[i];
                            if (this.buf.length > this.pos) continue;
                            this.flushBuffer(false);
                        }
                    }
                    return;
                }
            }
        }
        if (noBackslashEscapes) {
            for (int i = 0; i < len; ++i) {
                if (39 == bytes[i]) {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = bytes[i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (bytes[i] == 39) {
                    this.buf[this.pos++] = 39;
                }
                this.buf[this.pos++] = bytes[i];
            }
        }
    }

    @Override
    public int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    @Override
    public abstract void setMaxAllowedPacket(int var1);

    @Override
    public void permitTrace(boolean permitTrace) {
        this.permitTrace = permitTrace;
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = "conn=" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache traceCache) {
        this.traceCache = traceCache;
    }

    @Override
    public void mark() {
        this.mark = this.pos;
    }

    @Override
    public boolean isMarked() {
        return this.mark != -1;
    }

    @Override
    public void flushBufferStopAtMark() throws IOException {
        int end = this.pos;
        this.pos = this.mark;
        this.flushBuffer(true);
        this.out.flush();
        this.startPacket(0);
        System.arraycopy(this.buf, this.mark, this.buf, this.pos, end - this.mark);
        this.pos += end - this.mark;
        this.mark = -1;
        this.bufferContainDataAfterMark = true;
    }

    @Override
    public boolean bufferIsDataAfterMark() {
        return this.bufferContainDataAfterMark;
    }

    @Override
    public byte[] resetMark() {
        this.mark = -1;
        if (this.bufferContainDataAfterMark) {
            byte[] data = Arrays.copyOfRange(this.buf, this.initialPacketPos(), this.pos);
            this.startPacket(0);
            this.bufferContainDataAfterMark = false;
            return data;
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(int val) {
        this.pos = val;
    }

    public void startSendRequest() {
        if (this.timeTrace != null) {
            this.timeTrace.startSendRequest();
        }
    }

    public void endSendRequest() {
        if (this.timeTrace != null) {
            this.timeTrace.endSendRequest();
        }
    }
}

