/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol;

import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;

public class TimeTrace {
    private static final Logger logger = LoggerFactory.getLogger("JDBC-COST-LOGGER");
    private long startCallInterface;
    private long endCallInterface;
    private long startSendRequest;
    private long endSendRequest;
    private long startReceiveResponse;
    private long endReceiveResponse;

    public void startCallInterface() {
        this.startCallInterface = System.nanoTime();
    }

    public void endCallInterface(String interfaceName) {
        this.endCallInterface = System.nanoTime();
        logger.info("{}: CallInterface costs {}us.", (Object)interfaceName, (Object)this.getCallInterfaceElapsedTimeUs());
    }

    public long getCallInterfaceElapsedTimeUs() {
        return (this.endCallInterface - this.startCallInterface) / 1000L;
    }

    public void startSendRequest() {
        this.startSendRequest = System.nanoTime();
    }

    public void endSendRequest() {
        this.endSendRequest = System.nanoTime();
    }

    public long getSendRequestElapsedTimeUs() {
        return (this.endSendRequest - this.startSendRequest) / 1000L;
    }

    public void startReceiveResponse() {
        this.startReceiveResponse = System.nanoTime();
    }

    public void endReceiveResponse(String protocol, String sql) {
        this.endReceiveResponse = System.nanoTime();
        if (sql == null) {
            sql = "";
        } else if (sql.length() > 100) {
            sql = sql.substring(0, 100) + "...";
        }
        logger.info("{}: SendRequest costs {}us, ReceiveResponse costs {}us. {}", protocol, this.getSendRequestElapsedTimeUs(), this.getReceiveResponseElapsedTimeUs(), sql);
    }

    public long getReceiveResponseElapsedTimeUs() {
        return (this.endReceiveResponse - this.startReceiveResponse) / 1000L;
    }
}

