/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol.flt;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.protocol.flt.ObObj;
import com.oceanbase.jdbc.internal.protocol.flt.OceanBaseProtocolV20;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class FullLinkTrace {
    private static final int TYPE_LENGTH = 2;
    private static final int LEN_LENGTH = 4;
    private static final int TYPE_LEN_LENGTH = 6;
    private static final int FLT_SIZE = 4;
    private static final int DBL_SIZE = 8;
    private static final int MAX_DRIVER_LOG_SIZE = 8192;
    private static final int MAX_SHOW_TRACE_SPAN_SIZE = 0x40000000;
    private boolean traceEnable;
    private boolean forcePrint;
    private boolean autoFlush;
    private boolean showTraceEnable;
    public TraceInfo traceInfo;
    private UUID traceId;
    private UUID rootSpanId;
    private ConcurrentHashMap<UUID, SpanContext> activeSpanMap = new ConcurrentHashMap();
    private SpanContext lastActiveSpan;
    private byte level;
    private byte[] logBuf = new byte[8192];
    private int logBufOffset;
    private byte[] showTraceBuf = new byte[0x40000000];
    private int showTraceBufOffset;

    public FullLinkTrace(boolean useNewExtraInfo) {
        this.traceInfo = new TraceInfo(useNewExtraInfo);
        this.traceId = new UUID(0L, 0L);
        this.rootSpanId = new UUID(0L, 0L);
    }

    public boolean isShowTraceEnabled() {
        return this.traceInfo.controlInfo.showTraceEnabled;
    }

    public void beginTrace() {
        this.traceEnable = false;
        this.showTraceEnable = false;
        this.forcePrint = false;
        if (this.isShowTraceEnabled()) {
            this.showTraceEnable = true;
            this.traceEnable = true;
        } else if (this.traceInfo.controlInfo.isValid()) {
            boolean bl = this.traceEnable = FullLinkTrace.getPercentage() < this.traceInfo.controlInfo.samplePercentage;
        }
        if (this.traceEnable) {
            if (this.isShowTraceEnabled()) {
                this.forcePrint = true;
            } else {
                switch (this.traceInfo.controlInfo.recordPolicy) {
                    case RP_ALL: {
                        this.forcePrint = true;
                        break;
                    }
                    case RP_SAMPLE_AND_SLOW_QUERY: {
                        this.forcePrint = FullLinkTrace.getPercentage() < this.traceInfo.controlInfo.printSamplePercentage;
                        break;
                    }
                    default: {
                        this.forcePrint = false;
                    }
                }
            }
            this.traceId = UUID.randomUUID();
            this.level = this.traceInfo.controlInfo.level;
            this.autoFlush = this.forcePrint;
        } else {
            this.traceId = new UUID(0L, 0L);
            this.level = 0;
            this.autoFlush = false;
        }
    }

    public void endTrace() {
        if (this.isInitedUUID(this.traceId)) {
            for (SpanContext span : this.activeSpanMap.values()) {
                if (0L != span.endTimestamp) continue;
                span.endNano = System.nanoTime();
                span.endTimestamp = System.currentTimeMillis();
            }
            this.activeSpanMap.clear();
            this.lastActiveSpan = null;
        }
    }

    private void flushTransaction() throws IOException {
        for (SpanContext span : this.activeSpanMap.values()) {
            String log = this.flushQuery(span);
            if (0L == span.endTimestamp) continue;
            this.writeShowTraceIntoBuffer(log);
        }
    }

    private String flushQuery(SpanContext span) throws IOException {
        String log = this.writeLogIntoBuffer(span.getJsonString());
        span.tagList.clear();
        if (0L != span.endTimestamp) {
            this.activeSpanMap.remove(span.spanId);
        }
        return log;
    }

    public UUID beginSpan(int spanType) {
        return this.beginChildSpan(spanType);
    }

    private UUID beginChildSpan(int spanType) {
        return this.beginSpanInternal(spanType, (byte)1, false);
    }

    private UUID beginFollowSpan(int spanType) {
        return this.beginSpanInternal(spanType, (byte)1, true);
    }

    private UUID beginSpanInternal(int spanType, byte level, boolean isFollow) {
        UUID spanId = null;
        if (this.isInitedUUID(this.traceId) && level <= this.level) {
            SpanContext newSpan = new SpanContext(spanType, isFollow);
            SpanContext parent = this.getCurrentSpan();
            if (parent != null) {
                newSpan.sourceSpanId = parent.spanId;
            } else {
                this.rootSpanId = newSpan.spanId;
            }
            this.activeSpanMap.put(newSpan.spanId, newSpan);
            this.lastActiveSpan = newSpan;
            spanId = newSpan.spanId;
        }
        return spanId;
    }

    public void endSpan(UUID spanId) throws IOException {
        if (!this.isInitedUUID(this.traceId) || !this.isInitedUUID(spanId)) {
            return;
        }
        boolean slowQueryFound = false;
        SpanContext span = this.activeSpanMap.get(spanId);
        if (span != null) {
            span.endNano = System.nanoTime();
            span.endTimestamp = System.currentTimeMillis();
            if ((this.traceInfo.controlInfo.recordPolicy == RecordPolicy.RP_ONLY_SLOW_QUERY || this.traceInfo.controlInfo.recordPolicy == RecordPolicy.RP_SAMPLE_AND_SLOW_QUERY) && this.traceInfo.controlInfo.slowQueryThresholdMs > 0L && (span.endNano - span.startNano) / 1000L >= this.traceInfo.controlInfo.slowQueryThresholdMs) {
                slowQueryFound = true;
            }
        }
        if (this.forcePrint) {
            this.flushTransaction();
        } else if (slowQueryFound) {
            this.flushQuery(span);
        }
    }

    private SpanContext getCurrentSpan() {
        if (null == this.lastActiveSpan || 0L != this.lastActiveSpan.endTimestamp) {
            this.lastActiveSpan = null;
            for (SpanContext span : this.activeSpanMap.values()) {
                if (0L != span.endTimestamp) continue;
                this.lastActiveSpan = span;
                break;
            }
        }
        return this.lastActiveSpan;
    }

    public void setSpanTag(int tagType, String tagKey, String tagValue) {
        SpanContext span = this.getCurrentSpan();
        if (span != null && tagKey != null) {
            TagContext tag = new TagContext(tagType, tagKey, tagValue);
            span.tagList.addFirst(tag);
        }
    }

    public void buildRequest(OceanBaseProtocolV20 ob20) throws IOException {
        int showTraceSize;
        int spanInfoSize;
        int appInfoSize;
        int driverLogSize;
        int totalSize;
        SpanContext span = this.getCurrentSpan();
        if (span != null & this.traceEnable) {
            this.traceInfo.traceId = this.traceId;
            this.traceInfo.spanId = span.spanId;
            this.traceInfo.spanInfo.traceId = this.traceId;
            this.traceInfo.spanInfo.spanId = span.spanId;
            this.traceInfo.spanInfo.traceEnable = this.traceEnable;
            this.traceInfo.spanInfo.forcePrint = this.forcePrint;
            if (this.forcePrint) {
                this.flushTransaction();
            }
        }
        if (this.logBufOffset > 0) {
            this.traceInfo.driverLog.log = new String(this.logBuf, 0, this.logBufOffset) + '\u0000';
        }
        if (this.showTraceEnable && this.showTraceBufOffset > 0) {
            this.traceInfo.showTraceSpan.trace = '[' + new String(this.showTraceBuf, 0, this.showTraceBufOffset) + ']' + '\u0000';
        }
        if ((totalSize = (driverLogSize = this.traceInfo.driverLog.getSerializeSize()) + (appInfoSize = this.traceInfo.appInfo.getSerializeSize()) + (spanInfoSize = this.traceInfo.spanInfo.getSerializeSize()) + (showTraceSize = this.traceInfo.showTraceSpan.getSerializeSize())) > 0) {
            TraceInfo.access$4602(this.traceInfo, new byte[totalSize + 1]);
            Buffer buf = new Buffer(this.traceInfo.valueData, totalSize);
            if (driverLogSize != 0) {
                this.traceInfo.driverLog.serialize(buf);
                this.traceInfo.driverLog.reset();
                if (buf.getPosition() != driverLogSize) {
                    throw new IOException("Unexpected end position in EXTRA INFO: actual = " + buf.getPosition() + ", expected = " + driverLogSize);
                }
            }
            if (appInfoSize != 0) {
                this.traceInfo.appInfo.serialize(buf);
                this.traceInfo.appInfo.reset();
                if (buf.getPosition() != driverLogSize + appInfoSize) {
                    throw new IOException("Unexpected end position in EXTRA INFO: actual = " + buf.getPosition() + ", expected = " + (driverLogSize + appInfoSize));
                }
            }
            if (spanInfoSize != 0) {
                this.traceInfo.spanInfo.serialize(buf);
                this.traceInfo.spanInfo.reset();
                if (buf.getPosition() != driverLogSize + appInfoSize + spanInfoSize) {
                    throw new IOException("Unexpected end position in EXTRA INFO: actual = " + buf.getPosition() + ", expected = " + (driverLogSize + appInfoSize + spanInfoSize));
                }
            }
            if (showTraceSize != 0) {
                this.traceInfo.showTraceSpan.serialize(buf);
                this.traceInfo.showTraceSpan.reset();
                if (buf.getPosition() != totalSize) {
                    throw new IOException("Unexpected end position in EXTRA_INFO: actual = " + buf.getPosition() + ", expected = " + totalSize);
                }
            }
            this.logBufOffset = 0;
            this.showTraceBufOffset = 0;
            if (!this.traceInfo.useNewExtraInfo) {
                ((TraceInfo)this.traceInfo).valueData[totalSize] = 0;
                this.traceInfo.value.setVarchar(this.traceInfo.valueData, totalSize);
                ob20.setExtraInfo(this.traceInfo.key, this.traceInfo.value);
            } else {
                ob20.setExtraInfo(OceanBaseProtocolV20.ExtraInfoKey.FULL_TRC, Arrays.copyOfRange(this.traceInfo.valueData, 0, totalSize));
            }
        }
    }

    private String writeLogIntoBuffer(String spanJson) throws IOException {
        String log = "{\"trace_id\":\"" + FullLinkTrace.toStringUUID(this.traceId) + "\"," + spanJson + "}";
        if (log.length() > 8192 - this.logBufOffset) {
            throw new IOException("The length of DRIVER_LOG exceeds the buffer: need " + log.length() + " bytes, but remain " + (8192 - this.logBufOffset) + " bytes.");
        }
        System.arraycopy(log.getBytes(StandardCharsets.UTF_8), 0, this.logBuf, this.logBufOffset, log.length());
        this.logBufOffset += log.length();
        return log;
    }

    private void writeShowTraceIntoBuffer(String log) throws IOException {
        if (this.showTraceBufOffset > 1) {
            this.showTraceBuf[this.showTraceBufOffset++] = 44;
        }
        if (log.length() > 8192 - this.showTraceBufOffset) {
            throw new IOException("The length of SHOW_TRACE_SPAN exceeds the buffer: need " + log.length() + " bytes, but remain " + (8192 - this.showTraceBufOffset) + " bytes.");
        }
        System.arraycopy(log.getBytes(StandardCharsets.UTF_8), 0, this.showTraceBuf, this.showTraceBufOffset, log.length());
        this.showTraceBufOffset += log.length();
    }

    private static String toStringUUID(UUID uuid) {
        long high = uuid.getLeastSignificantBits();
        long low = uuid.getMostSignificantBits();
        byte[] bytes = new byte[16];
        Buffer buf = new Buffer(bytes);
        buf.writeLongFromHighToLow(high);
        buf.writeLongFromHighToLow(low);
        return FullLinkTrace.printHexBinary(bytes);
    }

    private static String printHexBinary(byte[] data) {
        char[] hexCode = "0123456789abcdef".toCharArray();
        StringBuilder builder = new StringBuilder(data.length * 2 + 4);
        for (int i = 0; i < data.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                builder.append("-");
            }
            byte b = data[i];
            builder.append(hexCode[b >> 4 & 0xF]);
            builder.append(hexCode[b & 0xF]);
        }
        return builder.toString();
    }

    private static String printHexBinary2(byte[] data) {
        char[] hexCode = "0123456789abcdef".toCharArray();
        StringBuilder builder = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            builder.append(hexCode[b >> 4 & 0xF]);
            builder.append(hexCode[b & 0xF]);
            builder.append(' ');
        }
        return builder.toString();
    }

    private boolean isInitedUUID(UUID uuid) {
        return uuid != null && (uuid.getLeastSignificantBits() != 0L || uuid.getMostSignificantBits() != 0L);
    }

    private static double getPercentage() {
        return Math.random();
    }

    private static int getStoreInt1Size() {
        return 7;
    }

    private static int getStoreInt2Size() {
        return 8;
    }

    private static int getStoreInt3Size() {
        return 9;
    }

    private static int getStoreInt4Size() {
        return 10;
    }

    private static int getStoreInt5Size() {
        return 11;
    }

    private static int getStoreInt6Size() {
        return 12;
    }

    private static int getStoreInt8Size() {
        return 14;
    }

    private static int getStoreDoubleSize() {
        return 14;
    }

    private static int getStoreFloatSize() {
        return 10;
    }

    private static int getStoreUuidSize() {
        return 22;
    }

    private static int getStoreStringSize(int strLen) {
        return 6 + strLen;
    }

    private static void storeInt(Buffer buf, long value, short type, long valueLen) throws IOException {
        buf.checkRemainder(6L + valueLen);
        buf.writeShort(type);
        buf.writeInt((int)valueLen);
        if (1L == valueLen) {
            buf.writeByte((byte)value);
        } else if (2L == valueLen) {
            buf.writeShort((short)value);
        } else if (3L == valueLen) {
            buf.writeLongInt((int)value);
        } else if (4L == valueLen) {
            buf.writeInt((int)value);
        } else if (5L == valueLen) {
            buf.writeNBytes(value, 5);
        } else if (6L == valueLen) {
            buf.writeNBytes(value, 6);
        } else if (8L == valueLen) {
            buf.writeLongFromLowToHigh(value);
        }
    }

    private static void storeInt1(Buffer buf, byte value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 1L);
    }

    private static void storeInt2(Buffer buf, short value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 2L);
    }

    private static void storeInt3(Buffer buf, int value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 3L);
    }

    private static void storeInt4(Buffer buf, int value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 4L);
    }

    private static void storeInt5(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 5L);
    }

    private static void storeInt6(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 6L);
    }

    private static void storeInt8(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 8L);
    }

    private static void storeDouble(Buffer buf, double value, short type) throws IOException {
        buf.checkRemainder(14L);
        buf.writeShort(type);
        buf.writeInt(8);
        buf.writeLongFromLowToHigh(Double.doubleToLongBits(value));
    }

    private static void storeFloat(Buffer buf, float value, short type) throws IOException {
        buf.checkRemainder(10L);
        buf.writeShort(type);
        buf.writeInt(4);
        buf.writeInt(Float.floatToIntBits(value));
    }

    private static void storeUUID(Buffer buf, UUID uuid, short type) throws IOException {
        buf.checkRemainder(22L);
        buf.writeShort(type);
        buf.writeInt(16);
        buf.writeLongFromHighToLow(uuid.getLeastSignificantBits());
        buf.writeLongFromHighToLow(uuid.getMostSignificantBits());
    }

    private static void storeString(Buffer buf, String str, int strLen, short type) throws IOException {
        buf.checkRemainder(6 + strLen);
        buf.writeShort(type);
        buf.writeInt(strLen);
        buf.writeString(str);
    }

    private static void storeTypeAndLen(Buffer buf, short type, int valLen) throws IOException {
        buf.checkRemainder(6L);
        buf.writeShort(type);
        buf.writeInt(valLen);
    }

    private static byte getInt1(Buffer buf, long valLen) throws IOException {
        if (1L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readByte();
    }

    private static short getInt2(Buffer buf, long valLen) throws IOException {
        if (2L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readShort();
    }

    private static int getInt3(Buffer buf, long valLen) throws IOException {
        if (3L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readInt3Bytes();
    }

    private static int getInt4(Buffer buf, long valLen) throws IOException {
        if (4L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readInt();
    }

    private static long getInt8(Buffer buf, long valLen) throws IOException {
        if (8L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readLong();
    }

    private static double getDouble(Buffer buf, long valLen) throws IOException {
        if (8L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return Double.longBitsToDouble(buf.readLong());
    }

    private static float getFloat(Buffer buf, long valLen) throws IOException {
        if (4L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return Float.intBitsToFloat(buf.readInt());
    }

    private static UUID getUUID(Buffer buf, long valLen) throws IOException {
        if (16L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        long high = buf.readLong();
        long low = buf.readLong();
        return new UUID(low, high);
    }

    private static String getString(Buffer buf, long strLen) throws IOException {
        buf.checkRemainder(strLen);
        return buf.readString((int)strLen);
    }

    static short resolveType(Buffer buf) throws IOException {
        buf.checkRemainder(2L);
        return buf.readShort();
    }

    static int resolveLength(Buffer buf) throws IOException {
        buf.checkRemainder(4L);
        return buf.readInt();
    }

    private class SpanContext {
        private int spanType;
        private UUID spanId;
        private UUID sourceSpanId;
        private boolean isFollow;
        private long startTimestamp;
        private long startNano;
        private long endTimestamp;
        private long endNano;
        private LinkedList<TagContext> tagList;
        private String moduleName = "oceanbase_jdbc";

        public SpanContext(int spanType, boolean isFollow) {
            this.spanType = spanType;
            this.spanId = UUID.randomUUID();
            this.sourceSpanId = new UUID(0L, 0L);
            this.isFollow = isFollow;
            this.startNano = System.nanoTime();
            this.startTimestamp = System.currentTimeMillis();
            this.endNano = 0L;
            this.endTimestamp = 0L;
            this.tagList = new LinkedList();
        }

        private String getJsonString() {
            String spanStr = "\"name\":\"" + this.moduleName + "\",\"id\":\"" + FullLinkTrace.toStringUUID(this.spanId) + "\",\"parent_id\":\"" + FullLinkTrace.toStringUUID(this.sourceSpanId) + "\",\"start_ts\":" + this.startTimestamp * 1000L + ",\"end_ts\":" + this.endTimestamp * 1000L + ",\"is_follow\":" + (this.isFollow ? "true" : "false");
            StringBuilder sb = new StringBuilder();
            sb.append(spanStr);
            if (this.endTimestamp == 0L && !this.tagList.isEmpty()) {
                sb.append(",\"tags\":[");
                boolean firstOne = true;
                for (TagContext tag : this.tagList) {
                    if (!firstOne) {
                        sb.append(",");
                    } else {
                        firstOne = false;
                    }
                    sb.append(tag.getJsonString());
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }

    private class TagContext {
        private int tagType;
        private String tagKey;
        private String tagValue;

        private TagContext(int tagType, String tagKey, String tagValue) {
            this.tagType = tagType;
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        private String getJsonString() {
            return "{\"" + this.tagKey + "\":\"" + this.tagValue + "\"}";
        }
    }

    public class TraceInfo {
        private DriveLog driverLog;
        public ControlInfo controlInfo;
        public AppInfo appInfo;
        QueryInfo queryInfo;
        SpanInfo spanInfo;
        ShowTraceSpan showTraceSpan;
        private boolean useNewExtraInfo;
        private ObObj key;
        private ObObj value;
        private byte[] valueData;
        private UUID traceId;
        private UUID spanId;

        private TraceInfo(boolean useNewExtraInfo) {
            this.driverLog = new DriveLog();
            this.controlInfo = new ControlInfo();
            this.appInfo = new AppInfo();
            this.queryInfo = new QueryInfo();
            this.spanInfo = new SpanInfo();
            this.showTraceSpan = new ShowTraceSpan();
            this.useNewExtraInfo = useNewExtraInfo;
            this.controlInfo.recordPolicy = RecordPolicy.RP_ONLY_SLOW_QUERY;
            if (!this.useNewExtraInfo) {
                this.key = new ObObj();
                this.value = new ObObj();
                String extraKey = OceanBaseProtocolV20.ExtraInfoKey.FULL_TRC.name().toLowerCase(Locale.ROOT);
                this.key.setVarchar(extraKey.getBytes(), extraKey.length());
            }
        }

        static /* synthetic */ byte[] access$4602(TraceInfo x0, byte[] x1) {
            x0.valueData = x1;
            return x1;
        }
    }

    private class ShowTraceSpan
    extends FullLinkTraceInfoBase {
        private String trace;

        private ShowTraceSpan() {
            this.type = FullLinkTraceExtraInfoType.FLT_SHOW_TRACE_SPAN;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.trace != null && this.trace.length() != 0) {
                localize += 6;
                localize += FullLinkTrace.getStoreStringSize(this.trace.length());
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeString(buf, this.trace, this.trace.length(), FullLinkTraceExtraInfoId.FLT_DRIVER_SHOW_TRACE_SPAN.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_DRIVER_SHOW_TRACE_SPAN.value) {
                    this.trace = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.trace = null;
        }
    }

    class SpanInfo
    extends FullLinkTraceInfoBase {
        private boolean traceEnable;
        private boolean forcePrint;
        private byte refType;
        private UUID traceId;
        private UUID spanId;

        private SpanInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_SPAN_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.traceEnable) {
                localize += 6;
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreUuidSize();
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreUuidSize();
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            if (this.traceEnable) {
                int originalPos = buf.getPosition();
                buf.checkRemainder(6L);
                buf.setPosition(originalPos + 6);
                FullLinkTrace.storeInt1(buf, this.traceEnable ? (byte)1 : 0, FullLinkTraceExtraInfoId.FLT_TRACE_ENABLE.getValue());
                FullLinkTrace.storeInt1(buf, this.forcePrint ? (byte)1 : 0, FullLinkTraceExtraInfoId.FLT_FORCE_PRINT.getValue());
                FullLinkTrace.storeUUID(buf, this.traceId, FullLinkTraceExtraInfoId.FLT_TRACE_ID.getValue());
                FullLinkTrace.storeInt1(buf, this.refType, FullLinkTraceExtraInfoId.FLT_REF_TYPE.getValue());
                FullLinkTrace.storeUUID(buf, this.spanId, FullLinkTraceExtraInfoId.FLT_SPAN_ID.getValue());
                int totalLen = buf.getPosition() - originalPos - 6;
                buf.setPosition(originalPos);
                FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
                buf.setPosition(buf.getPosition() + totalLen);
            }
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_TRACE_ENABLE.value) {
                    this.traceEnable = FullLinkTrace.getInt1(buf, valLen) == 1;
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_FORCE_PRINT.value) {
                    this.forcePrint = FullLinkTrace.getInt1(buf, valLen) == 1;
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_TRACE_ID.value) {
                    this.traceId = FullLinkTrace.getUUID(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_REF_TYPE.value) {
                    this.refType = FullLinkTrace.getInt1(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SPAN_ID.value) {
                    this.spanId = FullLinkTrace.getUUID(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.traceEnable = false;
            this.forcePrint = false;
            this.refType = 0;
            this.traceId = null;
            this.spanId = null;
        }
    }

    class QueryInfo
    extends FullLinkTraceInfoBase {
        long queryStartTimestamp;
        long queryEndTimestamp;

        private QueryInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_QUERY_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            localize += 6;
            localize += FullLinkTrace.getStoreInt8Size();
            return localize += FullLinkTrace.getStoreInt8Size();
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeInt8(buf, this.queryStartTimestamp, FullLinkTraceExtraInfoId.FLT_QUERY_START_TIMESTAMP.getValue());
            FullLinkTrace.storeInt8(buf, this.queryEndTimestamp, FullLinkTraceExtraInfoId.FLT_QUERY_END_TIMESTAMP.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_QUERY_START_TIMESTAMP.value) {
                    this.queryStartTimestamp = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_QUERY_END_TIMESTAMP.value) {
                    this.queryEndTimestamp = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }
    }

    public class AppInfo
    extends FullLinkTraceInfoBase {
        private String clientIdentifier;
        private String module;
        private String action;
        private String clientInfo;
        private boolean isSet;

        private AppInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_APP_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.isSet) {
                if (null != this.clientIdentifier) {
                    localize += FullLinkTrace.getStoreStringSize(this.clientIdentifier.length());
                }
                if (null != this.module) {
                    localize += FullLinkTrace.getStoreStringSize(this.module.length());
                }
                if (null != this.action) {
                    localize += FullLinkTrace.getStoreStringSize(this.action.length());
                }
                if (null != this.clientInfo) {
                    localize += FullLinkTrace.getStoreStringSize(this.clientInfo.length());
                }
                if (0 != localize) {
                    localize += 6;
                }
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            if (null != this.clientIdentifier) {
                FullLinkTrace.storeString(buf, this.clientIdentifier, this.clientIdentifier.length(), FullLinkTraceExtraInfoId.FLT_CLIENT_IDENTIFIER.getValue());
            }
            if (null != this.module) {
                FullLinkTrace.storeString(buf, this.module, this.module.length(), FullLinkTraceExtraInfoId.FLT_MODULE.getValue());
            }
            if (null != this.action) {
                FullLinkTrace.storeString(buf, this.action, this.action.length(), FullLinkTraceExtraInfoId.FLT_ACTION.getValue());
            }
            if (null != this.clientInfo) {
                FullLinkTrace.storeString(buf, this.clientInfo, this.clientInfo.length(), FullLinkTraceExtraInfoId.FLT_CLIENT_INFO.getValue());
            }
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_CLIENT_IDENTIFIER.value) {
                    this.clientIdentifier = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_MODULE.value) {
                    this.module = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_ACTION.value) {
                    this.action = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_CLIENT_INFO.value) {
                    this.clientInfo = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.isSet = false;
            this.clientIdentifier = null;
            this.module = null;
            this.action = null;
            this.clientInfo = null;
        }

        public void setModule(String module, String action) {
            this.isSet = true;
            this.module = module;
            this.action = action;
        }

        public String getModule() {
            return this.module;
        }

        public void setAction(String action) {
            this.isSet = true;
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        public void setClientInfo(String clientInfo) {
            this.isSet = true;
            this.clientInfo = clientInfo;
        }

        public String getClientInfo() {
            return this.clientInfo;
        }

        public void setClientIdentifier(String clientIdentifier) {
            this.isSet = true;
            this.clientIdentifier = clientIdentifier;
        }

        public String getClientIdentifier() {
            return this.clientIdentifier;
        }
    }

    public class ControlInfo
    extends FullLinkTraceInfoBase {
        byte level;
        double samplePercentage;
        RecordPolicy recordPolicy;
        double printSamplePercentage;
        long slowQueryThresholdMs;
        boolean showTraceEnabled;

        private ControlInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_CONTROL_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            localize += 6;
            localize += FullLinkTrace.getStoreInt1Size();
            localize += FullLinkTrace.getStoreDoubleSize();
            localize += FullLinkTrace.getStoreInt1Size();
            localize += FullLinkTrace.getStoreDoubleSize();
            localize += FullLinkTrace.getStoreInt8Size();
            return localize += FullLinkTrace.getStoreInt1Size();
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeInt1(buf, this.level, FullLinkTraceExtraInfoId.FLT_LEVEL.getValue());
            FullLinkTrace.storeDouble(buf, this.samplePercentage, FullLinkTraceExtraInfoId.FLT_SAMPLE_PERCENTAGE.getValue());
            FullLinkTrace.storeInt1(buf, (byte)this.recordPolicy.ordinal(), FullLinkTraceExtraInfoId.FLT_RECORD_POLICY.getValue());
            FullLinkTrace.storeDouble(buf, this.printSamplePercentage, FullLinkTraceExtraInfoId.FLT_PRINT_SAMPLE_PCT.getValue());
            FullLinkTrace.storeInt8(buf, this.slowQueryThresholdMs, FullLinkTraceExtraInfoId.FLT_SLOW_QUERY_THRES.getValue());
            FullLinkTrace.storeInt1(buf, this.showTraceEnabled ? (byte)1 : 0, FullLinkTraceExtraInfoId.FLT_SHOW_TRACE_ENABLE.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_LEVEL.value) {
                    this.level = FullLinkTrace.getInt1(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SAMPLE_PERCENTAGE.value) {
                    this.samplePercentage = FullLinkTrace.getDouble(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_RECORD_POLICY.value) {
                    byte v = FullLinkTrace.getInt1(buf, valLen);
                    this.recordPolicy = RecordPolicy.valueOf(v);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_PRINT_SAMPLE_PCT.value) {
                    this.printSamplePercentage = FullLinkTrace.getDouble(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SLOW_QUERY_THRES.value) {
                    this.slowQueryThresholdMs = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SHOW_TRACE_ENABLE.value) {
                    this.showTraceEnabled = FullLinkTrace.getInt1(buf, valLen) == 1;
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        public byte getLevel() {
            return this.level;
        }

        public double getSamplePercentage() {
            return this.samplePercentage;
        }

        public byte getRecordPolicy() {
            return (byte)(this.recordPolicy.ordinal() + 1);
        }

        public double getPrintSamplePercentage() {
            return this.printSamplePercentage;
        }

        public long getSlowQueryThreshold() {
            return this.slowQueryThresholdMs;
        }

        private boolean isValid() {
            return this.level > 0 && this.recordPolicy != RecordPolicy.MAX_RECORD_POLICY && this.samplePercentage >= 0.0 && this.samplePercentage <= 1.0 && this.printSamplePercentage >= 0.0 && this.printSamplePercentage <= 1.0;
        }
    }

    private class DriveLog
    extends FullLinkTraceInfoBase {
        private String log;

        private DriveLog() {
            this.type = FullLinkTraceExtraInfoType.FLT_DRV_LOG;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.log != null && this.log.length() != 0) {
                localize += 6;
                localize += FullLinkTrace.getStoreStringSize(this.log.length());
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeString(buf, this.log, this.log.length(), FullLinkTraceExtraInfoId.FLT_DRIVER_SPAN.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_DRIVER_SPAN.value) {
                    this.log = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.log = null;
        }
    }

    abstract class FullLinkTraceInfoBase {
        FullLinkTraceExtraInfoType type;

        FullLinkTraceInfoBase() {
        }

        protected abstract int getSerializeSize();

        protected abstract void serialize(Buffer var1) throws IOException;

        protected abstract void deserialize(Buffer var1, int var2) throws IOException;
    }

    public static enum TagKey {
        COMMAND_NAME("command_name"),
        CLIENT_HOST("client_host");

        private final String keyStr;

        private TagKey(String str) {
            this.keyStr = str;
        }

        public String getString() {
            return this.keyStr;
        }
    }

    private static enum RecordPolicy {
        RP_ALL,
        RP_ONLY_SLOW_QUERY,
        RP_SAMPLE_AND_SLOW_QUERY,
        MAX_RECORD_POLICY;


        private static RecordPolicy valueOf(byte v) throws UnsupportedEncodingException {
            switch (v) {
                case 1: {
                    return RP_ALL;
                }
                case 2: {
                    return RP_ONLY_SLOW_QUERY;
                }
                case 3: {
                    return RP_SAMPLE_AND_SLOW_QUERY;
                }
                case 4: {
                    return MAX_RECORD_POLICY;
                }
            }
            throw new UnsupportedEncodingException("Unknown RecordPolicy: " + v);
        }
    }

    static enum FullLinkTraceExtraInfoType {
        FLT_DRV_LOG(1),
        FLT_EXTRA_INFO_DRIVE_END(1000),
        FLT_APP_INFO(2001),
        FLT_QUERY_INFO(2002),
        FLT_CONTROL_INFO(2003),
        FLT_SPAN_INFO(2004),
        FLT_SHOW_TRACE_SPAN(2005),
        FLT_EXTRA_INFO_TYPE_END(65535);

        private final short value;

        private FullLinkTraceExtraInfoType(int v) {
            this.value = (short)v;
        }

        short getValue() {
            return this.value;
        }
    }

    private static enum FullLinkTraceExtraInfoId {
        FLT_DRIVER_SPAN(1),
        FLT_DRIVER_END(1000),
        FLT_PROXY_END(2000),
        FLT_CLIENT_IDENTIFIER(2001),
        FLT_MODULE(2002),
        FLT_ACTION(2003),
        FLT_CLIENT_INFO(2004),
        FLT_APPINFO_TYPE(2005),
        FLT_QUERY_START_TIMESTAMP(2010),
        FLT_QUERY_END_TIMESTAMP(2011),
        FLT_LEVEL(2020),
        FLT_SAMPLE_PERCENTAGE(2021),
        FLT_RECORD_POLICY(2022),
        FLT_PRINT_SAMPLE_PCT(2023),
        FLT_SLOW_QUERY_THRES(2024),
        FLT_SHOW_TRACE_ENABLE(2025),
        FLT_TRACE_ENABLE(2030),
        FLT_FORCE_PRINT(2031),
        FLT_TRACE_ID(2032),
        FLT_REF_TYPE(2033),
        FLT_SPAN_ID(2034),
        FLT_DRIVER_SHOW_TRACE_SPAN(2050),
        FLT_PROXY_SHOW_TRACE_SPAN(2051),
        FLT_EXTRA_INFO_ID_END(65535);

        private final short value;

        private FullLinkTraceExtraInfoId(int v) {
            this.value = (short)v;
        }

        private short getValue() {
            return this.value;
        }
    }
}

