/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallableFunctionStatement;
import com.oceanbase.jdbc.CallableParameterMetaData;
import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.util.dao.CloneableCallableStatement;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;

public class JDBC4CallableStatement
extends CallableFunctionStatement
implements CloneableCallableStatement {
    private SelectResultSet outputResultSet = null;

    public JDBC4CallableStatement(OceanBaseConnection connection, String databaseName, String procedureName, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, "SELECT " + procedureName + (arguments == null ? "()" : arguments), resultSetType, resultSetConcurrency, exceptionFactory);
        this.parameterMetadata = new CallableParameterMetaData(connection, databaseName, procedureName, true);
        this.arguments = arguments;
        super.initFunctionData(this.getParameterCount() + 1);
    }

    @Override
    protected SelectResultSet getResult() throws SQLException {
        if (this.outputResultSet == null) {
            throw new SQLException("No output result");
        }
        return this.outputResultSet;
    }

    @Override
    public JDBC4CallableStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        JDBC4CallableStatement clone = (JDBC4CallableStatement)super.clone(connection);
        clone.outputResultSet = null;
        return clone;
    }

    @Override
    public int executeUpdate() throws SQLException {
        ReentrantLock curLock = this.connection.lock;
        curLock.lock();
        try {
            lockLogger.debug("JDBC4CallableStatement.executeUpdate locked");
            super.execute();
            this.retrieveOutputResult();
            if (this.results != null && this.results.getResultSet() == null) {
                int n = 0;
                return n;
            }
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            curLock.unlock();
            lockLogger.debug("JDBC4CallableStatement.executeUpdate unlocked");
        }
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.results.getResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        super.setParameter(parameterIndex - 1, holder);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ReentrantLock curLock = this.connection.lock;
        curLock.lock();
        try {
            lockLogger.debug("JDBC4CallableStatement.executeQuery locked");
            super.execute();
            this.retrieveOutputResult();
            if (this.results != null && this.results.getResultSet() != null) {
                SelectResultSet selectResultSet = this.results.getResultSet();
                return selectResultSet;
            }
            JDBC4ResultSet jDBC4ResultSet = SelectResultSet.createEmptyResultSet();
            return jDBC4ResultSet;
        }
        finally {
            curLock.unlock();
            lockLogger.debug("JDBC4CallableStatement.executeQuery unlocked");
        }
    }

    @Override
    public boolean execute() throws SQLException {
        ReentrantLock curLock = this.connection.lock;
        curLock.lock();
        try {
            lockLogger.debug("JDBC4CallableStatement.execute locked");
            super.execute();
            this.retrieveOutputResult();
            boolean bl = this.results != null && this.results.getResultSet() == null;
            return bl;
        }
        finally {
            curLock.unlock();
            lockLogger.debug("JDBC4CallableStatement.execute unlocked");
        }
    }
}

