/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.OceanBaseConnection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class OceanBasePooledConnection
implements PooledConnection {
    private final OceanBaseConnection connection;
    private final List<ConnectionEventListener> connectionEventListeners;
    private final List<StatementEventListener> statementEventListeners;
    private final AtomicLong lastUsed;

    public OceanBasePooledConnection(OceanBaseConnection connection) {
        this.connection = connection;
        connection.pooledConnection = this;
        this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
        this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
        this.lastUsed = new AtomicLong(System.nanoTime());
    }

    @Override
    public OceanBaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.connection.pooledConnection = null;
        this.connection.close();
    }

    public void abort(Executor executor) throws SQLException {
        this.connection.pooledConnection = null;
        this.connection.abort(executor);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    public void fireStatementClosed(Statement st) {
        if (st instanceof PreparedStatement) {
            StatementEvent event = new StatementEvent(this, (PreparedStatement)st);
            for (StatementEventListener listener : this.statementEventListeners) {
                listener.statementClosed(event);
            }
        }
    }

    public void fireStatementErrorOccured(Statement st, SQLException ex) {
        if (st instanceof PreparedStatement) {
            StatementEvent event = new StatementEvent(this, (PreparedStatement)st, ex);
            for (StatementEventListener listener : this.statementEventListeners) {
                listener.statementErrorOccurred(event);
            }
        }
    }

    public void fireConnectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(event);
        }
    }

    public void fireConnectionErrorOccured(SQLException ex) {
        ConnectionEvent event = new ConnectionEvent(this, ex);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(event);
        }
    }

    public boolean noStmtEventListeners() {
        return this.statementEventListeners.isEmpty();
    }

    public AtomicLong getLastUsed() {
        return this.lastUsed;
    }

    public void lastUsedToNow() {
        this.lastUsed.set(System.nanoTime());
    }
}

