/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.util.Options;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class OceanBaseResultSetMetaData
implements ResultSetMetaData {
    private final ColumnDefinition[] fieldPackets;
    private final Options options;
    private final boolean forceAlias;
    private final boolean isOracleMode;
    private final int columnIndexOffset;

    public OceanBaseResultSetMetaData(ColumnDefinition[] fieldPackets, Options options, boolean forceAlias) {
        this.fieldPackets = fieldPackets;
        this.options = options;
        this.forceAlias = forceAlias;
        this.isOracleMode = false;
        this.columnIndexOffset = 0;
    }

    public OceanBaseResultSetMetaData(ColumnDefinition[] fieldPackets, Options options, boolean forceAlias, boolean isOracleMode, int columnIndexOffset) {
        this.fieldPackets = fieldPackets;
        this.options = options;
        this.forceAlias = forceAlias;
        this.isOracleMode = isOracleMode;
        this.columnIndexOffset = columnIndexOffset;
    }

    @Override
    public int getColumnCount() {
        return this.fieldPackets.length - this.columnIndexOffset;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getColumnInformation(column).getFlags() & 0x200) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        ColumnDefinition columnInformation = this.getColumnInformation(column);
        if (this.isOracleMode) {
            switch (columnInformation.getColumnType().getSqlType()) {
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
        switch (columnInformation.getColumnType().getSqlType()) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (columnInformation.isBinary()) {
                    return true;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if ((this.getColumnInformation(column).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInformation(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnInformation(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInformation(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.isOracleMode) {
            return this.getColumnLabel(column);
        }
        String columnName = this.getColumnInformation(column).getOriginalName();
        if ("".equals(columnName) || this.options.useOldAliasMetadataBehavior || this.forceAlias) {
            return this.getColumnLabel(column);
        }
        return columnName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnInformation(column).getDatabase();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return (int)this.getColumnInformation(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInformation(column).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.forceAlias) {
            return this.getColumnInformation(column).getTable();
        }
        if (this.options.blankTableNameMeta) {
            return "";
        }
        if (this.options.useOldAliasMetadataBehavior) {
            return this.getColumnInformation(column).getTable();
        }
        return this.getColumnInformation(column).getOriginalTable();
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnDefinition ci = this.getColumnInformation(column);
        if (this.isOracleMode) {
            switch (ci.getColumnType()) {
                case NVARCHAR2: {
                    return -9;
                }
                case BINARY_FLOAT: {
                    return 100;
                }
                case BINARY_DOUBLE: {
                    return 101;
                }
                case OBDECIMAL: 
                case NUMBER_FLOAT: {
                    return 2;
                }
                case ROWID: {
                    return -8;
                }
                case NCHAR: {
                    return -15;
                }
                case INTERVALYM: {
                    return -103;
                }
                case INTERVALDS: {
                    return -104;
                }
            }
        }
        switch (ci.getColumnType()) {
            case BIT: {
                if (ci.getLength() == 1L) {
                    return -7;
                }
                return -3;
            }
            case TINYINT: {
                if (ci.getLength() == 1L && this.options.tinyInt1isBit) {
                    if (this.options.transformedBitIsBoolean) {
                        return 16;
                    }
                    return -7;
                }
                return -6;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return 91;
                }
                return 5;
            }
            case BLOB: {
                if (!this.isOracleMode) {
                    if (ci.getLength() <= 255L) {
                        return -3;
                    }
                    return -4;
                }
                if (ci.getLength() < 0L || ci.getLength() > 0xFFFFFFL) {
                    return -4;
                }
                return -3;
            }
            case VARCHAR: {
                if (!(this.isOracleMode || ci.getSqltype() != 252 && ci.getSqltype() != 250 && ci.getSqltype() != 249)) {
                    return -1;
                }
                if (ci.getSqltype() == 251) {
                    return -1;
                }
                if (ci.isBinary()) {
                    return -3;
                }
                return 12;
            }
            case VARSTRING: {
                if (ci.isBinary()) {
                    return -3;
                }
                return 12;
            }
            case STRING: {
                if (ci.isBinary()) {
                    return -2;
                }
                return 1;
            }
            case MEDIUMBLOB: {
                if (this.isOracleMode) {
                    return ci.getColumnType().getSqlType();
                }
                return -4;
            }
        }
        return ci.getColumnType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnDefinition ci = this.getColumnInformation(column);
        return ColumnType.getColumnTypeName(ci.getColumnType(), ci.getLength(), ci.isSigned(), ci.isBinary(), this.isOracleMode);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        ColumnDefinition ci = this.getColumnInformation(column);
        return ci.getOriginalTable() == null || ci.getOriginalTable().length() <= 0 || ci.getName() == null || ci.getName().length() <= 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnDefinition ci = this.getColumnInformation(column);
        ColumnType type = ci.getColumnType();
        return ColumnType.getClassName(type, (int)ci.getLength(), ci.isSigned(), ci.isBinary(), this.options);
    }

    private ColumnDefinition getColumnInformation(int column) throws SQLException {
        int actualColumnIndex = column + this.columnIndexOffset;
        if (actualColumnIndex >= 1 && actualColumnIndex <= this.fieldPackets.length) {
            return this.fieldPackets[actualColumnIndex - 1];
        }
        throw ExceptionFactory.INSTANCE.create(String.format("wrong column index %s. must be in [1, %s] range", column, this.fieldPackets.length - this.columnIndexOffset));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

