/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class NUMBER
extends Datum {
    private BigDecimal bigDecimal;

    public NUMBER() {
    }

    @Override
    public String stringValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.toString();
        }
        return null;
    }

    @Override
    public boolean booleanValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.intValue() == 0;
        }
        return false;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.bigDecimal;
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        BigDecimal[] array = new BigDecimal[intVal];
        return array;
    }

    @Override
    public double doubleValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.doubleValue();
        }
        return 0.0;
    }

    @Override
    public float floatValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.floatValue();
        }
        return 0.0f;
    }

    @Override
    public long longValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.longValue();
        }
        return 0L;
    }

    public short shortValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.shortValue();
        }
        return 0;
    }

    @Override
    public byte byteValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.byteValue();
        }
        return 0;
    }

    public BigInteger bigIntegerValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.toBigInteger();
        }
        return null;
    }

    @Override
    public int intValue() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.intValue();
        }
        return 0;
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return this.bigDecimal;
    }

    public String toString() {
        if (this.bigDecimal != null) {
            return this.bigDecimal.toString();
        }
        return null;
    }

    public NUMBER(byte[] bytes) {
        super(bytes);
        if (bytes != null) {
            this.bigDecimal = new BigDecimal(new String(bytes));
        }
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String callName;
        switch (callName = targetClass.getName()) {
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.lang.String": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Short": {
                return true;
            }
        }
        return false;
    }
}

