/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send;

import com.oceanbase.jdbc.credential.Credential;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.constant.Version;
import com.oceanbase.jdbc.internal.util.pid.PidFactory;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.function.Supplier;

public class SendHandshakeResponsePacket {
    private static final Supplier<String> pidRequest = PidFactory.getInstance();
    private static final String _MYSQL_CLIENT_TYPE = "__mysql_client_type";
    private static final String CLIENT_TYPE = "__ob_jdbc_client";
    private static final String _CLIENT_NAME = "__ob_client_name";
    private static final String _CLIENT_VERSION = "__ob_client_version";
    private static final String _SERVER_HOST = "__server_host";
    private static final String _CLIENT_IP = "__client_ip";
    private static final String _OS = "__os";
    private static final String _PID = "__pid";
    private static final String _THREAD = "__thread";
    private static final String _JAVA_VENDOR = "__java_vendor";
    private static final String _JAVA_VERSION = "__java_version";
    private static final String _PROXY_CAPABILITY = "__proxy_capability_flag";
    private static final String _CLIENT_CAPABILITY = "__ob_client_attribute_capability_flag";
    public static final String OB_CAPABILITY_FLAG = "ob_capability_flag";

    public static void send(PacketOutputStream pos, Credential credential, String host, String database, long clientCapabilities, long serverCapabilities, byte serverLanguage, byte packetSeq, Options options, String authenticationPluginType, byte[] seed, String clientIp) throws IOException {
        byte[] authData;
        pos.startPacket(packetSeq);
        switch (authenticationPluginType) {
            case "mysql_clear_password": {
                pos.permitTrace(false);
                if (credential.getPassword() == null) {
                    authData = new byte[]{};
                    break;
                }
                if (options.passwordCharacterEncoding != null && !options.passwordCharacterEncoding.isEmpty()) {
                    authData = credential.getPassword().getBytes(options.passwordCharacterEncoding);
                    break;
                }
                authData = credential.getPassword().getBytes();
                break;
            }
            default: {
                authenticationPluginType = "mysql_native_password";
                pos.permitTrace(false);
                try {
                    authData = Utils.encryptPassword(credential.getPassword(), seed, options.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unknown algorithm SHA-1. Cannot encrypt password", e);
                }
            }
        }
        pos.writeInt((int)clientCapabilities);
        pos.writeInt(0x40000000);
        pos.write(serverLanguage);
        pos.writeBytes((byte)0, 19);
        pos.writeInt((int)(clientCapabilities >> 32));
        if (credential.getUser() == null || credential.getUser().isEmpty()) {
            pos.write(System.getProperty("user.name").getBytes());
        } else {
            pos.write(credential.getUser().getBytes());
        }
        pos.write(0);
        if ((serverCapabilities & 0x200000L) != 0L) {
            pos.writeFieldLength(authData.length);
            pos.write(authData);
        } else if ((serverCapabilities & 0x8000L) != 0L) {
            pos.write((byte)authData.length);
            pos.write(authData);
        } else {
            pos.write(authData);
            pos.write(0);
        }
        if ((clientCapabilities & 8L) != 0L) {
            pos.write(database);
            pos.write(0);
        }
        if ((serverCapabilities & 0x80000L) != 0L) {
            pos.write(authenticationPluginType);
            pos.write(0);
        }
        if ((serverCapabilities & 0x100000L) != 0L) {
            SendHandshakeResponsePacket.writeConnectAttributes(pos, options.connectionAttributes, host, options, clientIp, options.sendConnectionAttributes);
        }
        pos.flush();
        pos.permitTrace(true);
    }

    public static void sendChangeUser(PacketOutputStream pos, Credential credential, String host, String database, long clientCapabilities, long serverCapabilities, byte serverLanguage, byte packetSeq, Options options, String authenticationPluginType, byte[] seed, String clientIp, boolean isOracleMode) throws IOException {
        String user;
        byte[] authData;
        pos.startPacket(packetSeq);
        switch (authenticationPluginType) {
            case "mysql_clear_password": {
                pos.permitTrace(false);
                if (credential.getPassword() == null) {
                    authData = new byte[]{};
                    break;
                }
                if (options.passwordCharacterEncoding != null && !options.passwordCharacterEncoding.isEmpty()) {
                    authData = credential.getPassword().getBytes(options.passwordCharacterEncoding);
                    break;
                }
                authData = credential.getPassword().getBytes();
                break;
            }
            default: {
                authenticationPluginType = "mysql_native_password";
                pos.permitTrace(false);
                try {
                    authData = Utils.encryptPassword(credential.getPassword(), seed, options.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unknown algorithm SHA-1. Cannot encrypt password", e);
                }
            }
        }
        pos.startPacket(0);
        pos.write(17);
        if (credential.getUser() == null || credential.getUser().isEmpty()) {
            user = System.getProperty("user.name");
            pos.write(System.getProperty("user.name").getBytes());
        } else {
            user = credential.getUser();
            pos.write(credential.getUser().getBytes());
        }
        pos.write(0);
        if ((serverCapabilities & 0x200000L) != 0L) {
            pos.writeFieldLength(authData.length);
            pos.write(authData);
        } else if ((serverCapabilities & 0x8000L) != 0L) {
            pos.write((byte)authData.length);
            pos.write(authData);
        } else {
            pos.write(authData);
            pos.write(0);
        }
        if (isOracleMode) {
            if ((clientCapabilities & 8L) != 0L) {
                pos.write(database.toUpperCase(Locale.ROOT));
            } else {
                int index = user.indexOf(64);
                String databaseTmp = user.substring(0, index);
                pos.write(databaseTmp);
            }
        } else if ((clientCapabilities & 8L) != 0L) {
            pos.write(database);
        }
        pos.write(0);
        if ((serverCapabilities & 0x80000L) != 0L) {
            pos.write(authenticationPluginType);
            pos.write(0);
        }
        if ((serverCapabilities & 0x100000L) != 0L) {
            SendHandshakeResponsePacket.writeConnectAttributes(pos, options.connectionAttributes, host, options, clientIp, options.sendConnectionAttributes);
        }
        pos.flush();
        pos.permitTrace(true);
    }

    private static void writeConnectAttributes(PacketOutputStream pos, String connectionAttributes, String host, Options options, String clientIp, boolean sendConnectionAttributes) throws IOException {
        String pid;
        Buffer buffer = new Buffer(new byte[200]);
        buffer.writeStringSmallLength(_CLIENT_NAME.getBytes(pos.getCharset()));
        buffer.writeStringLength("OceanBase Connector/J", pos.getCharset());
        if (!sendConnectionAttributes) {
            pos.writeFieldLength(buffer.position);
            pos.write(buffer.buf, 0, buffer.position);
            return;
        }
        HashSet banListSet = new HashSet();
        String[] banListArray = new String[]{};
        if (options.defaultConnectionAttributesBanList != null) {
            banListArray = options.defaultConnectionAttributesBanList.split(",");
        }
        Collections.addAll(banListSet, banListArray);
        if (!banListSet.contains(_MYSQL_CLIENT_TYPE)) {
            buffer.writeStringSmallLength(_MYSQL_CLIENT_TYPE.getBytes(pos.getCharset()));
            buffer.writeStringLength(CLIENT_TYPE, pos.getCharset());
        }
        if (!banListSet.contains(_CLIENT_VERSION)) {
            buffer.writeStringSmallLength(_CLIENT_VERSION.getBytes(pos.getCharset()));
            buffer.writeStringLength(Version.version, pos.getCharset());
        }
        if (!banListSet.contains(_SERVER_HOST)) {
            buffer.writeStringSmallLength(_SERVER_HOST.getBytes(pos.getCharset()));
            buffer.writeStringLength(host != null ? host : "", pos.getCharset());
        }
        if (!banListSet.contains(_CLIENT_IP)) {
            buffer.writeStringSmallLength(_CLIENT_IP.getBytes(pos.getCharset()));
            buffer.writeStringLength(clientIp != null ? clientIp : "", pos.getCharset());
        }
        if (!banListSet.contains(_OS)) {
            buffer.writeStringSmallLength(_OS.getBytes(pos.getCharset()));
            buffer.writeStringLength(System.getProperty("os.name"), pos.getCharset());
        }
        if (!banListSet.contains(_PID) && (pid = pidRequest.get()) != null) {
            buffer.writeStringSmallLength(_PID.getBytes(pos.getCharset()));
            buffer.writeStringLength(pid, pos.getCharset());
        }
        if (!banListSet.contains(_THREAD)) {
            buffer.writeStringSmallLength(_THREAD.getBytes(pos.getCharset()));
            buffer.writeStringLength(Long.toString(Thread.currentThread().getId()), pos.getCharset());
        }
        if (!banListSet.contains(_JAVA_VENDOR)) {
            buffer.writeStringLength(_JAVA_VENDOR.getBytes(pos.getCharset()));
            buffer.writeStringLength(System.getProperty("java.vendor"), pos.getCharset());
        }
        if (!banListSet.contains(_JAVA_VERSION)) {
            buffer.writeStringSmallLength(_JAVA_VERSION.getBytes(pos.getCharset()));
            buffer.writeStringLength(System.getProperty("java.version"), pos.getCharset());
        }
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    buffer.writeStringLength(token.substring(0, separator), pos.getCharset());
                    buffer.writeStringLength(token.substring(separator + 1), pos.getCharset());
                    continue;
                }
                buffer.writeStringLength(token, pos.getCharset());
                buffer.writeStringLength("", pos.getCharset());
            }
        }
        if (!banListSet.contains(_PROXY_CAPABILITY)) {
            long capFlag = 1480L;
            if (!options.useObChecksum) {
                capFlag &= 0xFFFFFFFFFFFFFFF7L;
                capFlag &= 0xFFFFFFFFFFFFFFBFL;
            }
            if (!options.useOceanBaseProtocolV20) {
                capFlag &= 0xFFFFFFFFFFFFFEFFL;
            }
            if (options.enableFullLinkTrace) {
                capFlag |= 0x4000L;
                capFlag |= 0x8000L;
                capFlag |= 0x40000L;
            }
            if (options.allowLoadLocalInfile) {
                capFlag |= 0x100000L;
            }
            buffer.writeStringSmallLength(_PROXY_CAPABILITY.getBytes(pos.getCharset()));
            buffer.writeStringLength(String.valueOf(capFlag), pos.getCharset());
        }
        if (!banListSet.contains(_CLIENT_CAPABILITY) && options.useLobLocatorV2) {
            long capFlag = 1L;
            buffer.writeStringSmallLength(_CLIENT_CAPABILITY.getBytes(pos.getCharset()));
            buffer.writeStringLength(String.valueOf(capFlag), pos.getCharset());
        }
        pos.writeFieldLength(buffer.position);
        pos.write(buffer.buf, 0, buffer.position);
    }
}

