/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover;

import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.AbstractMastersListener;
import com.oceanbase.jdbc.internal.failover.HandleErrorResult;
import com.oceanbase.jdbc.internal.failover.tools.SearchFilter;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractMastersSlavesListener
extends AbstractMastersListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMastersSlavesListener.class);
    protected final AtomicReference<Protocol> waitNewSecondaryProtocol = new AtomicReference();
    protected final AtomicReference<Protocol> waitNewMasterProtocol = new AtomicReference();
    private final AtomicBoolean secondaryHostFail = new AtomicBoolean();
    private volatile long secondaryHostFailNanos = 0L;

    protected AbstractMastersSlavesListener(UrlParser urlParser, GlobalStateInfo globalInfo) {
        super(urlParser, globalInfo);
        this.secondaryHostFail.set(true);
    }

    @Override
    public HandleErrorResult handleFailover(SQLException qe, Method method, Object[] args, Protocol protocol, boolean isClosed) throws SQLException {
        boolean killCmd;
        if (this.isExplicitClosed()) {
            throw new SQLException("Connection has been closed !");
        }
        boolean bl = killCmd = qe != null && qe.getSQLState() != null && qe.getSQLState().equals("70100") && 1927 == qe.getErrorCode();
        if (protocol != null) {
            if (protocol.mustBeMasterConnection()) {
                if (!protocol.isMasterConnection()) {
                    logger.warn("SQL Primary node [{}, conn={}] is now in read-only mode. Exception : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), qe.getMessage());
                } else if (this.setMasterHostFail()) {
                    logger.warn("SQL Primary node [{}, conn={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), qe.getMessage());
                    this.addToBlacklist(protocol.getHostAddress());
                }
                return this.primaryFail(method, args, killCmd, isClosed);
            }
            if (this.setSecondaryHostFail()) {
                logger.warn("SQL secondary node [{}, conn={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), qe.getMessage());
                this.addToBlacklist(protocol.getHostAddress());
            }
            return this.secondaryFail(method, args, killCmd);
        }
        return this.primaryFail(method, args, killCmd, isClosed);
    }

    @Override
    public void resetMasterFailoverData() {
        super.resetMasterFailoverData();
        if (!this.secondaryHostFail.get()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    protected void resetSecondaryFailoverData() {
        if (this.secondaryHostFail.compareAndSet(true, false)) {
            this.secondaryHostFailNanos = 0L;
        }
        if (!this.isMasterHostFail()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    public long getSecondaryHostFailNanos() {
        return this.secondaryHostFailNanos;
    }

    public boolean setSecondaryHostFail() {
        if (this.secondaryHostFail.compareAndSet(false, true)) {
            this.secondaryHostFailNanos = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isSecondaryHostFail() {
        return this.secondaryHostFail.get();
    }

    public boolean isSecondaryHostFailReconnect() {
        return this.secondaryHostFail.get() && this.waitNewSecondaryProtocol.get() == null;
    }

    public boolean isMasterHostFailReconnect() {
        return this.isMasterHostFail() && this.waitNewMasterProtocol.get() == null;
    }

    @Override
    public boolean hasHostFail() {
        return this.isSecondaryHostFailReconnect() || this.isMasterHostFailReconnect();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail());
    }

    public abstract HandleErrorResult secondaryFail(Method var1, Object[] var2, boolean var3) throws SQLException;

    public abstract void foundActiveSecondary(Protocol var1) throws SQLException;
}

