/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.failover.FailoverProxy;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.util.ServerPrepareStatementCache;
import com.oceanbase.jdbc.internal.util.dao.ClientPrepareResult;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantLock;

public interface Protocol {
    public ServerPrepareResult prepare(String var1, boolean var2) throws SQLException;

    public boolean getAutocommit() throws SQLException;

    public void setAutoCommit(boolean var1) throws SQLException;

    public boolean noBackslashEscapes();

    public void connect() throws SQLException, IOException;

    public UrlParser getUrlParser();

    public boolean inTransaction();

    public boolean isOracleMode();

    public boolean isTZTablesImported();

    public FailoverProxy getProxy();

    public void setProxy(FailoverProxy var1);

    public Options getOptions();

    public boolean hasMoreResults();

    public void close();

    public void abort();

    public void reset() throws SQLException;

    public void closeExplicit();

    public boolean isClosed();

    public void resetDatabase() throws SQLException;

    public String getCatalog() throws SQLException;

    public void setCatalog(String var1) throws SQLException;

    public String getServerVersion();

    public void setObServerVersion(String var1);

    public String getObServerVersion();

    public boolean haveInformationSchemaParameters();

    public boolean supportStmtPrepareExecute();

    public boolean supportFetchWithOffset();

    public void setFullLinkTraceModule(String var1, String var2);

    public String getFullLinkTraceModule();

    public void setFullLinkTraceAction(String var1);

    public String getFullLinkTraceAction();

    public void setFullLinkTraceClientInfo(String var1);

    public String getFullLinkTraceClientInfo();

    public void setFullLinkTraceIdentifier(String var1);

    public String getFullLinkTraceIdentifier();

    public byte getFullLinkTraceLevel();

    public double getFullLinkTraceSamplePercentage();

    public byte getFullLinkTraceRecordPolicy();

    public double getFullLinkTracePrintSamplePercentage();

    public long getFullLinkTraceSlowQueryThreshold();

    public boolean isConnected();

    public boolean getReadonly() throws SQLException;

    public void setReadonly(boolean var1) throws SQLException;

    public boolean isMasterConnection();

    public boolean mustBeMasterConnection();

    public HostAddress getHostAddress();

    public void setHostAddress(HostAddress var1);

    public String getHost();

    public int getPort();

    public void rollback() throws SQLException;

    public String getDatabase();

    public String getUsername();

    public void setUsername(String var1);

    public boolean ping() throws SQLException;

    public boolean isValid(int var1) throws SQLException;

    public void executeQuery(String var1) throws SQLException;

    public void executeQuery(boolean var1, Results var2, String var3) throws SQLException;

    public void executeQuery(boolean var1, Results var2, String var3, Charset var4) throws SQLException;

    public void executeQuery(boolean var1, Results var2, ClientPrepareResult var3, ParameterHolder[] var4) throws SQLException;

    public void executeQuery(boolean var1, Results var2, ClientPrepareResult var3, ParameterHolder[] var4, int var5) throws SQLException;

    public void executePreparedQuery(boolean var1, ServerPrepareResult var2, Results var3, ParameterHolder[] var4) throws SQLException;

    public ServerPrepareResult executePreparedQuery(int var1, ParameterHolder[] var2, ServerPrepareResult var3, Results var4) throws SQLException;

    public ServerPrepareResult executeBatchServer(ServerPrepareResult var1, Results var2, String var3, List<ParameterHolder[]> var4, boolean var5) throws SQLException;

    public boolean executeBatchClient(boolean var1, Results var2, ClientPrepareResult var3, List<ParameterHolder[]> var4, boolean var5) throws SQLException;

    public void executeBatchStmt(boolean var1, Results var2, List<String> var3) throws SQLException;

    public void getResult(Results var1) throws SQLException;

    public void cancelCurrentQuery() throws SQLException;

    public void interrupt();

    public void skip() throws SQLException;

    public boolean checkIfMaster() throws SQLException;

    public boolean hasWarnings();

    public long getMaxRows();

    public void setMaxRows(long var1) throws SQLException;

    public int getMajorServerVersion();

    public int getMinorServerVersion();

    public void parseVersion(String var1);

    public boolean versionGreaterOrEqual(int var1, int var2, int var3);

    public void setLocalInfileInputStream(InputStream var1);

    public int getTimeout();

    public void setTimeout(int var1) throws SocketException;

    public boolean getPinGlobalTxToPhysicalConnection();

    public long getServerThreadId();

    public Socket getSocket();

    public void setTransactionIsolation(int var1) throws SQLException;

    public int getTransactionIsolationLevel();

    public boolean isExplicitClosed();

    public void connectWithoutProxy() throws SQLException;

    public boolean shouldReconnectWithoutProxy();

    public void setHostFailedWithoutProxy();

    public void releasePrepareStatement(ServerPrepareResult var1) throws SQLException;

    public boolean forceReleasePrepareStatement(int var1) throws SQLException;

    public ServerPrepareStatementCache prepareStatementCache();

    public TimeZone getTimeZone();

    public void prolog(long var1, boolean var3, OceanBaseConnection var4, OceanBaseStatement var5) throws SQLException;

    public void prologProxy(ServerPrepareResult var1, long var2, boolean var4, OceanBaseConnection var5, OceanBaseStatement var6) throws SQLException;

    public Results getActiveStreamingResult();

    public void setActiveStreamingResult(Results var1);

    public ReentrantLock getLock();

    public void setServerStatus(short var1);

    public void removeHasMoreResults();

    public void setHasWarnings(boolean var1);

    public ServerPrepareResult addPrepareInCache(String var1, ServerPrepareResult var2);

    public void readOkPacket(Buffer var1, Results var2);

    public void readEofPacket() throws SQLException, IOException;

    public void skipEofPacket() throws SQLException, IOException;

    public SQLException readErrorPacket(Buffer var1, Results var2);

    public void readResultSet(ColumnDefinition[] var1, Results var2) throws SQLException;

    public void changeSocketTcpNoDelay(boolean var1);

    public void changeSocketSoTimeout(int var1) throws SocketException;

    public void removeActiveStreamingResult();

    public void resetStateAfterFailover(long var1, int var3, String var4, boolean var5) throws SQLException;

    public void setActiveFutureTask(FutureTask var1);

    public boolean isServerMariaDb();

    public SQLException handleIoException(Exception var1);

    public PacketInputStream getReader();

    public boolean isEofDeprecated();

    public int getAutoIncrementIncrement() throws SQLException;

    public boolean sessionStateAware();

    public String getTraces();

    public boolean isInterrupted();

    public void stopIfInterrupted() throws SQLTimeoutException;

    public void setChecksum(long var1);

    public void resetChecksum();

    public long getChecksum();

    public void setIterationCount(int var1);

    public int getIterationCount();

    public void setExecuteMode(int var1);

    public int getExecuteMode();

    public void setComStmtPrepareExecuteField(int var1, int var2, long var3);

    public ColumnDefinition[] fetchRowViaCursor(int var1, int var2, Results var3) throws SQLException;

    public ColumnDefinition[] fetchRowViaCursorForOracle(int var1, int var2, byte var3, int var4, Results var5) throws SQLException;

    public long getLastPacketCostTime() throws SQLException;

    public void setNetworkStatisticsFlag(boolean var1);

    public boolean getNetworkStatisticsFlag();

    public long getLastPacketResponseTimestamp();

    public long getLastPacketSendTimestamp();

    public void clearNetworkStatistics();

    public void changeUser(String var1, String var2) throws SQLException;

    public String getEncoding();

    public void executePreparedQueryArrayBinding(boolean var1, ServerPrepareResult var2, Results var3, List<ParameterHolder[]> var4, int var5) throws SQLException;

    public ServerPrepareResult executePreparedQueryArrayBinding(int var1, boolean var2, ServerPrepareResult var3, Results var4, List<ParameterHolder[]> var5, int var6) throws SQLException;

    public PacketOutputStream getWriter();

    public HostAddress getCurrentHost();

    public TimeTrace getTimeTrace();

    public void startCallInterface();

    public void endCallInterface(String var1);

    public int getServerStatus();
}

