/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util.dao;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.dao.PrepareResult;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerPrepareResult
implements PrepareResult {
    private final String sql;
    private int statementId;
    private final ColumnDefinition[] columns;
    private final ColumnDefinition[] parameters;
    private ColumnType[] parameterTypeHeader;
    private final AtomicBoolean inCache = new AtomicBoolean();
    private Protocol unProxiedProtocol;
    private volatile int shareCounter = 1;
    private volatile boolean isBeingDeallocate;
    private volatile boolean returnByPrepareExecute;

    public ServerPrepareResult(String sql, int statementId, ColumnDefinition[] columns, ColumnDefinition[] parameters, Protocol unProxiedProtocol) {
        this.sql = sql;
        this.statementId = statementId;
        this.columns = columns;
        this.parameters = parameters;
        this.parameterTypeHeader = new ColumnType[parameters.length];
        this.unProxiedProtocol = unProxiedProtocol;
    }

    public void resetParameterTypeHeader() {
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
    }

    public void failover(int statementId, Protocol unProxiedProtocol) {
        this.statementId = statementId;
        this.unProxiedProtocol = unProxiedProtocol;
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
        this.shareCounter = 1;
        this.isBeingDeallocate = false;
    }

    public void setAddToCache() {
        this.inCache.set(true);
    }

    public void setRemoveFromCache() {
        this.inCache.set(false);
    }

    public synchronized boolean incrementShareCounter() {
        if (this.isBeingDeallocate) {
            return false;
        }
        ++this.shareCounter;
        return true;
    }

    public synchronized void decrementShareCounter() {
        --this.shareCounter;
    }

    public synchronized boolean canBeDeallocate() {
        if (this.shareCounter > 0 || this.isBeingDeallocate) {
            return false;
        }
        if (!this.inCache.get()) {
            this.isBeingDeallocate = true;
            return true;
        }
        return false;
    }

    @Override
    public int getParamCount() {
        return this.parameters.length;
    }

    public synchronized int getShareCounter() {
        return this.shareCounter;
    }

    public void setStatementId(int statementId) {
        this.statementId = statementId;
    }

    public void release() {
        this.statementId = 0;
        this.shareCounter = 1;
        this.isBeingDeallocate = false;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnDefinition[] getColumns() {
        return this.columns;
    }

    public ColumnDefinition[] getParameters() {
        return this.parameters;
    }

    public Protocol getUnProxiedProtocol() {
        return this.unProxiedProtocol;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public ColumnType[] getParameterTypeHeader() {
        return this.parameterTypeHeader;
    }

    public boolean isReturnByPrepareExecute() {
        return this.returnByPrepareExecute;
    }

    public void setReturnByPrepareExecute(boolean returnByPrepareExecute) {
        this.returnByPrepareExecute = returnByPrepareExecute;
    }
}

