/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.PrettyFilter;
import com.ocpsoft.pretty.beans.MappingUrlBuilder;
import com.ocpsoft.pretty.beans.ParameterInjector;
import com.ocpsoft.pretty.config.PrettyConfig;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.util.FacesElUtils;
import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyContext
implements Serializable {
    private static final Log log = LogFactory.getLog(PrettyContext.class);
    private static final long serialVersionUID = -4593906924975844541L;
    public static final String PRETTY_PREFIX = "pretty:";
    private static final String CONTEXT_REQUEST_KEY = "prettyContext";
    private static final ParameterInjector injector = new ParameterInjector();
    private static final FacesElUtils elUtils = new FacesElUtils();
    private PrettyConfig config;
    private final String originalUri;
    private final String originalQueryString;
    private final String contextPath;
    private String calculatedUri = "";
    private String calculatedQueryString = "";
    private String currentViewId = "";
    private PrettyUrlMapping currentMapping;
    private boolean inNavigation = false;

    private PrettyContext(HttpServletRequest request) {
        this.contextPath = request.getContextPath();
        this.originalUri = request.getRequestURI();
        this.originalQueryString = request.getQueryString();
        this.calculatedUri = request.getRequestURI();
        this.calculatedQueryString = request.getQueryString();
    }

    public static PrettyContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return PrettyContext.getCurrentInstance((HttpServletRequest)context.getExternalContext().getRequest());
    }

    public static PrettyContext getCurrentInstance(HttpServletRequest request) {
        PrettyContext prettyContext = (PrettyContext)request.getAttribute(CONTEXT_REQUEST_KEY);
        if (prettyContext instanceof PrettyContext) {
            log.trace((Object)"Retrieved PrettyContext from Request");
            return prettyContext;
        }
        return PrettyContext.newInstance(request);
    }

    static PrettyContext newInstance(HttpServletRequest request) {
        log.trace((Object)"PrettyContext not found in Request - building new instance");
        PrettyContext prettyContext = new PrettyContext(request);
        PrettyConfig prettyConfig = PrettyFilter.getConfig();
        prettyContext.setConfig(prettyConfig);
        request.setAttribute(CONTEXT_REQUEST_KEY, (Object)prettyContext);
        return prettyContext;
    }

    void injectParameters() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        injector.injectParameters(facesContext);
    }

    void computeDynamicViewId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String currentUri = this.stripContextPath(this.originalUri);
        PrettyUrlMapping urlMapping = this.getConfig().getMappingForUrl(currentUri);
        if (urlMapping != null) {
            String viewId = urlMapping.getViewId();
            if (viewId == null) {
                viewId = "";
            }
            while (elUtils.isEl(viewId)) {
                Object viewResult = elUtils.invokeMethod(facesContext, viewId);
                if (viewResult == null) {
                    viewId = "";
                    break;
                }
                viewId = viewResult.toString();
                if (!this.getConfig().isMappingId(viewId)) continue;
                urlMapping = this.getConfig().getMappingById(viewId);
                viewId = urlMapping.getViewId();
                this.calculatedUri = new MappingUrlBuilder().getURL(urlMapping);
                this.calculatedQueryString = null;
            }
            if ("".equals(viewId)) {
                log.debug((Object)("ViewId for mapping with id <" + urlMapping.getId() + "> was blank"));
            }
            this.setCurrentMapping(urlMapping);
            this.setCurrentViewId(viewId);
        }
    }

    public String getCalculatedActionUri() {
        String result = this.calculatedUri;
        if (this.calculatedQueryString != null && this.calculatedQueryString.length() > 0) {
            result = String.valueOf(result) + "?" + this.calculatedQueryString;
        }
        return result;
    }

    public String getOriginalRequestUrl() {
        String result = this.originalUri;
        String queryString = this.originalQueryString;
        if (queryString != null && queryString.length() > 0) {
            result = String.valueOf(result) + "?" + queryString;
        }
        return result;
    }

    public boolean isPrettyRequest() {
        return this.getConfig().isURLMapped(this.stripContextPath(this.originalUri));
    }

    public boolean isURLMapped(String url) {
        return this.getConfig().isURLMapped(this.stripContextPath(url));
    }

    public String stripContextPath(String uri) {
        if (uri.startsWith(this.contextPath)) {
            uri = uri.substring(this.contextPath.length());
        }
        return uri;
    }

    public String getCurrentCalculatedUri() {
        return this.calculatedUri;
    }

    public PrettyConfig getConfig() {
        return this.config;
    }

    void setConfig(PrettyConfig config) {
        this.config = config;
    }

    public PrettyUrlMapping getCurrentMapping() {
        return this.currentMapping;
    }

    private void setCurrentMapping(PrettyUrlMapping mapping) {
        this.currentMapping = mapping;
    }

    public String getCurrentCalculatedViewId() {
        return this.currentViewId;
    }

    private void setCurrentViewId(String viewId) {
        this.currentViewId = viewId;
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public boolean isInNavigation() {
        return this.inNavigation;
    }

    public void setInNavigation(boolean value) {
        this.inNavigation = value;
    }
}

