/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.config.PrettyConfig;
import com.ocpsoft.pretty.config.PrettyConfigurator;
import com.ocpsoft.pretty.util.FacesContextBuilder;
import com.ocpsoft.pretty.util.FacesMessagesUtils;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class PrettyFilter
implements Filter {
    private static final Log log = LogFactory.getLog(PrettyFilter.class);
    public static final String CONFIG_FILES_ATTR = "com.ocpsoft.pretty.CONFIG_FILES";
    private final FacesContextBuilder facesContextBuilder = new FacesContextBuilder();
    private final FacesMessagesUtils messagesUtils = new FacesMessagesUtils();
    private static ServletContext servletContext;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI = this.getRequestURI(request);
        if (PrettyFilter.getConfig().isURLMapped(requestURI)) {
            PrettyContext prettyContext = PrettyContext.newInstance((HttpServletRequest)request);
            FacesContext facesContext = this.initFacesContext(request, response);
            prettyContext.injectParameters();
            prettyContext.computeDynamicViewId();
            String viewId = prettyContext.getCurrentCalculatedViewId();
            this.messagesUtils.saveMessages(facesContext, facesContext.getExternalContext().getRequestMap());
            facesContext.release();
            log.info((Object)("Forwarding mapped request [" + requestURI + "] to JSF viewId [" + viewId + "]"));
            if (!response.isCommitted()) {
                request.getRequestDispatcher(viewId).forward(request, response);
            }
        } else {
            this.ensurePopulatedContext(request);
            log.debug((Object)"Request is not mapped using PrettyFaces. Continue.");
            chain.doFilter(request, response);
        }
    }

    private void ensurePopulatedContext(ServletRequest request) {
        PrettyContext.getCurrentInstance((HttpServletRequest)request);
    }

    static PrettyConfig getConfig() {
        if (servletContext == null) {
            log.warn((Object)"PrettyFilter is not registered in web.xml, but is registered with JSF Navigation and Action handlers -- this could cause unpredictable behavior.");
            return new PrettyConfig();
        }
        return (PrettyConfig)servletContext.getAttribute(CONFIG_FILES_ATTR);
    }

    private void setConfig(PrettyConfig config) {
        log.trace((Object)"Setting config into ServletContext");
        servletContext.setAttribute(CONFIG_FILES_ATTR, (Object)config);
    }

    private FacesContext initFacesContext(ServletRequest request, ServletResponse response) {
        log.trace((Object)"Building FacesContext");
        FacesContext facesContext = this.facesContextBuilder.getFacesContext(request, response);
        return facesContext;
    }

    private String getRequestURI(ServletRequest request) {
        String contextPath;
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI.startsWith(contextPath = ((HttpServletRequest)request).getContextPath())) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return requestURI;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        PrettyConfigurator configurator = new PrettyConfigurator(filterConfig.getServletContext());
        try {
            log.info((Object)"PrettyFilter starting up...");
            PrettyConfig config = configurator.configure();
            servletContext = filterConfig.getServletContext();
            this.setConfig(config);
            log.info((Object)"PrettyFilter initialized.");
        }
        catch (IOException ioex) {
            throw new ServletException("Error configuring Pretty Faces, could not load the configuration.", (Throwable)ioex);
        }
        catch (SAXException saxex) {
            throw new ServletException("Error configuring Pretty Faces, could not parse the configuration.", (Throwable)saxex);
        }
    }

    public void destroy() {
    }
}

