/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.application.PrettyRedirector;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyNavigationHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final NavigationHandler parent;
    private PrettyRedirector pr = PrettyRedirector.getInstance();

    public PrettyNavigationHandler(NavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        log.debug((Object)("Navigation requested: fromAction [" + fromAction + "], outcome [" + outcome + "]"));
        if (!this.pr.redirect(context, outcome)) {
            this.processFacesNavigation(context, fromAction, outcome);
        }
    }

    private void processFacesNavigation(FacesContext context, String fromAction, String outcome) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        log.debug((Object)"Not a PrettyFaces navigation string - passing control to default nav-handler");
        prettyContext.setInNavigation(true);
        String originalViewId = context.getViewRoot().getViewId();
        this.parent.handleNavigation(context, fromAction, outcome);
        String newViewId = context.getViewRoot().getViewId();
        if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
            prettyContext.setInNavigation(false);
        }
    }
}

