/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.application.PrettyNavigationHandler;
import com.ocpsoft.pretty.beans.MappingUrlBuilder;
import com.ocpsoft.pretty.config.PrettyConfig;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyRedirector {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final MappingUrlBuilder builder = new MappingUrlBuilder();

    public static PrettyRedirector getInstance() {
        return new PrettyRedirector();
    }

    public boolean redirect(FacesContext context, String action) {
        ExternalContext externalContext;
        PrettyConfig config;
        block5: {
            try {
                PrettyContext prettyContext = PrettyContext.getCurrentInstance();
                config = prettyContext.getConfig();
                externalContext = context.getExternalContext();
                if (!"pretty:".equals(action) || !prettyContext.isPrettyRequest()) break block5;
                String url = prettyContext.getOriginalRequestUrl();
                log.info((Object)("Refreshing requested page [" + url + "]"));
                externalContext.redirect(externalContext.encodeActionURL(url));
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException("PrettyFaces: redirect failed for target: " + action, e);
            }
        }
        if (action != null && config.isMappingId(action)) {
            PrettyUrlMapping mapping = config.getMappingById(action);
            if (mapping == null) {
                throw new PrettyException("PrettyFaces: Invalid mapping id supplied to navigation handler: " + action);
            }
            String url = this.builder.getURL(mapping);
            log.info((Object)("Redirecting to mappingId [" + mapping.getId() + "], [" + url + "]"));
            externalContext.redirect(externalContext.encodeActionURL(url));
            return true;
        }
        return false;
    }
}

