/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.config.mapping.UrlAction;
import com.ocpsoft.pretty.util.FacesElUtils;
import com.ocpsoft.pretty.util.FacesMessagesUtils;
import com.ocpsoft.pretty.util.FacesStateUtils;
import java.util.List;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class ActionExecutor {
    private static final FacesElUtils elUtils = new FacesElUtils();
    private static final FacesStateUtils facesStateUtils = new FacesStateUtils();
    private final FacesMessagesUtils mu = new FacesMessagesUtils();

    public void executeActions(FacesContext context, PhaseId currentPhaseId, PrettyUrlMapping mapping) {
        List<UrlAction> actions = mapping.getActions();
        for (UrlAction action : actions) {
            if (!this.shouldExecute(action, currentPhaseId, facesStateUtils.isPostback(context))) continue;
            try {
                Object result = elUtils.invokeMethod(context, action.getAction());
                if (result == null) continue;
                this.mu.saveMessages(context, context.getExternalContext().getSessionMap());
                String outcome = result.toString();
                if (!"".equals(outcome)) {
                    PrettyContext prettyContext = PrettyContext.getCurrentInstance();
                    NavigationHandler handler = context.getApplication().getNavigationHandler();
                    handler.handleNavigation(context, prettyContext.getCurrentCalculatedViewId(), outcome);
                }
                return;
            }
            catch (Exception e) {
                throw new PrettyException("Exception occurred while processing <" + mapping.getId() + ":" + action.getAction() + "> " + e.getMessage(), e);
            }
        }
    }

    boolean shouldExecute(UrlAction action, PhaseId currentPhaseId, boolean isPostback) {
        boolean result = false;
        if (currentPhaseId.equals(action.getPhaseId()) || PhaseId.ANY_PHASE.equals(action.getPhaseId())) {
            if (action.onPostback()) {
                result = true;
            } else if (!isPostback) {
                result = true;
            }
        }
        return result;
    }
}

