/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.beans;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.config.mapping.QueryParameter;
import com.ocpsoft.pretty.util.FacesElUtils;
import com.ocpsoft.pretty.util.UrlPatternParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class MappingUrlBuilder {
    private static final FacesElUtils elUtils = new FacesElUtils();

    public String getURL(PrettyUrlMapping mapping) {
        UrlPatternParser um = new UrlPatternParser(mapping.getPattern());
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuffer sb = new StringBuffer();
        String result = mapping.getPattern();
        String expression = "";
        Object value = null;
        try {
            Map<String, String> parameters = um.getMappedParameters(mapping.getPattern());
            for (Map.Entry<String, String> injection : parameters.entrySet()) {
                expression = injection.getKey();
                value = elUtils.getValue(context, expression);
                if (value == null) {
                    throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Required value " + " < " + expression + " > was null");
                }
                value = URLEncoder.encode(value.toString(), "UTF-8");
                result = result.replace(expression, value.toString());
            }
            List<QueryParameter> queryParams = mapping.getQueryParams();
            boolean paramWritten = false;
            for (QueryParameter injection : queryParams) {
                String name = injection.getName();
                expression = injection.getExpression();
                value = elUtils.getValue(context, expression);
                if (name == null || value == null) continue;
                String pv = value.toString();
                sb.append(paramWritten ? (char)'&' : '?');
                sb.append(URLEncoder.encode(name.toString(), "UTF-8"));
                sb.append('=');
                if (value != null && pv.length() != 0) {
                    sb.append(URLEncoder.encode(pv, "UTF-8"));
                }
                paramWritten = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Error occurred while attempting to encode value < " + expression + ":" + value + " >", e);
        }
        catch (ELException e) {
            throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Error occurred while extracting values from backing bean" + " < " + expression + ":" + value + " >", e);
        }
        String contextPath = ((HttpServletRequest)context.getExternalContext().getRequest()).getContextPath();
        return String.valueOf(contextPath) + result + sb.toString();
    }
}

