/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.config.mapping.QueryParameter;
import com.ocpsoft.pretty.util.FacesElUtils;
import com.ocpsoft.pretty.util.HTTPDecoder;
import com.ocpsoft.pretty.util.UrlPatternParser;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;

public class ParameterInjector {
    private static final FacesElUtils elUtils = new FacesElUtils();
    private static final HTTPDecoder decoder = new HTTPDecoder();

    public void injectParameters(FacesContext context) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        String url = prettyContext.stripContextPath(prettyContext.getOriginalUri());
        for (PrettyUrlMapping mapping : prettyContext.getConfig().getMappings()) {
            UrlPatternParser parser = new UrlPatternParser(mapping.getPattern());
            if (!parser.matches(url)) continue;
            this.injectParams(context, url, mapping, parser);
            this.injectQueryParams(context, mapping);
        }
    }

    private void injectQueryParams(FacesContext context, PrettyUrlMapping mapping) {
        List<QueryParameter> params = mapping.getQueryParams();
        if (params != null) {
            for (QueryParameter param : params) {
                String name = param.getName();
                String el = param.getExpression();
                try {
                    if (elUtils.getExpectedType(context, el).isArray()) {
                        String[] values = (String[])context.getExternalContext().getRequestParameterValuesMap().get(name);
                        if (values == null) continue;
                        int i = 0;
                        while (i < values.length) {
                            if (param.decode()) {
                                values[i] = decoder.decode(values[i]);
                            }
                            ++i;
                        }
                        elUtils.setValue(context, el, values);
                        continue;
                    }
                    String value = (String)context.getExternalContext().getRequestParameterMap().get(name);
                    if (param.decode()) {
                        value = decoder.decode(value);
                    }
                    if (value == null) continue;
                    elUtils.setValue(context, el, value);
                }
                catch (Exception e) {
                    throw new PrettyException("PrettyFaces: Exception occurred while processing mapping<" + mapping.getId() + ":" + el + "> for query parameter named<" + name + "> " + e.getMessage(), e);
                }
            }
        }
    }

    private void injectParams(FacesContext context, String url, PrettyUrlMapping mapping, UrlPatternParser parser) {
        Map<String, String> params = parser.getMappedParameters(url);
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                String el = param.getKey();
                String value = param.getValue();
                try {
                    value = decoder.decode(value);
                    elUtils.setValue(context, el, value);
                }
                catch (Exception e) {
                    throw new PrettyException("PrettyFaces: Exception occurred while processing <" + mapping.getId() + ":" + el + "> for URL <" + url + ">", e);
                }
            }
        }
    }
}

